/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream.expr;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.MapSerializable;

public class Explanation
implements MapSerializable {
    private String expressionNodeId;
    private String expressionType;
    private String functionName;
    private String implementingClass;
    private String expression;
    private String note;
    private List<Explanation> helpers;

    public Explanation(String expressionNodeId) {
        this.expressionNodeId = expressionNodeId;
    }

    public String getExpressionNodeId() {
        return this.expressionNodeId;
    }

    public String getExpressionType() {
        return this.expressionType;
    }

    public void setExpressionType(String expressionType) {
        this.expressionType = expressionType;
    }

    public Explanation withExpressionType(String expressionType) {
        this.setExpressionType(expressionType);
        return this;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public Explanation withFunctionName(String functionName) {
        this.setFunctionName(functionName);
        return this;
    }

    public String getImplementingClass() {
        return this.implementingClass;
    }

    public void setImplementingClass(String implementingClass) {
        this.implementingClass = implementingClass;
    }

    public Explanation withImplementingClass(String implementingClass) {
        this.setImplementingClass(implementingClass);
        return this;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public Explanation withExpression(String expression) {
        this.setExpression(expression);
        return this;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Explanation withNote(String note) {
        this.setNote(note);
        return this;
    }

    public List<Explanation> getHelpers() {
        return this.helpers;
    }

    public void setHelpers(List<Explanation> helpers) {
        this.helpers = helpers;
    }

    public Explanation withHelpers(List<Explanation> helpers) {
        this.setHelpers(helpers);
        return this;
    }

    public Explanation withHelpers(Explanation[] helpers) {
        for (Explanation helper : helpers) {
            this.addHelper(helper);
        }
        return this;
    }

    public Explanation withHelper(Explanation helper) {
        this.addHelper(helper);
        return this;
    }

    public void addHelper(Explanation helper) {
        if (null == this.helpers) {
            this.helpers = new ArrayList<Explanation>(1);
        }
        this.helpers.add(helper);
    }

    @Override
    public Map toMap(Map<String, Object> map) {
        if (null != this.expressionNodeId) {
            map.put("expressionNodeId", this.expressionNodeId);
        }
        if (null != this.expressionType) {
            map.put("expressionType", this.expressionType);
        }
        if (null != this.functionName) {
            map.put("functionName", this.functionName);
        }
        if (null != this.implementingClass) {
            map.put("implementingClass", this.implementingClass);
        }
        if (null != this.expression) {
            map.put("expression", this.expression);
        }
        if (null != this.note) {
            map.put("note", this.note);
        }
        if (null != this.helpers && 0 != this.helpers.size()) {
            ArrayList<Map> helperMaps = new ArrayList<Map>();
            for (Explanation helper : this.helpers) {
                helperMaps.add(helper.toMap(new LinkedHashMap<String, Object>()));
            }
            map.put("helpers", helperMaps);
        }
        return map;
    }

    public static interface ExpressionType {
        public static final String GRAPH_SOURCE = "graph-source";
        public static final String MACHINE_LEARNING_MODEL = "ml-model";
        public static final String STREAM_SOURCE = "stream-source";
        public static final String STREAM_DECORATOR = "stream-decorator";
        public static final String DATASTORE = "datastore";
        public static final String METRIC = "metric";
        public static final String OPERATION = "operation";
        public static final String EVALUATOR = "evaluator";
        public static final String EQUALITOR = "equalitor";
        public static final String SORTER = "sorter";
    }
}

