/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.cloud.autoscaling.Violation;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.Pair;

class AddReplicaSuggester
extends Suggester {
    AddReplicaSuggester() {
    }

    @Override
    SolrRequest init() {
        SolrRequest operation = this.tryEachNode(true);
        if (operation == null) {
            operation = this.tryEachNode(false);
        }
        return operation;
    }

    SolrRequest tryEachNode(boolean strict) {
        Set shards = this.hints.getOrDefault((Object)Suggester.Hint.COLL_SHARD, Collections.emptySet());
        if (shards.isEmpty()) {
            throw new RuntimeException("add-replica requires 'collection' and 'shard'");
        }
        for (Pair shard : shards) {
            Replica.Type type = Replica.Type.get((String)this.hints.get((Object)Suggester.Hint.REPLICATYPE));
            List<Violation> leastSeriousViolation = null;
            Row bestNode = null;
            for (int i = this.getMatrix().size() - 1; i >= 0; --i) {
                Row row = this.getMatrix().get(i);
                if (!this.isNodeSuitableForReplicaAddition(row)) continue;
                Row tmpRow = row.addReplica((String)shard.first(), (String)shard.second(), type);
                List<Violation> errs = this.testChangedMatrix(strict, tmpRow.session.matrix);
                if (this.containsNewErrors(errs) || !this.isLessSerious(errs, leastSeriousViolation)) continue;
                leastSeriousViolation = errs;
                bestNode = tmpRow;
            }
            if (bestNode == null) continue;
            this.session = bestNode.session;
            return CollectionAdminRequest.addReplicaToShard((String)shard.first(), (String)shard.second()).setType(type).setNode(bestNode.node);
        }
        return null;
    }

    @Override
    public CollectionParams.CollectionAction getAction() {
        return CollectionParams.CollectionAction.ADDREPLICA;
    }
}

