/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import com.google.common.base.Splitter;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RuleDefinitionViolationException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RuleInUsedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropShardingTableRuleStatement;

public final class DropShardingTableRuleStatementUpdater
implements RuleDefinitionDropUpdater<DropShardingTableRuleStatement, ShardingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, DropShardingTableRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws RuleDefinitionViolationException {
        if (!this.isExistRuleConfig((RuleConfiguration)currentRuleConfig) && sqlStatement.isContainsExistClause()) {
            return;
        }
        String databaseName = database.getName();
        this.checkCurrentRuleConfiguration(databaseName, currentRuleConfig);
        this.checkToBeDroppedShardingTableNames(databaseName, sqlStatement, currentRuleConfig);
        this.checkBindingTables(databaseName, sqlStatement, currentRuleConfig);
    }

    private void checkCurrentRuleConfiguration(String databaseName, ShardingRuleConfiguration currentRuleConfig) throws RequiredRuleMissedException {
        if (null == currentRuleConfig) {
            throw new RequiredRuleMissedException("Sharding", databaseName);
        }
    }

    private Collection<String> getToBeDroppedShardingTableNames(DropShardingTableRuleStatement sqlStatement) {
        return sqlStatement.getTableNames().stream().map(each -> each.getIdentifier().getValue()).collect(Collectors.toList());
    }

    private void checkToBeDroppedShardingTableNames(String databaseName, DropShardingTableRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws RequiredRuleMissedException {
        if (sqlStatement.isContainsExistClause()) {
            return;
        }
        Collection<String> currentShardingTableNames = this.getCurrentShardingTableNames(currentRuleConfig);
        Collection notExistedTableNames = this.getToBeDroppedShardingTableNames(sqlStatement).stream().filter(each -> !this.containsIgnoreCase(currentShardingTableNames, (String)each)).collect(Collectors.toList());
        if (!notExistedTableNames.isEmpty()) {
            throw new RequiredRuleMissedException("sharding", databaseName, notExistedTableNames);
        }
    }

    private boolean containsIgnoreCase(Collection<String> collection, String str) {
        return collection.stream().anyMatch(each -> each.equalsIgnoreCase(str));
    }

    private Collection<String> getCurrentShardingTableNames(ShardingRuleConfiguration shardingRuleConfig) {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(shardingRuleConfig.getTables().stream().map(ShardingTableRuleConfiguration::getLogicTable).collect(Collectors.toList()));
        result.addAll(shardingRuleConfig.getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getLogicTable).collect(Collectors.toList()));
        return result;
    }

    private void checkBindingTables(String databaseName, DropShardingTableRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws RuleInUsedException {
        Collection<String> bindingTables = this.getBindingTables(currentRuleConfig);
        Collection usedTableNames = this.getToBeDroppedShardingTableNames(sqlStatement).stream().filter(each -> this.containsIgnoreCase(bindingTables, (String)each)).collect(Collectors.toList());
        if (!usedTableNames.isEmpty()) {
            throw new RuleInUsedException("Sharding", databaseName, usedTableNames);
        }
    }

    private Collection<String> getBindingTables(ShardingRuleConfiguration shardingRuleConfig) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        shardingRuleConfig.getBindingTableGroups().forEach(each -> result.addAll(Splitter.on((String)",").splitToList((CharSequence)each)));
        return result;
    }

    public boolean hasAnyOneToBeDropped(DropShardingTableRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        if (null == currentRuleConfig) {
            return false;
        }
        LinkedList currentTableNames = new LinkedList();
        currentTableNames.addAll(currentRuleConfig.getTables().stream().map(ShardingTableRuleConfiguration::getLogicTable).collect(Collectors.toSet()));
        currentTableNames.addAll(currentRuleConfig.getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getLogicTable).collect(Collectors.toSet()));
        return !this.getIdenticalData(currentTableNames, sqlStatement.getTableNames().stream().map(each -> each.getIdentifier().getValue()).collect(Collectors.toSet())).isEmpty();
    }

    public boolean updateCurrentRuleConfiguration(DropShardingTableRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        boolean dropUnusedAlgorithms = sqlStatement.isDropUnusedAlgorithms();
        Collection<String> toBeDroppedShardingTableNames = this.getToBeDroppedShardingTableNames(sqlStatement);
        toBeDroppedShardingTableNames.forEach(each -> this.dropShardingTable(currentRuleConfig, (String)each));
        if (dropUnusedAlgorithms) {
            toBeDroppedShardingTableNames.forEach(each -> this.dropUnusedAlgorithms(currentRuleConfig));
        }
        return false;
    }

    private void dropUnusedAlgorithms(ShardingRuleConfiguration currentRuleConfig) {
        Collection inUsedAlgorithms = currentRuleConfig.getTables().stream().map(each -> Arrays.asList(each.getTableShardingStrategy(), each.getDatabaseShardingStrategy())).flatMap(Collection::stream).filter(Objects::nonNull).map(ShardingStrategyConfiguration::getShardingAlgorithmName).collect(Collectors.toSet());
        inUsedAlgorithms.addAll(currentRuleConfig.getAutoTables().stream().map(each -> each.getShardingStrategy().getShardingAlgorithmName()).collect(Collectors.toSet()));
        if (null != currentRuleConfig.getDefaultTableShardingStrategy()) {
            inUsedAlgorithms.add(currentRuleConfig.getDefaultTableShardingStrategy().getShardingAlgorithmName());
        }
        if (null != currentRuleConfig.getDefaultDatabaseShardingStrategy()) {
            inUsedAlgorithms.add(currentRuleConfig.getDefaultDatabaseShardingStrategy().getShardingAlgorithmName());
        }
        Collection unusedAlgorithms = currentRuleConfig.getShardingAlgorithms().keySet().stream().filter(each -> !inUsedAlgorithms.contains(each)).collect(Collectors.toSet());
        unusedAlgorithms.forEach(each -> currentRuleConfig.getShardingAlgorithms().remove(each));
    }

    private void dropShardingTable(ShardingRuleConfiguration currentRuleConfig, String tableName) {
        currentRuleConfig.getTables().removeAll(currentRuleConfig.getTables().stream().filter(each -> tableName.equalsIgnoreCase(each.getLogicTable())).collect(Collectors.toList()));
        currentRuleConfig.getAutoTables().removeAll(currentRuleConfig.getAutoTables().stream().filter(each -> tableName.equalsIgnoreCase(each.getLogicTable())).collect(Collectors.toList()));
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public String getType() {
        return DropShardingTableRuleStatement.class.getName();
    }
}

