/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.KeyGeneratorInUsedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredKeyGeneratorMissedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropShardingKeyGeneratorStatement;

public final class DropShardingKeyGeneratorStatementUpdater
implements RuleDefinitionDropUpdater<DropShardingKeyGeneratorStatement, ShardingRuleConfiguration> {
    private static final String TYPE = DropShardingKeyGeneratorStatement.class.getName();

    public void checkSQLStatement(ShardingSphereDatabase database, DropShardingKeyGeneratorStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (null == currentRuleConfig && sqlStatement.isContainsExistClause()) {
            return;
        }
        String databaseName = database.getName();
        LinkedList<String> keyGeneratorNames = new LinkedList<String>(sqlStatement.getKeyGeneratorNames());
        this.checkExist(databaseName, keyGeneratorNames, currentRuleConfig, sqlStatement);
        this.checkInUsed(databaseName, keyGeneratorNames, currentRuleConfig);
    }

    private void checkExist(String databaseName, Collection<String> keyGeneratorNames, ShardingRuleConfiguration currentRuleConfig, DropShardingKeyGeneratorStatement sqlStatement) throws DistSQLException {
        if (sqlStatement.isContainsExistClause()) {
            return;
        }
        Collection notExistKeyGenerators = keyGeneratorNames.stream().filter(each -> !currentRuleConfig.getKeyGenerators().containsKey(each)).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)notExistKeyGenerators.isEmpty(), () -> new RequiredKeyGeneratorMissedException("Sharding", databaseName, notExistKeyGenerators));
    }

    private void checkInUsed(String databaseName, Collection<String> keyGeneratorNames, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        Collection<String> usedKeyGenerators = this.getUsedKeyGenerators(currentRuleConfig);
        Collection inUsedNames = keyGeneratorNames.stream().filter(usedKeyGenerators::contains).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)inUsedNames.isEmpty(), () -> new KeyGeneratorInUsedException("Sharding", databaseName, inUsedNames));
    }

    public boolean updateCurrentRuleConfiguration(DropShardingKeyGeneratorStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getKeyGenerators().keySet().removeIf(sqlStatement.getKeyGeneratorNames()::contains);
        return false;
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public String getType() {
        return TYPE;
    }

    private Collection<String> getUsedKeyGenerators(ShardingRuleConfiguration shardingRuleConfig) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        shardingRuleConfig.getTables().stream().filter(each -> Objects.nonNull(each.getKeyGenerateStrategy())).forEach(each -> result.add(each.getKeyGenerateStrategy().getKeyGeneratorName()));
        shardingRuleConfig.getAutoTables().stream().filter(each -> Objects.nonNull(each.getKeyGenerateStrategy())).forEach(each -> result.add(each.getKeyGenerateStrategy().getKeyGeneratorName()));
        KeyGenerateStrategyConfiguration keyGenerateStrategy = shardingRuleConfig.getDefaultKeyGenerateStrategy();
        if (Objects.nonNull(keyGenerateStrategy) && !Strings.isNullOrEmpty((String)keyGenerateStrategy.getKeyGeneratorName())) {
            result.add(keyGenerateStrategy.getKeyGeneratorName());
        }
        return result;
    }

    public boolean hasAnyOneToBeDropped(DropShardingKeyGeneratorStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        return null != currentRuleConfig && !this.getIdenticalData(currentRuleConfig.getKeyGenerators().keySet(), sqlStatement.getKeyGeneratorNames()).isEmpty();
    }
}

