/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropShardingBroadcastTableRulesStatement;

public final class DropShardingBroadcastTableRuleStatementUpdater
implements RuleDefinitionDropUpdater<DropShardingBroadcastTableRulesStatement, ShardingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, DropShardingBroadcastTableRulesStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        String databaseName = database.getName();
        if (!this.isExistRuleConfig((RuleConfiguration)currentRuleConfig) && sqlStatement.isContainsExistClause()) {
            return;
        }
        this.checkCurrentRuleConfiguration(databaseName, currentRuleConfig);
        this.checkBroadcastTableRuleExist(databaseName, sqlStatement, currentRuleConfig);
    }

    private void checkBroadcastTableRuleExist(String databaseName, DropShardingBroadcastTableRulesStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (sqlStatement.isContainsExistClause()) {
            return;
        }
        if (!sqlStatement.getRules().isEmpty()) {
            Collection currentRules = currentRuleConfig.getBroadcastTables();
            Collection notExistRules = sqlStatement.getRules().stream().filter(each -> !this.containsIgnoreCase(currentRules, (String)each)).collect(Collectors.toList());
            DistSQLException.predictionThrow((boolean)notExistRules.isEmpty(), () -> new RequiredRuleMissedException("Broadcast", databaseName, notExistRules));
        }
    }

    private boolean containsIgnoreCase(Collection<String> collection, String str) {
        return collection.stream().anyMatch(each -> each.equalsIgnoreCase(str));
    }

    private void checkCurrentRuleConfiguration(String databaseName, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        DistSQLException.predictionThrow((null != currentRuleConfig ? 1 : 0) != 0, () -> new RequiredRuleMissedException("Broadcast", databaseName));
    }

    public boolean hasAnyOneToBeDropped(DropShardingBroadcastTableRulesStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        if (sqlStatement.getRules().isEmpty()) {
            return true;
        }
        return this.isExistRuleConfig((RuleConfiguration)currentRuleConfig) && !this.getIdenticalData(currentRuleConfig.getBroadcastTables(), sqlStatement.getRules()).isEmpty();
    }

    public boolean updateCurrentRuleConfiguration(DropShardingBroadcastTableRulesStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        if (sqlStatement.getRules().isEmpty()) {
            currentRuleConfig.getBroadcastTables().clear();
        } else {
            currentRuleConfig.getBroadcastTables().removeIf(each -> this.containsIgnoreCase(sqlStatement.getRules(), (String)each));
        }
        return false;
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public String getType() {
        return DropShardingBroadcastTableRulesStatement.class.getName();
    }
}

