/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import java.util.Optional;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.enums.ShardingStrategyLevelType;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropDefaultShardingStrategyStatement;

public final class DropDefaultStrategyStatementUpdater
implements RuleDefinitionDropUpdater<DropDefaultShardingStrategyStatement, ShardingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, DropDefaultShardingStrategyStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (!this.isExistRuleConfig((RuleConfiguration)currentRuleConfig) && sqlStatement.isContainsExistClause()) {
            return;
        }
        String databaseName = database.getName();
        this.checkCurrentRuleConfiguration(databaseName, currentRuleConfig);
        this.checkExist(databaseName, sqlStatement, currentRuleConfig);
    }

    private void checkExist(String databaseName, DropDefaultShardingStrategyStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (sqlStatement.isContainsExistClause()) {
            return;
        }
        Optional<ShardingStrategyConfiguration> strategyConfig = this.getStrategyConfiguration(currentRuleConfig, sqlStatement.getDefaultType());
        DistSQLException.predictionThrow((boolean)strategyConfig.isPresent(), () -> new RequiredRuleMissedException(String.format("Default sharding %s strategy", sqlStatement.getDefaultType().toLowerCase()), databaseName));
    }

    private Optional<ShardingStrategyConfiguration> getStrategyConfiguration(ShardingRuleConfiguration currentRuleConfig, String type) {
        ShardingStrategyConfiguration result = type.equalsIgnoreCase(ShardingStrategyLevelType.TABLE.name()) ? currentRuleConfig.getDefaultTableShardingStrategy() : currentRuleConfig.getDefaultDatabaseShardingStrategy();
        return Optional.ofNullable(result);
    }

    private void checkCurrentRuleConfiguration(String databaseName, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        DistSQLException.predictionThrow((currentRuleConfig != null ? 1 : 0) != 0, () -> new RequiredRuleMissedException("Sharding", databaseName));
    }

    public boolean hasAnyOneToBeDropped(DropDefaultShardingStrategyStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        if (sqlStatement.getDefaultType().equalsIgnoreCase(ShardingStrategyLevelType.TABLE.name())) {
            return null != currentRuleConfig && null != currentRuleConfig.getDefaultTableShardingStrategy();
        }
        return null != currentRuleConfig && null != currentRuleConfig.getDefaultDatabaseShardingStrategy();
    }

    public boolean updateCurrentRuleConfiguration(DropDefaultShardingStrategyStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        if (sqlStatement.getDefaultType().equalsIgnoreCase(ShardingStrategyLevelType.TABLE.name())) {
            currentRuleConfig.setDefaultTableShardingStrategy(null);
        } else {
            currentRuleConfig.setDefaultDatabaseShardingStrategy(null);
        }
        return false;
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public String getType() {
        return DropDefaultShardingStrategyStatement.class.getName();
    }
}

