/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import org.apache.shardingsphere.infra.distsql.exception.rule.RuleDefinitionViolationException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RuleInUsedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionCreateUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.CreateShardingBroadcastTableRulesStatement;

public final class CreateShardingBroadcastTableRuleStatementUpdater
implements RuleDefinitionCreateUpdater<CreateShardingBroadcastTableRulesStatement, ShardingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, CreateShardingBroadcastTableRulesStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws RuleDefinitionViolationException {
        this.checkCurrentRuleConfiguration(database.getName(), currentRuleConfig);
    }

    private void checkCurrentRuleConfiguration(String databaseName, ShardingRuleConfiguration currentRuleConfig) throws RuleInUsedException {
        if (null != currentRuleConfig && !currentRuleConfig.getBroadcastTables().isEmpty()) {
            throw new RuleInUsedException("Broadcast", databaseName);
        }
    }

    public ShardingRuleConfiguration buildToBeCreatedRuleConfiguration(CreateShardingBroadcastTableRulesStatement sqlStatement) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        result.setBroadcastTables(sqlStatement.getTables());
        return result;
    }

    public void updateCurrentRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, ShardingRuleConfiguration toBeCreatedRuleConfig) {
        if (null != currentRuleConfig) {
            currentRuleConfig.getBroadcastTables().addAll(toBeCreatedRuleConfig.getBroadcastTables());
        }
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public String getType() {
        return CreateShardingBroadcastTableRulesStatement.class.getName();
    }
}

