/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionCreateUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.segment.BindingTableRuleSegment;
import org.apache.shardingsphere.sharding.distsql.parser.statement.CreateShardingBindingTableRulesStatement;

public final class CreateShardingBindingTableRuleStatementUpdater
implements RuleDefinitionCreateUpdater<CreateShardingBindingTableRulesStatement, ShardingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, CreateShardingBindingTableRulesStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        String databaseName = database.getName();
        this.checkCurrentRuleConfiguration(databaseName, currentRuleConfig);
        this.checkToBeCreatedBindingTables(databaseName, sqlStatement, currentRuleConfig);
        this.checkToBeCreatedDuplicateBindingTables(databaseName, sqlStatement, currentRuleConfig);
    }

    private void checkCurrentRuleConfiguration(String databaseName, ShardingRuleConfiguration currentRuleConfig) throws RequiredRuleMissedException {
        if (null == currentRuleConfig) {
            throw new RequiredRuleMissedException("Sharding", databaseName);
        }
    }

    private void checkToBeCreatedBindingTables(String databaseName, CreateShardingBindingTableRulesStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        Collection<String> currentLogicTables = this.getCurrentLogicTables(currentRuleConfig);
        Collection notExistedBindingTables = sqlStatement.getBindingTables().stream().filter(each -> !this.containsIgnoreCase(currentLogicTables, (String)each)).collect(Collectors.toSet());
        DistSQLException.predictionThrow((boolean)notExistedBindingTables.isEmpty(), () -> new RequiredRuleMissedException("Sharding", databaseName, notExistedBindingTables));
    }

    private boolean containsIgnoreCase(Collection<String> collection, String str) {
        return collection.stream().anyMatch(each -> each.equalsIgnoreCase(str));
    }

    private Collection<String> getCurrentLogicTables(ShardingRuleConfiguration currentRuleConfig) {
        HashSet<String> result = new HashSet<String>();
        result.addAll(currentRuleConfig.getTables().stream().map(ShardingTableRuleConfiguration::getLogicTable).collect(Collectors.toSet()));
        result.addAll(currentRuleConfig.getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getLogicTable).collect(Collectors.toSet()));
        return result;
    }

    private void checkToBeCreatedDuplicateBindingTables(String databaseName, CreateShardingBindingTableRulesStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DuplicateRuleException {
        HashSet toBeCreatedBindingTables = new HashSet();
        Collection duplicateBindingTables = sqlStatement.getBindingTables().stream().filter(each -> !toBeCreatedBindingTables.add(each.toLowerCase())).collect(Collectors.toSet());
        duplicateBindingTables.addAll(this.getCurrentBindingTables(currentRuleConfig).stream().filter(each -> !toBeCreatedBindingTables.add(each.toLowerCase())).collect(Collectors.toSet()));
        Collection duplicatedBindingTablesForDisplay = sqlStatement.getBindingTables().stream().filter(each -> this.containsIgnoreCase(duplicateBindingTables, (String)each)).collect(Collectors.toSet());
        if (!duplicatedBindingTablesForDisplay.isEmpty()) {
            throw new DuplicateRuleException("binding", databaseName, duplicateBindingTables);
        }
    }

    private Collection<String> getCurrentBindingTables(ShardingRuleConfiguration currentRuleConfig) {
        return currentRuleConfig.getBindingTableGroups().stream().flatMap(each -> Arrays.stream(each.split(","))).map(String::trim).collect(Collectors.toList());
    }

    public ShardingRuleConfiguration buildToBeCreatedRuleConfiguration(CreateShardingBindingTableRulesStatement sqlStatement) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        for (BindingTableRuleSegment each : sqlStatement.getRules()) {
            result.getBindingTableGroups().add(each.getTableGroups());
        }
        return result;
    }

    public void updateCurrentRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, ShardingRuleConfiguration toBeCreatedRuleConfig) {
        if (null != currentRuleConfig) {
            currentRuleConfig.getBindingTableGroups().addAll(toBeCreatedRuleConfig.getBindingTableGroups());
        }
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public String getType() {
        return CreateShardingBindingTableRulesStatement.class.getName();
    }
}

