/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionCreateUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.converter.ShardingTableRuleStatementConverter;
import org.apache.shardingsphere.sharding.distsql.parser.segment.ShardingAlgorithmSegment;
import org.apache.shardingsphere.sharding.distsql.parser.statement.CreateShardingAlgorithmStatement;
import org.apache.shardingsphere.sharding.factory.ShardingAlgorithmFactory;

public final class CreateShardingAlgorithmStatementUpdater
implements RuleDefinitionCreateUpdater<CreateShardingAlgorithmStatement, ShardingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, CreateShardingAlgorithmStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        String databaseName = database.getName();
        this.checkDuplicate(databaseName, sqlStatement, currentRuleConfig);
        this.checkAlgorithm(sqlStatement);
    }

    private void checkDuplicate(String databaseName, CreateShardingAlgorithmStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        Collection shardingAlgorithmNames = sqlStatement.getAlgorithmSegments().stream().map(ShardingAlgorithmSegment::getShardingAlgorithmName).collect(Collectors.toList());
        this.checkDuplicateInput(shardingAlgorithmNames, duplicated -> new DuplicateRuleException("sharding", databaseName, duplicated));
        if (currentRuleConfig != null) {
            this.checkExist(shardingAlgorithmNames, currentRuleConfig.getShardingAlgorithms().keySet(), duplicated -> new DuplicateRuleException("sharding", databaseName, duplicated));
        }
    }

    private void checkDuplicateInput(Collection<String> rules, Function<Collection<String>, DistSQLException> thrower) throws DistSQLException {
        Collection duplicateRequire = rules.stream().collect(Collectors.groupingBy(each -> each, Collectors.counting())).entrySet().stream().filter(each -> (Long)each.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        DistSQLException.predictionThrow((boolean)duplicateRequire.isEmpty(), () -> (DistSQLException)thrower.apply(duplicateRequire));
    }

    private void checkExist(Collection<String> requireRules, Collection<String> currentRules, Function<Collection<String>, DistSQLException> thrower) throws DistSQLException {
        Collection identical = requireRules.stream().filter(currentRules::contains).collect(Collectors.toSet());
        DistSQLException.predictionThrow((boolean)identical.isEmpty(), () -> (DistSQLException)thrower.apply(identical));
    }

    private void checkAlgorithm(CreateShardingAlgorithmStatement sqlStatement) throws DistSQLException {
        Collection notExistedShardingAlgorithms = sqlStatement.getAlgorithmSegments().stream().map(ShardingAlgorithmSegment::getAlgorithmSegment).map(AlgorithmSegment::getName).filter(each -> !ShardingAlgorithmFactory.contains((String)each)).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)notExistedShardingAlgorithms.isEmpty(), () -> new InvalidAlgorithmConfigurationException("sharding", notExistedShardingAlgorithms));
    }

    public ShardingRuleConfiguration buildToBeCreatedRuleConfiguration(CreateShardingAlgorithmStatement sqlStatement) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        Map<String, ShardingSphereAlgorithmConfiguration> algorithmConfigMap = sqlStatement.getAlgorithmSegments().stream().collect(Collectors.toMap(ShardingAlgorithmSegment::getShardingAlgorithmName, each -> ShardingTableRuleStatementConverter.createAlgorithmConfiguration(each.getAlgorithmSegment())));
        result.setShardingAlgorithms(algorithmConfigMap);
        return result;
    }

    public void updateCurrentRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, ShardingRuleConfiguration toBeCreatedRuleConfig) {
        if (null != currentRuleConfig) {
            currentRuleConfig.getShardingAlgorithms().putAll(toBeCreatedRuleConfig.getShardingAlgorithms());
        }
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public String getType() {
        return CreateShardingAlgorithmStatement.class.getName();
    }
}

