/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.properties.PropertiesConverter;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowUnusedShardingKeyGeneratorsStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class UnusedShardingKeyGeneratorsQueryResultSet
implements DistSQLResultSet {
    private static final String TYPE = ShowUnusedShardingKeyGeneratorsStatement.class.getName();
    private static final String NAME = "name";
    private static final String COLUMN_TYPE = "type";
    private static final String PROPS = "props";
    private Iterator<Map.Entry<String, ShardingSphereAlgorithmConfiguration>> data = Collections.emptyIterator();

    public void init(ShardingSphereDatabase database, SQLStatement sqlStatement) {
        Optional<ShardingRuleConfiguration> ruleConfig = database.getRuleMetaData().getConfigurations().stream().filter(each -> each instanceof ShardingRuleConfiguration).map(each -> (ShardingRuleConfiguration)each).findAny();
        ruleConfig.ifPresent(this::getUnusedKeyGenerators);
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList(NAME, COLUMN_TYPE, PROPS);
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.buildTableRowData(this.data.next());
    }

    private Collection<Object> buildTableRowData(Map.Entry<String, ShardingSphereAlgorithmConfiguration> data) {
        LinkedList<Object> result = new LinkedList<Object>();
        result.add(data.getKey());
        result.add(data.getValue().getType());
        result.add(this.buildProps(data.getValue().getProps()));
        return result;
    }

    private Object buildProps(Properties props) {
        return Objects.nonNull(props) ? PropertiesConverter.convert((Properties)props) : "";
    }

    public String getType() {
        return TYPE;
    }

    private void getUnusedKeyGenerators(ShardingRuleConfiguration shardingRuleConfig) {
        Collection<String> inUsedKeyGenerators = this.getUsedKeyGenerators(shardingRuleConfig);
        HashMap<String, ShardingSphereAlgorithmConfiguration> map = new HashMap<String, ShardingSphereAlgorithmConfiguration>();
        for (Map.Entry each : shardingRuleConfig.getKeyGenerators().entrySet()) {
            if (inUsedKeyGenerators.contains(each.getKey())) continue;
            map.put((String)each.getKey(), (ShardingSphereAlgorithmConfiguration)each.getValue());
        }
        this.data = map.entrySet().iterator();
    }

    private Collection<String> getUsedKeyGenerators(ShardingRuleConfiguration shardingRuleConfig) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        shardingRuleConfig.getTables().stream().filter(each -> Objects.nonNull(each.getKeyGenerateStrategy())).forEach(each -> result.add(each.getKeyGenerateStrategy().getKeyGeneratorName()));
        shardingRuleConfig.getAutoTables().stream().filter(each -> Objects.nonNull(each.getKeyGenerateStrategy())).forEach(each -> result.add(each.getKeyGenerateStrategy().getKeyGeneratorName()));
        KeyGenerateStrategyConfiguration keyGenerateStrategy = shardingRuleConfig.getDefaultKeyGenerateStrategy();
        if (Objects.nonNull(keyGenerateStrategy) && !Strings.isNullOrEmpty((String)keyGenerateStrategy.getKeyGeneratorName())) {
            result.add(keyGenerateStrategy.getKeyGeneratorName());
        }
        return result;
    }
}

