/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingTableRulesUsedAlgorithmStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ShardingTableRulesUsedAlgorithmQueryResultSet
implements DistSQLResultSet {
    private Iterator<Collection<Object>> data = Collections.emptyIterator();

    public void init(ShardingSphereDatabase database, SQLStatement sqlStatement) {
        ShowShardingTableRulesUsedAlgorithmStatement statement = (ShowShardingTableRulesUsedAlgorithmStatement)sqlStatement;
        LinkedList data = new LinkedList();
        Collection shardingTableRules = database.getRuleMetaData().findRuleConfigurations(ShardingRuleConfiguration.class);
        shardingTableRules.forEach(each -> this.requireResult(statement, data, (ShardingRuleConfiguration)each));
        this.data = data.iterator();
    }

    private void requireResult(ShowShardingTableRulesUsedAlgorithmStatement statement, Collection<Collection<Object>> data, ShardingRuleConfiguration shardingRuleConfig) {
        if (!statement.getAlgorithmName().isPresent()) {
            return;
        }
        String algorithmName = (String)statement.getAlgorithmName().get();
        boolean matchDefaultDatabaseShardingStrategy = null != shardingRuleConfig.getDefaultDatabaseShardingStrategy() && algorithmName.equals(shardingRuleConfig.getDefaultDatabaseShardingStrategy().getShardingAlgorithmName());
        boolean matchDefaultTableShardingStrategy = null != shardingRuleConfig.getDefaultTableShardingStrategy() && algorithmName.equals(shardingRuleConfig.getDefaultTableShardingStrategy().getShardingAlgorithmName());
        shardingRuleConfig.getTables().forEach(each -> {
            if (null == each.getDatabaseShardingStrategy() && matchDefaultDatabaseShardingStrategy || null != each.getDatabaseShardingStrategy() && algorithmName.equals(each.getDatabaseShardingStrategy().getShardingAlgorithmName()) || null == each.getTableShardingStrategy() && matchDefaultTableShardingStrategy || null != each.getTableShardingStrategy() && algorithmName.equals(each.getTableShardingStrategy().getShardingAlgorithmName())) {
                data.add(Arrays.asList("table", each.getLogicTable()));
            }
        });
        shardingRuleConfig.getAutoTables().forEach(each -> {
            if (null != each.getShardingStrategy() && algorithmName.equals(each.getShardingStrategy().getShardingAlgorithmName())) {
                data.add(Arrays.asList("auto_table", each.getLogicTable()));
            }
        });
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("type", "name");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.data.next();
    }

    public String getType() {
        return ShowShardingTableRulesUsedAlgorithmStatement.class.getName();
    }
}

