/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.properties.PropertiesConverter;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingTableRulesStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ShardingTableRuleQueryResultSet
implements DistSQLResultSet {
    private Iterator<ShardingTableRuleConfiguration> tables;
    private Iterator<ShardingAutoTableRuleConfiguration> autoTables;
    private ShardingRuleConfiguration shardingRuleConfig;

    public void init(ShardingSphereDatabase database, SQLStatement sqlStatement) {
        String tableName = ((ShowShardingTableRulesStatement)sqlStatement).getTableName();
        Optional<ShardingRuleConfiguration> ruleConfig = database.getRuleMetaData().getConfigurations().stream().filter(each -> each instanceof ShardingRuleConfiguration).map(each -> (ShardingRuleConfiguration)each).findAny();
        if (Objects.isNull(tableName)) {
            this.tables = ruleConfig.map(optional -> optional.getTables().iterator()).orElseGet(Collections::emptyIterator);
            this.autoTables = ruleConfig.map(optional -> optional.getAutoTables().iterator()).orElseGet(Collections::emptyIterator);
        } else {
            this.tables = ruleConfig.map(optional -> optional.getTables().stream().filter(each -> tableName.equalsIgnoreCase(each.getLogicTable())).collect(Collectors.toList()).iterator()).orElseGet(Collections::emptyIterator);
            this.autoTables = ruleConfig.map(optional -> optional.getAutoTables().stream().filter(each -> tableName.equalsIgnoreCase(each.getLogicTable())).collect(Collectors.toList()).iterator()).orElseGet(Collections::emptyIterator);
        }
        this.shardingRuleConfig = ruleConfig.orElse(null);
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("table", "actual_data_nodes", "actual_data_sources", "database_strategy_type", "database_sharding_column", "database_sharding_algorithm_type", "database_sharding_algorithm_props", "table_strategy_type", "table_sharding_column", "table_sharding_algorithm_type", "table_sharding_algorithm_props", "key_generate_column", "key_generator_type", "key_generator_props");
    }

    public boolean next() {
        return this.tables.hasNext() || this.autoTables.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.tables.hasNext() ? this.buildTableRowData(this.tables.next()) : this.buildAutoTableRowData(this.autoTables.next());
    }

    private Collection<Object> buildTableRowData(ShardingTableRuleConfiguration shardingTableRuleConfig) {
        LinkedList<Object> result = new LinkedList<Object>();
        result.add(shardingTableRuleConfig.getLogicTable());
        result.add(shardingTableRuleConfig.getActualDataNodes());
        result.add("");
        result.add(this.getDatabaseStrategyType(shardingTableRuleConfig));
        result.add(this.getDatabaseShardingColumn(shardingTableRuleConfig));
        Optional<ShardingStrategyConfiguration> databaseShardingStrategyConfig = this.getDatabaseShardingStrategy(shardingTableRuleConfig);
        result.add(databaseShardingStrategyConfig.map(this::getAlgorithmType).orElse(""));
        result.add(databaseShardingStrategyConfig.map(this::getAlgorithmProperties).orElse(""));
        result.add(this.getTableStrategyType(shardingTableRuleConfig.getTableShardingStrategy()));
        result.add(this.getTableShardingColumn(shardingTableRuleConfig.getTableShardingStrategy()));
        Optional<ShardingStrategyConfiguration> tableShardingStrategyConfig = this.getTableShardingStrategy(shardingTableRuleConfig.getTableShardingStrategy());
        result.add(tableShardingStrategyConfig.map(this::getAlgorithmType).orElse(""));
        result.add(tableShardingStrategyConfig.map(this::getAlgorithmProperties).orElse(""));
        result.add(this.getKeyGenerateColumn(shardingTableRuleConfig.getKeyGenerateStrategy()));
        result.add(this.getKeyGeneratorType(shardingTableRuleConfig.getKeyGenerateStrategy()));
        result.add(this.getKeyGeneratorProps(shardingTableRuleConfig.getKeyGenerateStrategy()));
        return result;
    }

    private Collection<Object> buildAutoTableRowData(ShardingAutoTableRuleConfiguration shardingAutoTableRuleConfig) {
        LinkedList<Object> result = new LinkedList<Object>();
        result.add(shardingAutoTableRuleConfig.getLogicTable());
        result.add("");
        result.add(shardingAutoTableRuleConfig.getActualDataSources());
        result.add("");
        result.add("");
        result.add("");
        result.add("");
        result.add(this.getTableStrategyType(shardingAutoTableRuleConfig.getShardingStrategy()));
        result.add(this.getTableShardingColumn(shardingAutoTableRuleConfig.getShardingStrategy()));
        Optional<ShardingStrategyConfiguration> tableShardingStrategyConfig = this.getTableShardingStrategy(shardingAutoTableRuleConfig.getShardingStrategy());
        result.add(tableShardingStrategyConfig.map(this::getAlgorithmType).orElse(""));
        result.add(tableShardingStrategyConfig.map(this::getAlgorithmProperties).orElse(""));
        result.add(this.getKeyGenerateColumn(shardingAutoTableRuleConfig.getKeyGenerateStrategy()));
        result.add(this.getKeyGeneratorType(shardingAutoTableRuleConfig.getKeyGenerateStrategy()));
        result.add(this.getKeyGeneratorProps(shardingAutoTableRuleConfig.getKeyGenerateStrategy()));
        return result;
    }

    private String getDatabaseStrategyType(ShardingTableRuleConfiguration shardingTableRuleConfig) {
        Optional<ShardingStrategyConfiguration> databaseShardingStrategy = this.getDatabaseShardingStrategy(shardingTableRuleConfig);
        return databaseShardingStrategy.isPresent() && !(databaseShardingStrategy.get() instanceof NoneShardingStrategyConfiguration) ? this.getAlgorithmConfiguration(databaseShardingStrategy.get().getShardingAlgorithmName()).getType() : "";
    }

    private String getDatabaseShardingColumn(ShardingTableRuleConfiguration shardingTableRuleConfig) {
        Optional<ShardingStrategyConfiguration> databaseShardingStrategy = this.getDatabaseShardingStrategy(shardingTableRuleConfig);
        return databaseShardingStrategy.isPresent() ? this.getShardingColumn(databaseShardingStrategy.get()) : "";
    }

    private String getShardingColumn(ShardingStrategyConfiguration shardingStrategyConfig) {
        if (shardingStrategyConfig instanceof StandardShardingStrategyConfiguration) {
            return ((StandardShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumn();
        }
        if (shardingStrategyConfig instanceof ComplexShardingStrategyConfiguration) {
            return ((ComplexShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumns();
        }
        return "";
    }

    private String getAlgorithmType(ShardingStrategyConfiguration databaseShardingStrategy) {
        return databaseShardingStrategy instanceof NoneShardingStrategyConfiguration ? "" : this.getAlgorithmConfiguration(databaseShardingStrategy.getShardingAlgorithmName()).getType();
    }

    private String getAlgorithmProperties(ShardingStrategyConfiguration databaseShardingStrategy) {
        return databaseShardingStrategy instanceof NoneShardingStrategyConfiguration ? "" : PropertiesConverter.convert((Properties)this.getAlgorithmConfiguration(databaseShardingStrategy.getShardingAlgorithmName()).getProps());
    }

    private Optional<ShardingStrategyConfiguration> getDatabaseShardingStrategy(ShardingTableRuleConfiguration shardingTableRuleConfig) {
        return null == shardingTableRuleConfig.getDatabaseShardingStrategy() ? Optional.ofNullable(this.shardingRuleConfig.getDefaultDatabaseShardingStrategy()) : Optional.ofNullable(shardingTableRuleConfig.getDatabaseShardingStrategy());
    }

    private ShardingSphereAlgorithmConfiguration getAlgorithmConfiguration(String algorithmName) {
        return (ShardingSphereAlgorithmConfiguration)this.shardingRuleConfig.getShardingAlgorithms().get(algorithmName);
    }

    private String getTableStrategyType(ShardingStrategyConfiguration shardingStrategyConfig) {
        Optional<ShardingStrategyConfiguration> tableShardingStrategy = this.getTableShardingStrategy(shardingStrategyConfig);
        return tableShardingStrategy.isPresent() ? this.getStrategyType(tableShardingStrategy.get()) : "";
    }

    private String getStrategyType(ShardingStrategyConfiguration shardingStrategyConfig) {
        return shardingStrategyConfig instanceof NoneShardingStrategyConfiguration ? "none" : this.getAlgorithmConfiguration(shardingStrategyConfig.getShardingAlgorithmName()).getType();
    }

    private Optional<ShardingStrategyConfiguration> getTableShardingStrategy(ShardingStrategyConfiguration shardingStrategyConfig) {
        return null == shardingStrategyConfig ? Optional.ofNullable(this.shardingRuleConfig.getDefaultTableShardingStrategy()) : Optional.of(shardingStrategyConfig);
    }

    private String getTableShardingColumn(ShardingStrategyConfiguration shardingStrategyConfig) {
        Optional<ShardingStrategyConfiguration> tableShardingStrategy = this.getTableShardingStrategy(shardingStrategyConfig);
        return tableShardingStrategy.isPresent() ? this.getShardingColumn(tableShardingStrategy.get()) : "";
    }

    private String getKeyGenerateColumn(KeyGenerateStrategyConfiguration keyGenerateStrategyConfig) {
        return this.getKeyGenerateStrategyConfiguration(keyGenerateStrategyConfig).isPresent() ? this.getKeyGenerateStrategyConfiguration(keyGenerateStrategyConfig).get().getColumn() : "";
    }

    private String getKeyGeneratorType(KeyGenerateStrategyConfiguration originalKeyGenerateStrategyConfig) {
        Optional<KeyGenerateStrategyConfiguration> keyGenerateStrategyConfig = this.getKeyGenerateStrategyConfiguration(originalKeyGenerateStrategyConfig);
        return keyGenerateStrategyConfig.isPresent() ? ((ShardingSphereAlgorithmConfiguration)this.shardingRuleConfig.getKeyGenerators().get(keyGenerateStrategyConfig.get().getKeyGeneratorName())).getType() : "";
    }

    private String getKeyGeneratorProps(KeyGenerateStrategyConfiguration keyGenerateStrategyConfig) {
        return this.getKeyGenerateStrategyConfiguration(keyGenerateStrategyConfig).map(optional -> PropertiesConverter.convert((Properties)((ShardingSphereAlgorithmConfiguration)this.shardingRuleConfig.getKeyGenerators().get(optional.getKeyGeneratorName())).getProps())).orElse("");
    }

    private Optional<KeyGenerateStrategyConfiguration> getKeyGenerateStrategyConfiguration(KeyGenerateStrategyConfiguration keyGenerateStrategyConfig) {
        return null == keyGenerateStrategyConfig ? Optional.ofNullable(this.shardingRuleConfig.getDefaultKeyGenerateStrategy()) : Optional.of(keyGenerateStrategyConfig);
    }

    public String getType() {
        return ShowShardingTableRulesStatement.class.getName();
    }
}

