/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.expr.InlineExpressionParser;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.sharding.ShardingAutoTableAlgorithm;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingTableNodesStatement;
import org.apache.shardingsphere.sharding.factory.ShardingAlgorithmFactory;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ShardingTableNodesQueryResultSet
implements DistSQLResultSet {
    private static final String NAME = "name";
    private static final String NODES = "nodes";
    private Iterator<Map.Entry<String, String>> data = Collections.emptyIterator();

    public void init(ShardingSphereDatabase database, SQLStatement sqlStatement) {
        database.getRuleMetaData().getConfigurations().stream().filter(each -> each instanceof ShardingRuleConfiguration).map(each -> (ShardingRuleConfiguration)each).forEach(each -> {
            this.data = this.getData((ShardingRuleConfiguration)each, (ShowShardingTableNodesStatement)sqlStatement).entrySet().iterator();
        });
    }

    private Map<String, String> getData(ShardingRuleConfiguration config, ShowShardingTableNodesStatement sqlStatement) {
        String tableName = sqlStatement.getTableName();
        Map dataNodes = config.getTables().stream().filter(each -> null == tableName || each.getLogicTable().equals(tableName)).collect(Collectors.toMap(ShardingTableRuleConfiguration::getLogicTable, this::getDataNodes, (x, y) -> x, LinkedHashMap::new));
        Map autoTables = config.getAutoTables().stream().filter(each -> null == tableName || each.getLogicTable().equals(tableName)).collect(Collectors.toMap(ShardingAutoTableRuleConfiguration::getLogicTable, each -> this.getDataNodes((ShardingAutoTableRuleConfiguration)each, this.getTotalShardingCount(config, (ShardingAutoTableRuleConfiguration)each)), (x, y) -> x, LinkedHashMap::new));
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.putAll(dataNodes);
        result.putAll(autoTables);
        return result;
    }

    private int getTotalShardingCount(ShardingRuleConfiguration ruleConfig, ShardingAutoTableRuleConfiguration shardingAutoTableRuleConfig) {
        Map shardingAlgorithms = ruleConfig.getShardingAlgorithms();
        ShardingStrategyConfiguration shardingStrategy = shardingAutoTableRuleConfig.getShardingStrategy();
        if (this.useDefaultStrategy(shardingStrategy, ruleConfig)) {
            int tableCount = this.getShardingCount((ShardingSphereAlgorithmConfiguration)shardingAlgorithms.get(ruleConfig.getDefaultTableShardingStrategy().getShardingAlgorithmName()));
            int databaseCount = this.getShardingCount((ShardingSphereAlgorithmConfiguration)shardingAlgorithms.get(ruleConfig.getDefaultDatabaseShardingStrategy().getShardingAlgorithmName()));
            return tableCount * databaseCount;
        }
        return this.getShardingCount((ShardingSphereAlgorithmConfiguration)shardingAlgorithms.get(shardingStrategy.getShardingAlgorithmName()));
    }

    private boolean useDefaultStrategy(ShardingStrategyConfiguration currentShardingStrategy, ShardingRuleConfiguration ruleConfig) {
        return (null == currentShardingStrategy || Strings.isNullOrEmpty((String)currentShardingStrategy.getShardingAlgorithmName())) && null != ruleConfig.getDefaultDatabaseShardingStrategy() && null != ruleConfig.getDefaultTableShardingStrategy();
    }

    private int getShardingCount(ShardingSphereAlgorithmConfiguration algorithmConfig) {
        ShardingAlgorithm shardingAlgorithm;
        if (null == algorithmConfig) {
            return 0;
        }
        if (ShardingAlgorithmFactory.contains((String)algorithmConfig.getType()) && (shardingAlgorithm = ShardingAlgorithmFactory.newInstance((ShardingSphereAlgorithmConfiguration)algorithmConfig)) instanceof ShardingAutoTableAlgorithm) {
            shardingAlgorithm.init(algorithmConfig.getProps());
            return ((ShardingAutoTableAlgorithm)shardingAlgorithm).getAutoTablesAmount();
        }
        return 0;
    }

    private String getDataNodes(ShardingAutoTableRuleConfiguration shardingAutoTableRuleConfig, int shardingCount) {
        List dataSources = new InlineExpressionParser(shardingAutoTableRuleConfig.getActualDataSources()).splitAndEvaluate();
        return this.fillDataSourceNames(shardingAutoTableRuleConfig.getLogicTable(), shardingCount, dataSources);
    }

    private String getDataNodes(ShardingTableRuleConfiguration shardingTableRuleConfig) {
        return String.join((CharSequence)", ", new InlineExpressionParser(shardingTableRuleConfig.getActualDataNodes()).splitAndEvaluate());
    }

    private String fillDataSourceNames(String logicTable, int amount, List<String> dataSources) {
        LinkedList<String> result = new LinkedList<String>();
        Iterator<String> iterator = dataSources.iterator();
        for (int i = 0; i < amount; ++i) {
            if (!iterator.hasNext()) {
                iterator = dataSources.iterator();
            }
            result.add(String.format("%s.%s_%s", iterator.next(), logicTable, i));
        }
        return String.join((CharSequence)", ", result);
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList(NAME, NODES);
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        if (!this.data.hasNext()) {
            return Collections.emptyList();
        }
        Map.Entry<String, String> entry = this.data.next();
        return Arrays.asList(entry.getKey(), entry.getValue());
    }

    public String getType() {
        return ShowShardingTableNodesStatement.class.getName();
    }
}

