/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.properties.PropertiesConverter;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingAlgorithmsStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ShardingAlgorithmsQueryResultSet
implements DistSQLResultSet {
    private Iterator<Map.Entry<String, ShardingSphereAlgorithmConfiguration>> data;

    public void init(ShardingSphereDatabase database, SQLStatement sqlStatement) {
        Optional<ShardingRuleConfiguration> ruleConfig = database.getRuleMetaData().getConfigurations().stream().filter(each -> each instanceof ShardingRuleConfiguration).map(each -> (ShardingRuleConfiguration)each).findAny();
        this.data = ruleConfig.map(ShardingRuleConfiguration::getShardingAlgorithms).orElseGet(Collections::emptyMap).entrySet().iterator();
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("name", "type", "props");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.buildTableRowData(this.data.next());
    }

    private Collection<Object> buildTableRowData(Map.Entry<String, ShardingSphereAlgorithmConfiguration> data) {
        LinkedList<Object> result = new LinkedList<Object>();
        result.add(data.getKey());
        result.add(data.getValue().getType());
        result.add(this.buildProps(data.getValue().getProps()));
        return result;
    }

    private Object buildProps(Properties props) {
        return Objects.nonNull(props) ? PropertiesConverter.convert((Properties)props) : "";
    }

    public String getType() {
        return ShowShardingAlgorithmsStatement.class.getName();
    }
}

