/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.converter;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.enums.ShardingStrategyLevelType;
import org.apache.shardingsphere.sharding.distsql.handler.enums.ShardingStrategyType;
import org.apache.shardingsphere.sharding.distsql.parser.segment.AbstractTableRuleSegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.AutoTableRuleSegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.KeyGenerateStrategySegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.ShardingStrategySegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.TableRuleSegment;

public final class ShardingTableRuleStatementConverter {
    public static ShardingRuleConfiguration convert(Collection<AbstractTableRuleSegment> rules) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        rules.forEach(each -> {
            result.getKeyGenerators().putAll(ShardingTableRuleStatementConverter.createKeyGeneratorConfiguration(each));
            if (each instanceof AutoTableRuleSegment) {
                result.getShardingAlgorithms().putAll(ShardingTableRuleStatementConverter.createAlgorithmConfiguration((AutoTableRuleSegment)each));
                result.getAutoTables().add(ShardingTableRuleStatementConverter.createAutoTableRuleConfiguration((AutoTableRuleSegment)each));
            }
            if (each instanceof TableRuleSegment) {
                result.getShardingAlgorithms().putAll(ShardingTableRuleStatementConverter.createAlgorithmConfiguration((TableRuleSegment)each));
                result.getTables().add(ShardingTableRuleStatementConverter.createTableRuleConfiguration((TableRuleSegment)each));
            }
        });
        return result;
    }

    private static Map<String, ShardingSphereAlgorithmConfiguration> createKeyGeneratorConfiguration(AbstractTableRuleSegment rule) {
        HashMap<String, ShardingSphereAlgorithmConfiguration> result = new HashMap<String, ShardingSphereAlgorithmConfiguration>();
        Optional.ofNullable(rule.getKeyGenerateStrategySegment()).ifPresent(optional -> {
            if (!optional.getKeyGenerateAlgorithmName().isPresent()) {
                result.put(ShardingTableRuleStatementConverter.getKeyGeneratorName(rule.getLogicTable(), optional.getKeyGenerateAlgorithmSegment().getName()), ShardingTableRuleStatementConverter.createAlgorithmConfiguration(optional.getKeyGenerateAlgorithmSegment()));
            }
        });
        return result;
    }

    private static Map<String, ShardingSphereAlgorithmConfiguration> createAlgorithmConfiguration(AutoTableRuleSegment rule) {
        HashMap<String, ShardingSphereAlgorithmConfiguration> result = new HashMap<String, ShardingSphereAlgorithmConfiguration>();
        Optional.ofNullable(rule.getShardingAlgorithmSegment()).ifPresent(optional -> result.put(ShardingTableRuleStatementConverter.getAutoTableShardingAlgorithmName(rule.getLogicTable(), optional.getName()), ShardingTableRuleStatementConverter.createAlgorithmConfiguration(optional)));
        return result;
    }

    private static Map<String, ShardingSphereAlgorithmConfiguration> createAlgorithmConfiguration(TableRuleSegment rule) {
        HashMap<String, ShardingSphereAlgorithmConfiguration> result = new HashMap<String, ShardingSphereAlgorithmConfiguration>();
        if (null != rule.getTableStrategySegment()) {
            Optional.ofNullable(rule.getTableStrategySegment().getAlgorithmSegment()).ifPresent(optional -> result.put(ShardingTableRuleStatementConverter.getTableShardingAlgorithmName(rule.getLogicTable(), ShardingStrategyLevelType.TABLE, optional.getName()), ShardingTableRuleStatementConverter.createAlgorithmConfiguration(optional)));
        }
        if (null != rule.getDatabaseStrategySegment()) {
            Optional.ofNullable(rule.getDatabaseStrategySegment().getAlgorithmSegment()).ifPresent(optional -> result.put(ShardingTableRuleStatementConverter.getTableShardingAlgorithmName(rule.getLogicTable(), ShardingStrategyLevelType.DATABASE, optional.getName()), ShardingTableRuleStatementConverter.createAlgorithmConfiguration(optional)));
        }
        return result;
    }

    public static ShardingSphereAlgorithmConfiguration createAlgorithmConfiguration(AlgorithmSegment segment) {
        return new ShardingSphereAlgorithmConfiguration(segment.getName().toLowerCase(), segment.getProps());
    }

    private static ShardingAutoTableRuleConfiguration createAutoTableRuleConfiguration(AutoTableRuleSegment rule) {
        ShardingAutoTableRuleConfiguration result = new ShardingAutoTableRuleConfiguration(rule.getLogicTable(), String.join((CharSequence)",", rule.getDataSourceNodes()));
        result.setShardingStrategy(ShardingTableRuleStatementConverter.createAutoTableStrategyConfiguration(rule));
        Optional.ofNullable(rule.getKeyGenerateStrategySegment()).ifPresent(optional -> result.setKeyGenerateStrategy(ShardingTableRuleStatementConverter.createKeyGenerateStrategyConfiguration(rule.getLogicTable(), rule.getKeyGenerateStrategySegment())));
        return result;
    }

    private static ShardingStrategyConfiguration createAutoTableStrategyConfiguration(AutoTableRuleSegment rule) {
        return ShardingTableRuleStatementConverter.createStrategyConfiguration(ShardingStrategyType.STANDARD.name(), rule.getShardingColumn(), ShardingTableRuleStatementConverter.getAutoTableShardingAlgorithmName(rule.getLogicTable(), rule.getShardingAlgorithmSegment().getName()));
    }

    private static ShardingTableRuleConfiguration createTableRuleConfiguration(TableRuleSegment tableRuleSegment) {
        String dataSourceNodes = String.join((CharSequence)",", tableRuleSegment.getDataSourceNodes());
        ShardingTableRuleConfiguration result = new ShardingTableRuleConfiguration(tableRuleSegment.getLogicTable(), dataSourceNodes);
        Optional.ofNullable(tableRuleSegment.getTableStrategySegment()).ifPresent(optional -> result.setTableShardingStrategy(ShardingTableRuleStatementConverter.createShardingStrategyConfiguration(tableRuleSegment.getLogicTable(), ShardingStrategyLevelType.TABLE, optional.getType(), optional)));
        Optional.ofNullable(tableRuleSegment.getDatabaseStrategySegment()).ifPresent(optional -> result.setDatabaseShardingStrategy(ShardingTableRuleStatementConverter.createShardingStrategyConfiguration(tableRuleSegment.getLogicTable(), ShardingStrategyLevelType.DATABASE, optional.getType(), optional)));
        Optional.ofNullable(tableRuleSegment.getKeyGenerateStrategySegment()).ifPresent(optional -> result.setKeyGenerateStrategy(ShardingTableRuleStatementConverter.createKeyGenerateStrategyConfiguration(tableRuleSegment.getLogicTable(), optional)));
        return result;
    }

    private static ShardingStrategyConfiguration createShardingStrategyConfiguration(String logicTable, ShardingStrategyLevelType strategyLevel, String type, ShardingStrategySegment segment) {
        String shardingAlgorithmName = null == segment.getShardingAlgorithmName() ? ShardingTableRuleStatementConverter.getTableShardingAlgorithmName(logicTable, strategyLevel, segment.getAlgorithmSegment().getName()) : segment.getShardingAlgorithmName();
        return ShardingTableRuleStatementConverter.createStrategyConfiguration(ShardingStrategyType.getValueOf(type).name(), segment.getShardingColumn(), shardingAlgorithmName);
    }

    private static KeyGenerateStrategyConfiguration createKeyGenerateStrategyConfiguration(String logicTable, KeyGenerateStrategySegment segment) {
        if (segment.getKeyGenerateAlgorithmName().isPresent()) {
            return new KeyGenerateStrategyConfiguration(segment.getKeyGenerateColumn(), (String)segment.getKeyGenerateAlgorithmName().get());
        }
        return new KeyGenerateStrategyConfiguration(segment.getKeyGenerateColumn(), ShardingTableRuleStatementConverter.getKeyGeneratorName(logicTable, segment.getKeyGenerateAlgorithmSegment().getName()));
    }

    public static ShardingStrategyConfiguration createStrategyConfiguration(String strategyType, String shardingColumn, String shardingAlgorithmName) {
        ShardingStrategyType shardingStrategyType = ShardingStrategyType.getValueOf(strategyType);
        return shardingStrategyType.createConfiguration(shardingAlgorithmName, shardingColumn);
    }

    private static String getAutoTableShardingAlgorithmName(String tableName, String algorithmType) {
        return String.format("%s_%s", tableName.toLowerCase(), algorithmType.toLowerCase());
    }

    private static String getTableShardingAlgorithmName(String tableName, ShardingStrategyLevelType strategyLevel, String algorithmType) {
        return String.format("%s_%s_%s", tableName.toLowerCase(), strategyLevel.name().toLowerCase(), algorithmType.toLowerCase());
    }

    private static String getKeyGeneratorName(String tableName, String algorithmType) {
        return String.format("%s_%s", tableName.toLowerCase(), algorithmType.toLowerCase());
    }

    @Generated
    private ShardingTableRuleStatementConverter() {
    }
}

