/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.distsql.handler.update;

import java.util.Collections;
import java.util.Properties;
import org.apache.shardingsphere.data.pipeline.core.check.consistency.DataConsistencyCalculateAlgorithmFactory;
import org.apache.shardingsphere.data.pipeline.spi.detect.JobCompletionDetectAlgorithmFactory;
import org.apache.shardingsphere.data.pipeline.spi.ingest.channel.PipelineChannelCreatorFactory;
import org.apache.shardingsphere.data.pipeline.spi.ratelimit.JobRateLimitAlgorithmFactory;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.infra.config.rulealtered.OnRuleAlteredActionConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionCreateUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.scaling.distsql.handler.converter.ShardingScalingRuleStatementConverter;
import org.apache.shardingsphere.scaling.distsql.statement.CreateShardingScalingRuleStatement;
import org.apache.shardingsphere.scaling.distsql.statement.segment.ShardingScalingRuleConfigurationSegment;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.spi.exception.ServiceProviderNotFoundException;

public final class CreateShardingScalingRuleStatementUpdater
implements RuleDefinitionCreateUpdater<CreateShardingScalingRuleStatement, ShardingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, CreateShardingScalingRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        String databaseName = database.getName();
        this.checkCurrentRuleConfiguration(databaseName, currentRuleConfig);
        this.checkDuplicate(databaseName, sqlStatement, currentRuleConfig);
        this.checkAlgorithms(sqlStatement.getScalingRuleConfigSegment());
    }

    private void checkCurrentRuleConfiguration(String databaseName, ShardingRuleConfiguration currentRuleConfig) throws RequiredRuleMissedException {
        if (null == currentRuleConfig) {
            throw new RequiredRuleMissedException("Sharding", databaseName);
        }
    }

    private void checkDuplicate(String databaseName, CreateShardingScalingRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (currentRuleConfig.getScaling().containsKey(sqlStatement.getScalingName())) {
            throw new DuplicateRuleException("Scaling", databaseName, Collections.singletonList(sqlStatement.getScalingName()));
        }
    }

    private void checkAlgorithms(ShardingScalingRuleConfigurationSegment segment) throws DistSQLException {
        if (null == segment) {
            return;
        }
        this.checkRateLimiterExist(segment);
        this.checkStreamChannelExist(segment);
        this.checkCompletionDetectorExist(segment);
        this.checkDataConsistencyCalculatorExist(segment);
    }

    private void checkRateLimiterExist(ShardingScalingRuleConfigurationSegment segment) throws DistSQLException {
        if (null != segment.getInputSegment()) {
            this.checkRateLimitAlgorithm(segment.getInputSegment().getRateLimiter());
        }
        if (null != segment.getOutputSegment()) {
            this.checkRateLimitAlgorithm(segment.getOutputSegment().getRateLimiter());
        }
    }

    private void checkRateLimitAlgorithm(AlgorithmSegment rateLimit) throws DistSQLException {
        if (null != rateLimit && !JobRateLimitAlgorithmFactory.contains((String)rateLimit.getName())) {
            throw new InvalidAlgorithmConfigurationException("rate limit", rateLimit.getName());
        }
    }

    private void checkStreamChannelExist(ShardingScalingRuleConfigurationSegment segment) throws DistSQLException {
        if (null != segment.getStreamChannel() && !PipelineChannelCreatorFactory.contains((String)segment.getStreamChannel().getName())) {
            throw new InvalidAlgorithmConfigurationException("stream channel", segment.getStreamChannel().getName());
        }
    }

    private void checkCompletionDetectorExist(ShardingScalingRuleConfigurationSegment segment) throws DistSQLException {
        if (null != segment.getCompletionDetector() && !JobCompletionDetectAlgorithmFactory.contains((String)segment.getCompletionDetector().getName())) {
            throw new InvalidAlgorithmConfigurationException("completion detector", segment.getCompletionDetector().getName());
        }
    }

    private void checkDataConsistencyCalculatorExist(ShardingScalingRuleConfigurationSegment segment) throws DistSQLException {
        if (null != segment.getDataConsistencyCalculator()) {
            try {
                DataConsistencyCalculateAlgorithmFactory.newInstance((String)segment.getDataConsistencyCalculator().getName(), (Properties)new Properties());
            }
            catch (ServiceProviderNotFoundException ex) {
                throw new InvalidAlgorithmConfigurationException("data consistency calculator", segment.getDataConsistencyCalculator().getName());
            }
        }
    }

    public ShardingRuleConfiguration buildToBeCreatedRuleConfiguration(CreateShardingScalingRuleStatement sqlStatement) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        result.setScaling(Collections.singletonMap(sqlStatement.getScalingName(), this.buildScalingConfiguration(sqlStatement.getScalingRuleConfigSegment())));
        return result;
    }

    private OnRuleAlteredActionConfiguration buildScalingConfiguration(ShardingScalingRuleConfigurationSegment segment) {
        return null == segment ? null : ShardingScalingRuleStatementConverter.convert(segment);
    }

    public void updateCurrentRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, ShardingRuleConfiguration toBeCreatedRuleConfig) {
        currentRuleConfig.getScaling().putAll(toBeCreatedRuleConfig.getScaling());
        if (null == currentRuleConfig.getScalingName()) {
            currentRuleConfig.setScalingName((String)toBeCreatedRuleConfig.getScaling().keySet().iterator().next());
        }
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public String getType() {
        return CreateShardingScalingRuleStatement.class.getName();
    }
}

