/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.api.RuleAlteredJobAPI;
import org.apache.shardingsphere.data.pipeline.api.RuleAlteredJobAPIFactory;
import org.apache.shardingsphere.data.pipeline.api.check.consistency.DataConsistencyCheckResult;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.scaling.distsql.statement.CheckScalingStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class CheckScalingQueryResultSet
implements DistSQLResultSet {
    private static final RuleAlteredJobAPI RULE_ALTERED_JOB_API = RuleAlteredJobAPIFactory.getInstance();
    private Iterator<Collection<Object>> data;

    public void init(ShardingSphereDatabase database, SQLStatement sqlStatement) {
        CheckScalingStatement checkScalingStatement = (CheckScalingStatement)sqlStatement;
        AlgorithmSegment typeStrategy = checkScalingStatement.getTypeStrategy();
        Map checkResultMap = null == typeStrategy ? RULE_ALTERED_JOB_API.dataConsistencyCheck(checkScalingStatement.getJobId()) : RULE_ALTERED_JOB_API.dataConsistencyCheck(checkScalingStatement.getJobId(), typeStrategy.getName(), typeStrategy.getProps());
        this.data = checkResultMap.entrySet().stream().map(each -> {
            LinkedList<Object> result = new LinkedList<Object>();
            result.add(each.getKey());
            result.add(((DataConsistencyCheckResult)each.getValue()).getCountCheckResult().getSourceRecordsCount());
            result.add(((DataConsistencyCheckResult)each.getValue()).getCountCheckResult().getTargetRecordsCount());
            result.add(((DataConsistencyCheckResult)each.getValue()).getCountCheckResult().isMatched() + "");
            result.add(((DataConsistencyCheckResult)each.getValue()).getContentCheckResult().isMatched() + "");
            return result;
        }).collect(Collectors.toList()).iterator();
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("table_name", "source_records_count", "target_records_count", "records_count_matched", "records_content_matched");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.data.next();
    }

    public String getType() {
        return CheckScalingStatement.class.getName();
    }
}

