/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.util.spi.type.typed;

import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.shardingsphere.infra.util.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.util.spi.exception.ServiceProviderNotFoundException;
import org.apache.shardingsphere.infra.util.spi.lifecycle.SPIPostProcessor;
import org.apache.shardingsphere.infra.util.spi.type.typed.TypedSPI;

public final class TypedSPIRegistry {
    public static <T extends TypedSPI> Optional<T> findRegisteredService(Class<T> spiClass, String type) {
        for (TypedSPI each : ShardingSphereServiceLoader.getServiceInstances(spiClass)) {
            if (!TypedSPIRegistry.matchesType(type, each)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public static <T extends TypedSPI> Optional<T> findRegisteredService(Class<T> spiClass, String type, Properties props) {
        for (TypedSPI each : ShardingSphereServiceLoader.getServiceInstances(spiClass)) {
            if (!TypedSPIRegistry.matchesType(type, each)) continue;
            Properties stringTypeProps = TypedSPIRegistry.convertToStringTypedProperties(props);
            if (each instanceof SPIPostProcessor) {
                ((SPIPostProcessor)((Object)each)).init(stringTypeProps);
            }
            return Optional.of(each);
        }
        return Optional.empty();
    }

    private static boolean matchesType(String type, TypedSPI instance) {
        return instance.getType().equalsIgnoreCase(type) || instance.getTypeAliases().contains(type);
    }

    private static Properties convertToStringTypedProperties(Properties props) {
        if (null == props) {
            return new Properties();
        }
        Properties result = new Properties();
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> result.setProperty(key.toString(), null == value ? null : value.toString())));
        return result;
    }

    public static <T extends TypedSPI> T getRegisteredService(Class<T> spiClass, String type) {
        Optional<T> result = TypedSPIRegistry.findRegisteredService(spiClass, type);
        if (result.isPresent()) {
            return (T)((TypedSPI)result.get());
        }
        throw new ServiceProviderNotFoundException(spiClass, type);
    }

    public static <T extends TypedSPI> T getRegisteredService(Class<T> spiClass, String type, Properties props) {
        Optional<T> result = TypedSPIRegistry.findRegisteredService(spiClass, type, props);
        if (result.isPresent()) {
            return (T)((TypedSPI)result.get());
        }
        throw new ServiceProviderNotFoundException(spiClass, type);
    }

    @Generated
    private TypedSPIRegistry() {
    }
}

