/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.hint;

import com.google.common.base.Splitter;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.hint.SQLHintPropertiesKey;
import org.apache.shardingsphere.infra.hint.SQLHintTokenEnum;

public final class SQLHintUtils {
    private static final String SQL_COMMENT_SUFFIX = "*/";
    private static final String SQL_HINT_SPLIT = ",";
    private static final String SQL_HINT_VALUE_SPLIT = "=";
    private static final String SQL_HINT_VALUE_COLLECTION_SPLIT = " ";
    private static final int SQL_HINT_VALUE_SIZE = 2;

    public static HintValueContext extractHint(String sql) {
        if (!SQLHintUtils.startWithHint(sql, SQLHintTokenEnum.SQL_START_HINT_TOKEN)) {
            return new HintValueContext();
        }
        HintValueContext result = new HintValueContext();
        String hintText = sql.substring(0, sql.indexOf(SQL_COMMENT_SUFFIX) + 2);
        Properties hintProps = SQLHintUtils.getSQLHintProps(hintText);
        if (SQLHintUtils.containsPropertyKey(hintProps, SQLHintPropertiesKey.DATASOURCE_NAME_KEY)) {
            result.setDataSourceName(SQLHintUtils.getProperty(hintProps, SQLHintPropertiesKey.DATASOURCE_NAME_KEY));
        }
        if (SQLHintUtils.containsPropertyKey(hintProps, SQLHintPropertiesKey.WRITE_ROUTE_ONLY_KEY)) {
            result.setWriteRouteOnly(Boolean.parseBoolean(SQLHintUtils.getProperty(hintProps, SQLHintPropertiesKey.WRITE_ROUTE_ONLY_KEY)));
        }
        if (SQLHintUtils.containsPropertyKey(hintProps, SQLHintPropertiesKey.USE_TRAFFIC_KEY)) {
            result.setUseTraffic(Boolean.parseBoolean(SQLHintUtils.getProperty(hintProps, SQLHintPropertiesKey.USE_TRAFFIC_KEY)));
        }
        if (SQLHintUtils.containsPropertyKey(hintProps, SQLHintPropertiesKey.SKIP_SQL_REWRITE_KEY)) {
            result.setSkipSQLRewrite(Boolean.parseBoolean(SQLHintUtils.getProperty(hintProps, SQLHintPropertiesKey.SKIP_SQL_REWRITE_KEY)));
        }
        if (SQLHintUtils.containsPropertyKey(hintProps, SQLHintPropertiesKey.DISABLE_AUDIT_NAMES_KEY)) {
            String property = SQLHintUtils.getProperty(hintProps, SQLHintPropertiesKey.DISABLE_AUDIT_NAMES_KEY);
            result.getDisableAuditNames().addAll(SQLHintUtils.getSplitterSQLHintValue(property));
        }
        if (SQLHintUtils.containsPropertyKey(hintProps, SQLHintPropertiesKey.SHADOW_KEY)) {
            result.setShadow(Boolean.parseBoolean(SQLHintUtils.getProperty(hintProps, SQLHintPropertiesKey.SHADOW_KEY)));
        }
        for (Map.Entry<Object, Object> entry : hintProps.entrySet()) {
            Object value;
            Object object = value = entry.getValue() instanceof Comparable ? (Comparable)entry.getValue() : Objects.toString(entry.getValue());
            if (SQLHintUtils.containsPropertyKey(Objects.toString(entry.getKey()), SQLHintPropertiesKey.SHARDING_DATABASE_VALUE_KEY)) {
                result.getShardingDatabaseValues().put((Object)Objects.toString(entry.getKey()).toUpperCase(), value);
            }
            if (!SQLHintUtils.containsPropertyKey(Objects.toString(entry.getKey()), SQLHintPropertiesKey.SHARDING_TABLE_VALUE_KEY)) continue;
            result.getShardingTableValues().put((Object)Objects.toString(entry.getKey()).toUpperCase(), value);
        }
        return result;
    }

    public static String removeHint(String sql) {
        return SQLHintUtils.startWithHint(sql, SQLHintTokenEnum.SQL_START_HINT_TOKEN) ? sql.substring(sql.indexOf(SQL_COMMENT_SUFFIX) + 2).trim() : sql;
    }

    private static Properties getSQLHintProps(String comment) {
        Properties result = new Properties();
        int startIndex = SQLHintUtils.getStartIndex(comment, SQLHintTokenEnum.SQL_START_HINT_TOKEN, SQLHintTokenEnum.SQL_HINT_TOKEN);
        if (startIndex < 0) {
            return result;
        }
        int endIndex = comment.endsWith(SQL_COMMENT_SUFFIX) ? comment.indexOf(SQL_COMMENT_SUFFIX) : comment.length();
        List sqlHints = Splitter.on((String)SQL_HINT_SPLIT).trimResults().splitToList((CharSequence)comment.substring(startIndex, endIndex).trim());
        for (String each : sqlHints) {
            List hintValues = Splitter.on((String)SQL_HINT_VALUE_SPLIT).limit(2).trimResults().splitToList((CharSequence)each);
            if (2 != hintValues.size()) continue;
            result.put(hintValues.get(0), SQLHintUtils.convert((String)hintValues.get(1)));
        }
        return result;
    }

    private static int getStartIndex(String comment, SQLHintTokenEnum sqlStartHintToken, SQLHintTokenEnum sqlHintToken) {
        int result;
        String lowerCaseComment = comment.toLowerCase();
        int n = result = lowerCaseComment.startsWith(sqlStartHintToken.getAlias().toLowerCase()) ? lowerCaseComment.indexOf(sqlHintToken.getAlias()) : lowerCaseComment.indexOf(sqlHintToken.getKey());
        if (result >= 0) {
            return result + sqlHintToken.getKey().length();
        }
        return result;
    }

    private static Object convert(String value) {
        try {
            return new BigInteger(value);
        }
        catch (NumberFormatException ignored) {
            return value;
        }
    }

    private static boolean startWithHint(String sql, SQLHintTokenEnum sqlStartHintToken) {
        return null != sql && (sql.startsWith(sqlStartHintToken.getKey()) || sql.startsWith(sqlStartHintToken.getAlias()));
    }

    private static boolean containsPropertyKey(Properties hintProps, SQLHintPropertiesKey sqlHintPropsKey) {
        return hintProps.containsKey(sqlHintPropsKey.getKey()) || hintProps.containsKey(sqlHintPropsKey.getAlias());
    }

    private static boolean containsPropertyKey(String hintPropKey, SQLHintPropertiesKey sqlHintPropsKey) {
        return hintPropKey.contains(sqlHintPropsKey.getKey()) || hintPropKey.contains(sqlHintPropsKey.getAlias());
    }

    private static String getProperty(Properties hintProps, SQLHintPropertiesKey sqlHintPropsKey) {
        String result = hintProps.getProperty(sqlHintPropsKey.getKey());
        return null == result ? hintProps.getProperty(sqlHintPropsKey.getAlias()) : result;
    }

    private static Collection<String> getSplitterSQLHintValue(String property) {
        return property.isEmpty() ? Collections.emptySet() : new HashSet(Splitter.on((String)SQL_HINT_VALUE_COLLECTION_SPLIT).omitEmptyStrings().trimResults().splitToList((CharSequence)property));
    }

    @Generated
    private SQLHintUtils() {
    }
}

