/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.config.nodepath;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class GlobalNodePath {
    private static final String RULES_NODE = "rules";
    private static final String PROPS_NODE = "props";
    private static final String VERSIONS = "versions";
    private static final String ACTIVE_VERSION_SUFFIX = "/active_version$";

    public static Optional<String> getVersion(String ruleName, String rulePath) {
        Pattern pattern = Pattern.compile(GlobalNodePath.getVersionsNode(ruleName) + "/(\\d+)$", 2);
        Matcher matcher = pattern.matcher(rulePath);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    private static String getVersionsNode(String ruleName) {
        return String.join((CharSequence)"/", "", RULES_NODE, ruleName, VERSIONS);
    }

    public static boolean isRuleActiveVersionPath(String rulePath) {
        Pattern pattern = Pattern.compile(GlobalNodePath.getRuleNameNode() + "/(\\w+)" + ACTIVE_VERSION_SUFFIX, 2);
        Matcher matcher = pattern.matcher(rulePath);
        return matcher.find();
    }

    public static boolean isPropsActiveVersionPath(String propsPath) {
        Pattern pattern = Pattern.compile(GlobalNodePath.getPropsNode() + ACTIVE_VERSION_SUFFIX, 2);
        Matcher matcher = pattern.matcher(propsPath);
        return matcher.find();
    }

    private static String getPropsNode() {
        return String.join((CharSequence)"/", "", PROPS_NODE);
    }

    public static Optional<String> getRuleName(String rulePath) {
        Pattern pattern = Pattern.compile(GlobalNodePath.getRuleNameNode() + "/(\\w+)" + ACTIVE_VERSION_SUFFIX, 2);
        Matcher matcher = pattern.matcher(rulePath);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    private static String getRuleNameNode() {
        return String.join((CharSequence)"/", "", RULES_NODE);
    }

    @Generated
    private GlobalNodePath() {
    }
}

