/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.imap.storage.file.wal.writer;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.seatunnel.engine.imap.storage.file.bean.IMapFileData;
import org.apache.seatunnel.engine.imap.storage.file.common.WALDataUtils;
import org.apache.seatunnel.engine.imap.storage.file.wal.writer.IFileWriter;
import org.apache.seatunnel.engine.serializer.api.Serializer;

public class HdfsWriter
implements IFileWriter<IMapFileData> {
    private FSDataOutputStream out;
    private Serializer serializer;

    @Override
    public String identifier() {
        return "hdfs";
    }

    @Override
    public void initialize(FileSystem fs, Path parentPath, Serializer serializer) throws IOException {
        Path path = new Path(parentPath, "wal.txt");
        this.out = fs.create(path);
        this.serializer = serializer;
    }

    @Override
    public void write(IMapFileData data) throws IOException {
        byte[] bytes = this.serializer.serialize((Object)data);
        this.write(bytes);
    }

    public void flush() throws IOException {
        if (this.out instanceof HdfsDataOutputStream) {
            ((HdfsDataOutputStream)this.out).hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
        }
        if (this.out.getWrappedStream() instanceof DFSOutputStream) {
            ((DFSOutputStream)this.out.getWrappedStream()).hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
        } else {
            this.out.hsync();
        }
        this.out.hflush();
    }

    @Override
    private void write(byte[] bytes) throws IOException {
        byte[] data = WALDataUtils.wrapperBytes(bytes);
        this.out.write(data);
        this.flush();
    }

    @Override
    public void close() throws Exception {
        if (this.out != null) {
            this.out.close();
        }
    }
}

