/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.config.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.AbstractSharedListener;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.seata.common.exception.NotSupportYetException;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.AbstractConfiguration;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationChangeEvent;
import org.apache.seata.config.ConfigurationChangeListener;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.config.Dispose;
import org.apache.seata.config.processor.ConfigProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosConfiguration
extends AbstractConfiguration
implements Dispose {
    private static volatile NacosConfiguration instance;
    private static final Logger LOGGER;
    private static final String DEFAULT_GROUP = "SEATA_GROUP";
    private static final String DEFAULT_DATA_ID = "seata.properties";
    private static final String GROUP_KEY = "group";
    private static final String PRO_SERVER_ADDR_KEY = "serverAddr";
    private static final String NACOS_DATA_ID_KEY = "dataId";
    private static final String CONFIG_TYPE = "nacos";
    private static final String DEFAULT_NAMESPACE = "";
    private static final String PRO_NAMESPACE_KEY = "namespace";
    private static final String USER_NAME = "username";
    private static final String PASSWORD = "password";
    private static final String ACCESS_KEY = "accessKey";
    private static final String SECRET_KEY = "secretKey";
    private static final String RAM_ROLE_NAME_KEY = "ramRoleName";
    private static final String USE_PARSE_RULE = "false";
    private static final String CONTEXT_PATH = "contextPath";
    private Configuration fileConfig = ConfigurationFactory.CURRENT_FILE_INSTANCE;
    private static volatile ConfigService configService;
    private static final int MAP_INITIAL_CAPACITY = 8;
    private static volatile ConcurrentMap<String, ConcurrentMap<ConfigurationChangeListener, NacosListener>> CONFIG_LISTENERS_MAP;
    private static volatile Properties seataConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NacosConfiguration getInstance() {
        if (instance != null) return instance;
        Class<NacosConfiguration> clazz = NacosConfiguration.class;
        synchronized (NacosConfiguration.class) {
            if (instance != null) return instance;
            instance = new NacosConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private NacosConfiguration() {
        if (configService == null) {
            try {
                configService = NacosFactory.createConfigService((Properties)this.getConfigProperties());
                this.initSeataConfig();
            }
            catch (NacosException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getLatestConfig(String dataId, String defaultValue, long timeoutMills) {
        String value = seataConfig.getProperty(dataId);
        if (null == value) {
            try {
                value = configService.getConfig(dataId, this.getNacosGroup(), timeoutMills);
            }
            catch (NacosException exx) {
                LOGGER.error(exx.getErrMsg());
            }
        }
        return value == null ? defaultValue : value;
    }

    public boolean putConfig(String dataId, String content, long timeoutMills) {
        boolean result = false;
        try {
            if (!seataConfig.isEmpty()) {
                seataConfig.setProperty(dataId, content);
                result = configService.publishConfig(this.getNacosDataId(), this.getNacosGroup(), NacosConfiguration.getSeataConfigStr());
            } else {
                result = configService.publishConfig(dataId, this.getNacosGroup(), content);
            }
        }
        catch (NacosException exx) {
            LOGGER.error(exx.getErrMsg());
        }
        return result;
    }

    public boolean putConfigIfAbsent(String dataId, String content, long timeoutMills) {
        throw new NotSupportYetException("not support atomic operation putConfigIfAbsent");
    }

    public boolean removeConfig(String dataId, long timeoutMills) {
        boolean result = false;
        try {
            if (!seataConfig.isEmpty()) {
                seataConfig.remove(dataId);
                result = configService.publishConfig(this.getNacosDataId(), this.getNacosGroup(), NacosConfiguration.getSeataConfigStr());
            } else {
                result = configService.removeConfig(dataId, this.getNacosGroup());
            }
        }
        catch (NacosException exx) {
            LOGGER.error(exx.getErrMsg());
        }
        return result;
    }

    public void addConfigListener(String dataId, ConfigurationChangeListener listener) {
        if (StringUtils.isBlank((String)dataId) || listener == null) {
            return;
        }
        try {
            NacosListener nacosListener = new NacosListener(dataId, listener);
            CONFIG_LISTENERS_MAP.computeIfAbsent(dataId, key -> new ConcurrentHashMap()).put(listener, nacosListener);
            configService.addListener(dataId, this.getNacosGroup(), (Listener)nacosListener);
        }
        catch (Exception exx) {
            LOGGER.error("add nacos listener error:{}", (Object)exx.getMessage(), (Object)exx);
        }
    }

    public void removeConfigListener(String dataId, ConfigurationChangeListener listener) {
        if (StringUtils.isBlank((String)dataId) || listener == null) {
            return;
        }
        Set<ConfigurationChangeListener> configChangeListeners = this.getConfigListeners(dataId);
        if (CollectionUtils.isNotEmpty(configChangeListeners)) {
            for (ConfigurationChangeListener entry : configChangeListeners) {
                if (!listener.equals(entry)) continue;
                NacosListener nacosListener = null;
                Map configListeners = (Map)CONFIG_LISTENERS_MAP.get(dataId);
                if (configListeners != null) {
                    nacosListener = (NacosListener)((Object)configListeners.get(listener));
                    configListeners.remove(entry);
                }
                if (nacosListener == null) break;
                configService.removeListener(dataId, this.getNacosGroup(), (Listener)nacosListener);
                break;
            }
        }
    }

    public Set<ConfigurationChangeListener> getConfigListeners(String dataId) {
        Map configListeners = (Map)CONFIG_LISTENERS_MAP.get(dataId);
        if (CollectionUtils.isNotEmpty((Map)configListeners)) {
            return configListeners.keySet();
        }
        return null;
    }

    private Properties getConfigProperties() {
        String contextPath;
        Properties properties = new Properties();
        properties.setProperty("isUseCloudNamespaceParsing", USE_PARSE_RULE);
        properties.setProperty("isUseEndpointParsingRule", USE_PARSE_RULE);
        if (System.getProperty(PRO_SERVER_ADDR_KEY) != null) {
            properties.setProperty(PRO_SERVER_ADDR_KEY, System.getProperty(PRO_SERVER_ADDR_KEY));
        } else {
            String address = this.fileConfig.getConfig(NacosConfiguration.getNacosAddrFileKey());
            if (address != null) {
                properties.setProperty(PRO_SERVER_ADDR_KEY, address);
            }
        }
        if (System.getProperty(PRO_NAMESPACE_KEY) != null) {
            properties.setProperty(PRO_NAMESPACE_KEY, System.getProperty(PRO_NAMESPACE_KEY));
        } else {
            String namespace = this.fileConfig.getConfig(NacosConfiguration.getNacosNameSpaceFileKey());
            if (namespace == null) {
                namespace = DEFAULT_NAMESPACE;
            }
            properties.setProperty(PRO_NAMESPACE_KEY, namespace);
        }
        if (!this.initNacosAuthProperties(properties)) {
            LOGGER.info("Nacos config auth properties empty.");
        }
        String string = contextPath = StringUtils.isNotBlank((String)System.getProperty(CONTEXT_PATH)) ? System.getProperty(CONTEXT_PATH) : this.fileConfig.getConfig(NacosConfiguration.getNacosContextPathKey());
        if (StringUtils.isNotBlank((String)contextPath)) {
            properties.setProperty(CONTEXT_PATH, contextPath);
        }
        return properties;
    }

    private boolean initNacosAuthProperties(Properties sourceProperties) {
        String userName;
        String string = userName = StringUtils.isNotBlank((String)System.getProperty(USER_NAME)) ? System.getProperty(USER_NAME) : this.fileConfig.getConfig(NacosConfiguration.getNacosUserName());
        if (StringUtils.isNotBlank((String)userName)) {
            String password;
            String string2 = password = StringUtils.isNotBlank((String)System.getProperty(PASSWORD)) ? System.getProperty(PASSWORD) : this.fileConfig.getConfig(NacosConfiguration.getNacosPassword());
            if (StringUtils.isNotBlank((String)password)) {
                sourceProperties.setProperty(USER_NAME, userName);
                sourceProperties.setProperty(PASSWORD, password);
                LOGGER.info("Nacos check auth with userName/password.");
                return true;
            }
        } else {
            String ramRoleName;
            String accessKey = StringUtils.isNotBlank((String)System.getProperty(ACCESS_KEY)) ? System.getProperty(ACCESS_KEY) : this.fileConfig.getConfig(NacosConfiguration.getNacosAccessKey());
            String string3 = ramRoleName = StringUtils.isNotBlank((String)System.getProperty(RAM_ROLE_NAME_KEY)) ? System.getProperty(RAM_ROLE_NAME_KEY) : this.fileConfig.getConfig(NacosConfiguration.getNacosRamRoleNameKey());
            if (StringUtils.isNotBlank((String)accessKey)) {
                String secretKey;
                String string4 = secretKey = StringUtils.isNotBlank((String)System.getProperty(SECRET_KEY)) ? System.getProperty(SECRET_KEY) : this.fileConfig.getConfig(NacosConfiguration.getNacosSecretKey());
                if (StringUtils.isNotBlank((String)secretKey)) {
                    sourceProperties.put(ACCESS_KEY, accessKey);
                    sourceProperties.put(SECRET_KEY, secretKey);
                    LOGGER.info("Nacos check auth with ak/sk.");
                    return true;
                }
            } else if (StringUtils.isNotBlank((String)ramRoleName)) {
                sourceProperties.put(RAM_ROLE_NAME_KEY, ramRoleName);
                LOGGER.info("Nacos check auth with ram role.");
                return true;
            }
        }
        return false;
    }

    public static String getNacosNameSpaceFileKey() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, PRO_NAMESPACE_KEY);
    }

    public static String getNacosAddrFileKey() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, PRO_SERVER_ADDR_KEY);
    }

    public static String getNacosGroupKey() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, GROUP_KEY);
    }

    public static String getNacosDataIdKey() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, NACOS_DATA_ID_KEY);
    }

    public static String getNacosUserName() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, USER_NAME);
    }

    public static String getNacosPassword() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, PASSWORD);
    }

    public static String getNacosAccessKey() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, ACCESS_KEY);
    }

    public static String getNacosSecretKey() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, SECRET_KEY);
    }

    public static String getNacosRamRoleNameKey() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, RAM_ROLE_NAME_KEY);
    }

    private String getNacosGroup() {
        return this.fileConfig.getConfig(NacosConfiguration.getNacosGroupKey(), DEFAULT_GROUP);
    }

    private String getNacosDataId() {
        return this.fileConfig.getConfig(NacosConfiguration.getNacosDataIdKey(), DEFAULT_DATA_ID);
    }

    private String getNacosDataType() {
        return ConfigProcessor.resolverConfigDataType((String)this.getNacosDataId());
    }

    private static String getSeataConfigStr() {
        StringBuilder sb = new StringBuilder();
        Enumeration<?> enumeration = seataConfig.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String property = seataConfig.getProperty(key);
            sb.append(key).append("=").append(property).append("\n");
        }
        return sb.toString();
    }

    private static String getNacosContextPathKey() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, CONTEXT_PATH);
    }

    private void initSeataConfig() {
        try {
            String nacosDataId = this.getNacosDataId();
            String config = configService.getConfig(nacosDataId, this.getNacosGroup(), 5000L);
            if (StringUtils.isNotBlank((String)config)) {
                seataConfig = ConfigProcessor.processConfig((String)config, (String)this.getNacosDataType());
                NacosListener nacosListener = new NacosListener(nacosDataId, null);
                configService.addListener(nacosDataId, this.getNacosGroup(), (Listener)nacosListener);
            }
        }
        catch (NacosException | IOException e) {
            LOGGER.error("init config properties error", e);
        }
    }

    public String getTypeName() {
        return CONFIG_TYPE;
    }

    public void dispose() {
        if (null != CONFIG_LISTENERS_MAP) {
            CONFIG_LISTENERS_MAP.clear();
        }
        if (null != seataConfig) {
            seataConfig.clear();
        }
        if (null != configService) {
            configService = null;
        }
        if (null != instance) {
            instance = null;
        }
        this.fileConfig = ConfigurationFactory.CURRENT_FILE_INSTANCE;
    }

    static {
        LOGGER = LoggerFactory.getLogger(NacosConfiguration.class);
        CONFIG_LISTENERS_MAP = new ConcurrentHashMap<String, ConcurrentMap<ConfigurationChangeListener, NacosListener>>(8);
        seataConfig = new Properties();
    }

    public class NacosListener
    extends AbstractSharedListener {
        private final String dataId;
        private final ConfigurationChangeListener listener;

        public NacosListener(String dataId, ConfigurationChangeListener listener) {
            this.dataId = dataId;
            this.listener = listener;
        }

        public ConfigurationChangeListener getTargetListener() {
            return this.listener;
        }

        public void innerReceive(String dataId, String group, String configInfo) {
            if (NacosConfiguration.this.getNacosDataId().equals(dataId)) {
                Properties seataConfigNew = new Properties();
                if (StringUtils.isNotBlank((String)configInfo)) {
                    try {
                        seataConfigNew = ConfigProcessor.processConfig((String)configInfo, (String)NacosConfiguration.this.getNacosDataType());
                    }
                    catch (IOException e) {
                        LOGGER.error("load config properties error", (Throwable)e);
                        return;
                    }
                }
                for (Map.Entry entry : CONFIG_LISTENERS_MAP.entrySet()) {
                    String propertyNew;
                    String listenedDataId = (String)entry.getKey();
                    String propertyOld = seataConfig.getProperty(listenedDataId, NacosConfiguration.DEFAULT_NAMESPACE);
                    if (propertyOld.equals(propertyNew = seataConfigNew.getProperty(listenedDataId, NacosConfiguration.DEFAULT_NAMESPACE))) continue;
                    ConfigurationChangeEvent event = new ConfigurationChangeEvent().setDataId(listenedDataId).setNewValue(propertyNew).setNamespace(group);
                    ConcurrentMap configListeners = (ConcurrentMap)entry.getValue();
                    for (ConfigurationChangeListener configListener : configListeners.keySet()) {
                        configListener.onProcessEvent(event);
                    }
                }
                seataConfig = seataConfigNew;
                return;
            }
            ConfigurationChangeEvent event = new ConfigurationChangeEvent().setDataId(dataId).setNewValue(configInfo).setNamespace(group);
            this.listener.onProcessEvent(event);
        }
    }
}

