/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.seata.rm.datasource.sql.struct.Field;
import org.apache.seata.sqlparser.util.ColumnUtils;

public class SqlGenerateUtils {
    private static final int MAX_IN_SIZE = 1000;

    private SqlGenerateUtils() {
    }

    public static String buildSQLByPKs(String sqlPrefix, String suffix, List<String> pkNameList, int rowSize, String dbType) {
        List<WhereSql> whereList = SqlGenerateUtils.buildWhereConditionListByPKs(pkNameList, rowSize, dbType, 1000);
        StringJoiner sqlJoiner = new StringJoiner(" UNION ");
        whereList.forEach(whereSql -> sqlJoiner.add(sqlPrefix + " " + whereSql.getSql() + " " + suffix));
        return sqlJoiner.toString();
    }

    public static List<WhereSql> buildWhereConditionListByPKs(List<String> pkNameList, int rowSize, String dbType) {
        return SqlGenerateUtils.buildWhereConditionListByPKs(pkNameList, rowSize, dbType, 1000);
    }

    public static List<WhereSql> buildWhereConditionListByPKs(List<String> pkNameList, int rowSize, String dbType, int maxInSize) {
        ArrayList<WhereSql> whereSqls = new ArrayList<WhereSql>();
        int batchSize = rowSize % maxInSize == 0 ? rowSize / maxInSize : rowSize / maxInSize + 1;
        for (int batch = 0; batch < batchSize; ++batch) {
            StringBuilder whereStr = new StringBuilder();
            whereStr.append("(");
            for (int i = 0; i < pkNameList.size(); ++i) {
                if (i > 0) {
                    whereStr.append(",");
                }
                whereStr.append(ColumnUtils.addEscape(pkNameList.get(i), dbType));
            }
            whereStr.append(") in ( ");
            int eachSize = batch == batchSize - 1 ? (rowSize % maxInSize == 0 ? maxInSize : rowSize % maxInSize) : maxInSize;
            for (int i = 0; i < eachSize; ++i) {
                if (i > 0) {
                    whereStr.append(",");
                }
                whereStr.append("(");
                for (int x = 0; x < pkNameList.size(); ++x) {
                    if (x > 0) {
                        whereStr.append(",");
                    }
                    whereStr.append("?");
                }
                whereStr.append(")");
            }
            whereStr.append(" )");
            whereSqls.add(new WhereSql(whereStr.toString(), eachSize, pkNameList.size()));
        }
        return whereSqls;
    }

    public static void setParamForPk(List<Map<String, Field>> pkRowsList, List<String> pkColumnNameList, PreparedStatement pst) throws SQLException {
        int paramIndex = 1;
        for (int i = 0; i < pkRowsList.size(); ++i) {
            Map<String, Field> rowData = pkRowsList.get(i);
            for (String columnName : pkColumnNameList) {
                Field pkField = rowData.get(columnName);
                pst.setObject(paramIndex, pkField.getValue(), pkField.getType());
                ++paramIndex;
            }
        }
    }

    public static String buildWhereConditionByPKs(List<String> pkNameList, String dbType) {
        StringBuilder whereStr = new StringBuilder();
        for (int i = 0; i < pkNameList.size(); ++i) {
            if (i > 0) {
                whereStr.append(" and ");
            }
            String pkName = pkNameList.get(i);
            whereStr.append(ColumnUtils.addEscape(pkName, dbType));
            whereStr.append(" = ? ");
        }
        return whereStr.toString();
    }

    public static class WhereSql {
        private final String sql;
        private final int rowSize;
        private final int pkSize;

        public WhereSql(String sql, int rowSize, int pkSize) {
            this.sql = sql;
            this.rowSize = rowSize;
            this.pkSize = pkSize;
        }

        public String getSql() {
            return this.sql;
        }

        public int getRowSize() {
            return this.rowSize;
        }

        public int getPkSize() {
            return this.pkSize;
        }
    }
}

