/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.rocketmq;

import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.seata.common.exception.NotSupportYetException;
import org.apache.seata.common.lock.ResourceLock;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.integration.rocketmq.SeataMQProducer;
import org.apache.seata.integration.rocketmq.TCCRocketMQ;
import org.apache.seata.integration.rocketmq.TCCRocketMQImpl;
import org.apache.seata.integration.tx.api.util.ProxyUtil;

public class SeataMQProducerFactory {
    public static final String ROCKET_TCC_NAME = "tccRocketMQ";
    public static final BranchType ROCKET_BRANCH_TYPE = BranchType.TCC;
    private static final ResourceLock RESOURCE_LOCK = new ResourceLock();
    private static SeataMQProducer defaultProducer;

    public static SeataMQProducer createSingle(String nameServer, String producerGroup) throws MQClientException {
        return SeataMQProducerFactory.createSingle(nameServer, null, producerGroup, null);
    }

    public static SeataMQProducer createSingle(String nameServer, String namespace, String groupName, RPCHook rpcHook) throws MQClientException {
        if (defaultProducer == null) {
            try (ResourceLock ignored = RESOURCE_LOCK.obtain();){
                if (defaultProducer == null) {
                    defaultProducer = new SeataMQProducer(namespace, groupName, rpcHook);
                    defaultProducer.setNamesrvAddr(nameServer);
                    TCCRocketMQ tccRocketMQProxy = ProxyUtil.createProxy(new TCCRocketMQImpl());
                    tccRocketMQProxy.setProducer(defaultProducer);
                    defaultProducer.setTccRocketMQ(tccRocketMQProxy);
                    defaultProducer.start();
                    SeataMQProducer seataMQProducer = defaultProducer;
                    return seataMQProducer;
                }
            }
        }
        throw new NotSupportYetException("only one seata producer is permitted");
    }

    public static SeataMQProducer getProducer() {
        return defaultProducer;
    }
}

