/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcp.xml.dsig.internal.dom;

import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import org.apache.jcp.xml.dsig.internal.dom.DOMUtils;
import org.apache.jcp.xml.dsig.internal.dom.XmlWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XmlWriterToTree
implements XmlWriter {
    private Document m_factory;
    private Element m_createdElement;
    private Node m_nextSibling;
    private Node m_currentNode;
    private List<XmlWriter.ToMarshal<? extends XMLStructure>> m_marshallers;

    public XmlWriterToTree(List<XmlWriter.ToMarshal<? extends XMLStructure>> marshallers, Node parent) {
        this.m_marshallers = marshallers;
        this.m_factory = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        this.m_currentNode = parent;
    }

    public void resetToNewParent(Node newParent) {
        this.m_currentNode = newParent;
        this.m_createdElement = null;
    }

    public Element getCreatedElement() {
        return this.m_createdElement;
    }

    public XmlWriterToTree(List<XmlWriter.ToMarshal<? extends XMLStructure>> marshallers, Node parent, Node nextSibling) {
        this(marshallers, parent);
        this.m_nextSibling = nextSibling;
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) {
        Element newElem = this.m_factory.createElementNS(namespaceURI, DOMUtils.getQNameString(prefix, localName));
        newElem = this.m_nextSibling != null ? (Element)this.m_nextSibling.getParentNode().insertBefore(newElem, this.m_nextSibling) : (Element)this.m_currentNode.appendChild(newElem);
        this.m_nextSibling = null;
        this.m_currentNode = newElem;
        if (this.m_createdElement == null) {
            this.m_createdElement = newElem;
        }
    }

    @Override
    public void writeEndElement() {
        this.m_currentNode = this.m_currentNode.getParentNode();
    }

    @Override
    public void writeTextElement(String prefix, String localName, String namespaceURI, String value) {
        this.writeStartElement(prefix, localName, namespaceURI);
        this.writeCharacters(value);
        this.writeEndElement();
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) {
        if ("".equals(prefix)) {
            this.writeAttribute(null, "http://www.w3.org/2000/xmlns/", "xmlns", namespaceURI);
        } else {
            this.writeAttribute("xmlns", "http://www.w3.org/2000/xmlns/", prefix, namespaceURI);
        }
    }

    @Override
    public void writeCharacters(String text) {
        Text textNode = this.m_factory.createTextNode(text);
        this.m_currentNode.appendChild(textNode);
    }

    @Override
    public void writeComment(String text) {
        Comment commentNode = this.m_factory.createComment(text);
        this.m_currentNode.appendChild(commentNode);
    }

    @Override
    public Attr writeAttribute(String prefix, String namespaceURI, String localName, String value) {
        Attr result = null;
        if (value != null) {
            result = this.m_factory.createAttributeNS(namespaceURI, DOMUtils.getQNameString(prefix, localName));
            result.setTextContent(value);
            if (!(this.m_currentNode instanceof Element)) {
                throw new IllegalStateException("Attempting to add an attribute to something other than an element node. Node is " + this.m_currentNode.toString());
            }
            ((Element)this.m_currentNode).setAttributeNodeNS(result);
        }
        return result;
    }

    @Override
    public void writeIdAttribute(String prefix, String namespaceURI, String localName, String value) {
        if (value == null) {
            return;
        }
        Attr newAttr = this.writeAttribute(prefix, namespaceURI, localName, value);
        ((Element)this.m_currentNode).setIdAttributeNode(newAttr, true);
    }

    @Override
    public String getCurrentLocalName() {
        return this.m_currentNode.getLocalName();
    }

    @Override
    public XMLStructure getCurrentNodeAsStructure() {
        return new DOMStructure(this.m_currentNode);
    }

    @Override
    public void marshalStructure(XMLStructure toMarshal, String dsPrefix, XMLCryptoContext context) throws MarshalException {
        for (int idx = 0; idx < this.m_marshallers.size(); ++idx) {
            XmlWriter.ToMarshal<? extends XMLStructure> marshaller = this.m_marshallers.get(idx);
            if (!marshaller.clazzToMatch.isInstance(toMarshal)) continue;
            marshaller.marshalObject(this, toMarshal, dsPrefix, context);
            return;
        }
        throw new IllegalArgumentException("Unable to marshal unexpected object of class " + toMarshal.getClass().toString());
    }
}

