/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.schedule;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.common.ConfigManager;
import org.apache.rocketmq.common.TopicFilterType;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.running.RunningStats;
import org.apache.rocketmq.store.ConsumeQueue;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.MessageExtBrokerInner;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.config.StorePathConfigHelper;
import org.apache.rocketmq.store.schedule.DelayOffsetSerializeWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleMessageService
extends ConfigManager {
    public static final String SCHEDULE_TOPIC = "SCHEDULE_TOPIC_XXXX";
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private static final long FIRST_DELAY_TIME = 1000L;
    private static final long DELAY_FOR_A_WHILE = 100L;
    private static final long DELAY_FOR_A_PERIOD = 10000L;
    private final ConcurrentHashMap<Integer, Long> delayLevelTable = new ConcurrentHashMap(32);
    private final ConcurrentHashMap<Integer, Long> offsetTable = new ConcurrentHashMap(32);
    private final Timer timer = new Timer("ScheduleMessageTimerThread", true);
    private final DefaultMessageStore defaultMessageStore;
    private int maxDelayLevel;

    public ScheduleMessageService(DefaultMessageStore defaultMessageStore) {
        this.defaultMessageStore = defaultMessageStore;
    }

    public static int queueId2DelayLevel(int queueId) {
        return queueId + 1;
    }

    public static int delayLevel2QueueId(int delayLevel) {
        return delayLevel - 1;
    }

    public void buildRunningStats(HashMap<String, String> stats) {
        for (Map.Entry<Integer, Long> next : this.offsetTable.entrySet()) {
            int queueId = ScheduleMessageService.delayLevel2QueueId(next.getKey());
            long delayOffset = next.getValue();
            long maxOffset = this.defaultMessageStore.getMaxOffsetInQuque(SCHEDULE_TOPIC, queueId);
            String value = String.format("%d,%d", delayOffset, maxOffset);
            String key = String.format("%s_%d", RunningStats.scheduleMessageOffset.name(), next.getKey());
            stats.put(key, value);
        }
    }

    private void updateOffset(int delayLevel, long offset) {
        this.offsetTable.put(delayLevel, offset);
    }

    public long computeDeliverTimestamp(int delayLevel, long storeTimestamp) {
        Long time = this.delayLevelTable.get(delayLevel);
        if (time != null) {
            return time + storeTimestamp;
        }
        return storeTimestamp + 1000L;
    }

    public void start() {
        for (Map.Entry<Integer, Long> entry : this.delayLevelTable.entrySet()) {
            Integer level = entry.getKey();
            Long timeDelay = entry.getValue();
            Long offset = this.offsetTable.get(level);
            if (null == offset) {
                offset = 0L;
            }
            if (timeDelay == null) continue;
            this.timer.schedule((TimerTask)new DeliverDelayedMessageTimerTask(level, offset), 1000L);
        }
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    ScheduleMessageService.this.persist();
                }
                catch (Exception e) {
                    log.error("scheduleAtFixedRate flush exception", (Throwable)e);
                }
            }
        }, 10000L, this.defaultMessageStore.getMessageStoreConfig().getFlushDelayOffsetInterval());
    }

    public void shutdown() {
        this.timer.cancel();
    }

    public int getMaxDelayLevel() {
        return this.maxDelayLevel;
    }

    public String encode() {
        return this.encode(false);
    }

    public boolean load() {
        boolean result = super.load();
        result = result && this.parseDelayLevel();
        return result;
    }

    public String configFilePath() {
        return StorePathConfigHelper.getDelayOffsetStorePath(this.defaultMessageStore.getMessageStoreConfig().getStorePathRootDir());
    }

    public void decode(String jsonString) {
        DelayOffsetSerializeWrapper delayOffsetSerializeWrapper;
        if (jsonString != null && (delayOffsetSerializeWrapper = (DelayOffsetSerializeWrapper)((Object)DelayOffsetSerializeWrapper.fromJson((String)jsonString, DelayOffsetSerializeWrapper.class))) != null) {
            this.offsetTable.putAll(delayOffsetSerializeWrapper.getOffsetTable());
        }
    }

    public String encode(boolean prettyFormat) {
        DelayOffsetSerializeWrapper delayOffsetSerializeWrapper = new DelayOffsetSerializeWrapper();
        delayOffsetSerializeWrapper.setOffsetTable(this.offsetTable);
        return delayOffsetSerializeWrapper.toJson(prettyFormat);
    }

    public boolean parseDelayLevel() {
        HashMap<String, Long> timeUnitTable = new HashMap<String, Long>();
        timeUnitTable.put("s", 1000L);
        timeUnitTable.put("m", 60000L);
        timeUnitTable.put("h", 3600000L);
        timeUnitTable.put("d", 86400000L);
        String levelString = this.defaultMessageStore.getMessageStoreConfig().getMessageDelayLevel();
        try {
            String[] levelArray = levelString.split(" ");
            for (int i = 0; i < levelArray.length; ++i) {
                String value = levelArray[i];
                String ch = value.substring(value.length() - 1);
                Long tu = (Long)timeUnitTable.get(ch);
                int level = i + 1;
                if (level > this.maxDelayLevel) {
                    this.maxDelayLevel = level;
                }
                long num = Long.parseLong(value.substring(0, value.length() - 1));
                long delayTimeMillis = tu * num;
                this.delayLevelTable.put(level, delayTimeMillis);
            }
        }
        catch (Exception e) {
            log.error("parseDelayLevel exception", (Throwable)e);
            log.info("levelString String = {}", (Object)levelString);
            return false;
        }
        return true;
    }

    class DeliverDelayedMessageTimerTask
    extends TimerTask {
        private final int delayLevel;
        private final long offset;

        public DeliverDelayedMessageTimerTask(int delayLevel, long offset) {
            this.delayLevel = delayLevel;
            this.offset = offset;
        }

        @Override
        public void run() {
            try {
                this.executeOnTimeup();
            }
            catch (Exception e) {
                log.error("ScheduleMessageService, executeOnTimeup exception", (Throwable)e);
                ScheduleMessageService.this.timer.schedule((TimerTask)new DeliverDelayedMessageTimerTask(this.delayLevel, this.offset), 10000L);
            }
        }

        private long correctDeliverTimestamp(long now, long deliverTimestamp) {
            long result = deliverTimestamp;
            long maxTimestamp = now + (Long)ScheduleMessageService.this.delayLevelTable.get(this.delayLevel);
            if (deliverTimestamp > maxTimestamp) {
                result = now;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void executeOnTimeup() {
            ConsumeQueue cq = ScheduleMessageService.this.defaultMessageStore.findConsumeQueue(ScheduleMessageService.SCHEDULE_TOPIC, ScheduleMessageService.delayLevel2QueueId(this.delayLevel));
            long failScheduleOffset = this.offset;
            if (cq != null) {
                SelectMappedBufferResult bufferCQ = cq.getIndexBuffer(this.offset);
                if (bufferCQ != null) {
                    try {
                        int i;
                        long nextOffset = this.offset;
                        for (i = 0; i < bufferCQ.getSize(); i += 20) {
                            long offsetPy = bufferCQ.getByteBuffer().getLong();
                            int sizePy = bufferCQ.getByteBuffer().getInt();
                            long tagsCode = bufferCQ.getByteBuffer().getLong();
                            long now = System.currentTimeMillis();
                            long deliverTimestamp = this.correctDeliverTimestamp(now, tagsCode);
                            nextOffset = this.offset + (long)(i / 20);
                            long countdown = deliverTimestamp - now;
                            if (countdown <= 0L) {
                                MessageExt msgExt = ScheduleMessageService.this.defaultMessageStore.lookMessageByOffset(offsetPy, sizePy);
                                if (msgExt == null) continue;
                                try {
                                    MessageExtBrokerInner msgInner = this.messageTimeup(msgExt);
                                    PutMessageResult putMessageResult = ScheduleMessageService.this.defaultMessageStore.putMessage(msgInner);
                                    if (putMessageResult == null || putMessageResult.getPutMessageStatus() != PutMessageStatus.PUT_OK) {
                                        log.error("ScheduleMessageService, a message time up, but reput it failed, topic: {} msgId {}", (Object)msgExt.getTopic(), (Object)msgExt.getMsgId());
                                        ScheduleMessageService.this.timer.schedule((TimerTask)new DeliverDelayedMessageTimerTask(this.delayLevel, nextOffset), 10000L);
                                        ScheduleMessageService.this.updateOffset(this.delayLevel, nextOffset);
                                        return;
                                    }
                                }
                                catch (Exception e) {
                                    log.error("ScheduleMessageService, messageTimeup execute error, drop it. msgExt=" + msgExt + ", nextOffset=" + nextOffset + ",offsetPy=" + offsetPy + ",sizePy=" + sizePy, (Throwable)e);
                                }
                                continue;
                            }
                            ScheduleMessageService.this.timer.schedule((TimerTask)new DeliverDelayedMessageTimerTask(this.delayLevel, nextOffset), countdown);
                            ScheduleMessageService.this.updateOffset(this.delayLevel, nextOffset);
                            return;
                        }
                        nextOffset = this.offset + (long)(i / 20);
                        ScheduleMessageService.this.timer.schedule((TimerTask)new DeliverDelayedMessageTimerTask(this.delayLevel, nextOffset), 100L);
                        ScheduleMessageService.this.updateOffset(this.delayLevel, nextOffset);
                        return;
                    }
                    finally {
                        bufferCQ.release();
                    }
                }
                long cqMinOffset = cq.getMinOffsetInQueue();
                if (this.offset < cqMinOffset) {
                    failScheduleOffset = cqMinOffset;
                    log.error("schedule CQ offset invalid. offset=" + this.offset + ", cqMinOffset=" + cqMinOffset + ", queueId=" + cq.getQueueId());
                }
            }
            ScheduleMessageService.this.timer.schedule((TimerTask)new DeliverDelayedMessageTimerTask(this.delayLevel, failScheduleOffset), 100L);
        }

        private MessageExtBrokerInner messageTimeup(MessageExt msgExt) {
            MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
            msgInner.setBody(msgExt.getBody());
            msgInner.setFlag(msgExt.getFlag());
            MessageAccessor.setProperties((Message)msgInner, (Map)msgExt.getProperties());
            TopicFilterType topicFilterType = MessageExt.parseTopicFilterType((int)msgInner.getSysFlag());
            long tagsCodeValue = MessageExtBrokerInner.tagsString2tagsCode(topicFilterType, msgInner.getTags());
            msgInner.setTagsCode(tagsCodeValue);
            msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgExt.getProperties()));
            msgInner.setSysFlag(msgExt.getSysFlag());
            msgInner.setBornTimestamp(msgExt.getBornTimestamp());
            msgInner.setBornHost(msgExt.getBornHost());
            msgInner.setStoreHost(msgExt.getStoreHost());
            msgInner.setReconsumeTimes(msgExt.getReconsumeTimes());
            msgInner.setWaitStoreMsgOK(false);
            MessageAccessor.clearProperty((Message)msgInner, (String)"DELAY");
            msgInner.setTopic(msgInner.getProperty("REAL_TOPIC"));
            String queueIdStr = msgInner.getProperty("REAL_QID");
            int queueId = Integer.parseInt(queueIdStr);
            msgInner.setQueueId(queueId);
            return msgInner;
        }
    }
}

