/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.api;

import java.util.concurrent.TimeUnit;

public class MetadataCacheConfig {
    private static final long DEFAULT_CACHE_REFRESH_TIME_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    private final long refreshAfterWriteMillis;
    private final long expireAfterWriteMillis;

    private static long $default$refreshAfterWriteMillis() {
        return DEFAULT_CACHE_REFRESH_TIME_MILLIS;
    }

    private static long $default$expireAfterWriteMillis() {
        return 2L * DEFAULT_CACHE_REFRESH_TIME_MILLIS;
    }

    MetadataCacheConfig(long refreshAfterWriteMillis, long expireAfterWriteMillis) {
        this.refreshAfterWriteMillis = refreshAfterWriteMillis;
        this.expireAfterWriteMillis = expireAfterWriteMillis;
    }

    public static MetadataCacheConfigBuilder builder() {
        return new MetadataCacheConfigBuilder();
    }

    public long getRefreshAfterWriteMillis() {
        return this.refreshAfterWriteMillis;
    }

    public long getExpireAfterWriteMillis() {
        return this.expireAfterWriteMillis;
    }

    public String toString() {
        return "MetadataCacheConfig(refreshAfterWriteMillis=" + this.getRefreshAfterWriteMillis() + ", expireAfterWriteMillis=" + this.getExpireAfterWriteMillis() + ")";
    }

    public static class MetadataCacheConfigBuilder {
        private boolean refreshAfterWriteMillis$set;
        private long refreshAfterWriteMillis$value;
        private boolean expireAfterWriteMillis$set;
        private long expireAfterWriteMillis$value;

        MetadataCacheConfigBuilder() {
        }

        public MetadataCacheConfigBuilder refreshAfterWriteMillis(long refreshAfterWriteMillis) {
            this.refreshAfterWriteMillis$value = refreshAfterWriteMillis;
            this.refreshAfterWriteMillis$set = true;
            return this;
        }

        public MetadataCacheConfigBuilder expireAfterWriteMillis(long expireAfterWriteMillis) {
            this.expireAfterWriteMillis$value = expireAfterWriteMillis;
            this.expireAfterWriteMillis$set = true;
            return this;
        }

        public MetadataCacheConfig build() {
            long refreshAfterWriteMillis$value = this.refreshAfterWriteMillis$value;
            if (!this.refreshAfterWriteMillis$set) {
                refreshAfterWriteMillis$value = MetadataCacheConfig.$default$refreshAfterWriteMillis();
            }
            long expireAfterWriteMillis$value = this.expireAfterWriteMillis$value;
            if (!this.expireAfterWriteMillis$set) {
                expireAfterWriteMillis$value = MetadataCacheConfig.$default$expireAfterWriteMillis();
            }
            return new MetadataCacheConfig(refreshAfterWriteMillis$value, expireAfterWriteMillis$value);
        }

        public String toString() {
            return "MetadataCacheConfig.MetadataCacheConfigBuilder(refreshAfterWriteMillis$value=" + this.refreshAfterWriteMillis$value + ", expireAfterWriteMillis$value=" + this.expireAfterWriteMillis$value + ")";
        }
    }
}

