/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.pdfbox.multipdf.Overlay;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.tools.Version;
import picocli.CommandLine;

@CommandLine.Command(name="overlaypdf", header={"Adds an overlay to a PDF document"}, versionProvider=Version.class, mixinStandardHelpOptions=true)
public final class OverlayPDF
implements Callable<Integer> {
    private final PrintStream SYSERR;
    @CommandLine.Option(names={"-odd"}, description={"overlay file used for odd pages"})
    private File oddPageOverlay;
    @CommandLine.Option(names={"-even"}, description={"overlay file used for even pages"})
    private File evenPageOverlay;
    @CommandLine.Option(names={"-first"}, description={"overlay file used for the first page"})
    private File firstPageOverlay;
    @CommandLine.Option(names={"-last"}, description={"overlay file used for the last page"})
    private File lastPageOverlay;
    @CommandLine.Option(names={"-useAllPages"}, description={"overlay file used for overlay, all pages are used by simply repeating them"})
    private File useAllPages;
    @CommandLine.Option(names={"-page"}, description={"overlay file used for the given page number, may occur more than once"})
    Map<Integer, String> specificPageOverlayFile = new HashMap<Integer, String>();
    @CommandLine.Option(names={"-default"}, description={"the default overlay file"})
    private File defaultOverlay;
    @CommandLine.Option(names={"-position"}, description={"where to put the overlay file: foreground or background (default: ${DEFAULT-VALUE})"})
    private Overlay.Position position = Overlay.Position.BACKGROUND;
    @CommandLine.Option(names={"-i", "--input"}, description={"the PDF input file"}, required=true)
    private File infile;
    @CommandLine.Option(names={"-o", "--output"}, description={"the PDF output file"}, required=true)
    private File outfile;

    public OverlayPDF() {
        this.SYSERR = System.err;
    }

    public static void main(String[] args) {
        System.setProperty("apple.awt.UIElement", "true");
        int exitCode = new CommandLine((Object)new OverlayPDF()).execute(args);
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() {
        int retcode = 0;
        Overlay overlayer = new Overlay();
        overlayer.setOverlayPosition(this.position);
        if (this.firstPageOverlay != null) {
            overlayer.setFirstPageOverlayFile(this.firstPageOverlay.getAbsolutePath());
        }
        if (this.lastPageOverlay != null) {
            overlayer.setLastPageOverlayFile(this.lastPageOverlay.getAbsolutePath());
        }
        if (this.oddPageOverlay != null) {
            overlayer.setOddPageOverlayFile(this.oddPageOverlay.getAbsolutePath());
        }
        if (this.evenPageOverlay != null) {
            overlayer.setEvenPageOverlayFile(this.evenPageOverlay.getAbsolutePath());
        }
        if (this.useAllPages != null) {
            overlayer.setAllPagesOverlayFile(this.useAllPages.getAbsolutePath());
        }
        try (PDDocument result = overlayer.overlay(this.specificPageOverlayFile);){
            result.save(this.outfile);
        }
        catch (IOException ioe) {
            this.SYSERR.println("Error adding overlay(s) to PDF [" + ioe.getClass().getSimpleName() + "]: " + ioe.getMessage());
            Integer n = 4;
            return n;
        }
        finally {
            try {
                overlayer.close();
            }
            catch (IOException ioe) {
                this.SYSERR.println("Error adding overlay(s) to PDF [" + ioe.getClass().getSimpleName() + "]: " + ioe.getMessage());
                retcode = 4;
            }
        }
        return retcode;
    }
}

