/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jacob.vpu;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.ode.jacob.Channel;
import org.apache.ode.jacob.soup.CommChannel;
import org.apache.ode.jacob.vpu.JacobVPU;
import org.apache.ode.utils.CollectionUtils;

public class ChannelFactory {
    private static final Method METHOD_OBJECT_EQUALS;
    private static final Method METHOD_CHANNEL_EXPORT;

    public static Object getBackend(Channel channel) {
        ChannelInvocationHandler channelInvocationHandler = (ChannelInvocationHandler)Proxy.getInvocationHandler(channel);
        return channelInvocationHandler._backend;
    }

    public static Channel createChannel(CommChannel commChannel, Class clazz) {
        ChannelInvocationHandler channelInvocationHandler = new ChannelInvocationHandler(commChannel);
        Class[] classArray = new Class[]{Channel.class, clazz};
        Object object = Proxy.newProxyInstance(Channel.class.getClassLoader(), classArray, (InvocationHandler)channelInvocationHandler);
        return (Channel)object;
    }

    static {
        try {
            METHOD_OBJECT_EQUALS = Object.class.getMethod("equals", Object.class);
        }
        catch (Exception exception) {
            throw new AssertionError((Object)"No equals(Object) method on Object!");
        }
        try {
            METHOD_CHANNEL_EXPORT = Channel.class.getMethod("export", CollectionUtils.EMPTY_CLASS_ARRAY);
        }
        catch (Exception exception) {
            throw new AssertionError((Object)"No export() method on Object!");
        }
    }

    public static final class ChannelInvocationHandler
    implements InvocationHandler {
        private CommChannel _backend;

        ChannelInvocationHandler(CommChannel commChannel) {
            this._backend = commChannel;
        }

        public String toString() {
            return this._backend.toString();
        }

        public boolean equals(Object object) {
            return ((ChannelInvocationHandler)object)._backend.equals(this._backend);
        }

        public int hashCode() {
            return this._backend.hashCode();
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                if (method.equals(METHOD_OBJECT_EQUALS)) {
                    return this.equals(Proxy.getInvocationHandler(objectArray[0]));
                }
                return method.invoke((Object)this, objectArray);
            }
            if (method.equals(METHOD_CHANNEL_EXPORT)) {
                return JacobVPU.activeJacobThread().exportChannel((Channel)object);
            }
            return JacobVPU.activeJacobThread().message((Channel)object, method, objectArray);
        }
    }
}

