/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.hbase;

import org.apache.metamodel.AbstractUpdateCallback;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.create.TableCreationBuilder;
import org.apache.metamodel.delete.RowDeletionBuilder;
import org.apache.metamodel.drop.TableDropBuilder;
import org.apache.metamodel.hbase.HBaseCreateTableBuilder;
import org.apache.metamodel.hbase.HBaseDataContext;
import org.apache.metamodel.hbase.HBaseRowDeletionBuilder;
import org.apache.metamodel.hbase.HBaseRowInsertionBuilder;
import org.apache.metamodel.hbase.HBaseTable;
import org.apache.metamodel.hbase.HBaseTableDropBuilder;
import org.apache.metamodel.insert.RowInsertionBuilder;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;

final class HBaseUpdateCallback
extends AbstractUpdateCallback
implements UpdateCallback {
    public HBaseUpdateCallback(HBaseDataContext dataContext) {
        super((DataContext)dataContext);
    }

    public TableCreationBuilder createTable(Schema schema, String name) {
        return new HBaseCreateTableBuilder(this, schema, name);
    }

    public boolean isDropTableSupported() {
        return true;
    }

    public TableDropBuilder dropTable(Table table) {
        return new HBaseTableDropBuilder(table, this);
    }

    public RowInsertionBuilder insertInto(Table table) {
        if (table instanceof HBaseTable) {
            return new HBaseRowInsertionBuilder(this, (HBaseTable)table);
        }
        throw new IllegalArgumentException("Not an HBase table: " + table);
    }

    public boolean isDeleteSupported() {
        return true;
    }

    public RowDeletionBuilder deleteFrom(Table table) {
        if (table instanceof HBaseTable) {
            return new HBaseRowDeletionBuilder((HBaseDataContext)this.getDataContext(), table);
        }
        throw new IllegalArgumentException("Not an HBase table: " + table);
    }
}

