/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.hbase;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Table;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.data.AbstractDataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.hbase.HBaseRow;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HBaseDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger(HBaseDataSet.class);
    private final ResultScanner _scanner;
    private final Table _hTable;
    private volatile Result _nextResult;

    public HBaseDataSet(List<Column> columns, ResultScanner scanner, Table hTable) {
        super(columns.stream().map(SelectItem::new).collect(Collectors.toList()));
        this._scanner = scanner;
        this._hTable = hTable;
    }

    public void close() {
        super.close();
        try {
            this._scanner.close();
        }
        catch (Exception e) {
            logger.warn("Failed to close ResultScanner", (Throwable)e);
        }
        try {
            this._hTable.close();
        }
        catch (Exception e) {
            logger.warn("Failed to close HTable", (Throwable)e);
        }
    }

    public boolean next() {
        try {
            this._nextResult = this._scanner.next();
        }
        catch (IOException e) {
            throw new MetaModelException((Exception)e);
        }
        return this._nextResult != null;
    }

    public Row getRow() {
        return new HBaseRow(this.getHeader(), this._nextResult);
    }
}

