/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.hbase;

import org.apache.metamodel.hbase.HBaseTable;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.Table;

final class HBaseColumn
extends MutableColumn {
    public static final ColumnType DEFAULT_COLUMN_TYPE_FOR_ID_COLUMN = ColumnType.BINARY;
    public static final ColumnType DEFAULT_COLUMN_TYPE_FOR_COLUMN_FAMILIES = ColumnType.LIST;
    private final String columnFamily;
    private final String qualifier;

    public HBaseColumn(String columnFamily, Table table) {
        this(columnFamily, null, table, -1, null);
    }

    public HBaseColumn(String columnFamily, String qualifier, Table table) {
        this(columnFamily, qualifier, table, -1, null);
    }

    public HBaseColumn(String columnFamily, String qualifier, Table table, int columnNumber, ColumnType columnType) {
        super(HBaseColumn.getName(columnFamily, qualifier), table);
        if (columnFamily == null) {
            throw new IllegalArgumentException("Column family isn't allowed to be null.");
        }
        if (table == null || !(table instanceof HBaseTable)) {
            throw new IllegalArgumentException("Table is null or isn't a HBaseTable.");
        }
        this.columnFamily = columnFamily;
        this.qualifier = qualifier;
        this.setColumnNumber(columnNumber);
        this.setPrimaryKey("_id".equals(columnFamily));
        if (columnType != null) {
            this.setType(columnType);
        } else if (this.isPrimaryKey() || qualifier != null) {
            this.setType(DEFAULT_COLUMN_TYPE_FOR_ID_COLUMN);
        } else {
            this.setType(DEFAULT_COLUMN_TYPE_FOR_COLUMN_FAMILIES);
        }
    }

    public String getColumnFamily() {
        return this.columnFamily;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    private static String getName(String columnFamily, String qualifier) {
        if (qualifier == null) {
            return columnFamily;
        }
        return columnFamily + ":" + qualifier;
    }

    public Boolean isNullable() {
        return !this.isPrimaryKey();
    }

    public String getRemarks() {
        return null;
    }

    public Integer getColumnSize() {
        return null;
    }

    public String getNativeType() {
        return "byte[]";
    }

    public boolean isIndexed() {
        return false;
    }

    public String getQuote() {
        return null;
    }
}

