/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.hbase;

import java.util.List;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.hbase.HBaseDataContext;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.TableType;
import org.apache.metamodel.util.SimpleTableDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HBaseTable
extends MutableTable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(HBaseTable.class);
    private final transient HBaseDataContext _dataContext;
    private final transient ColumnType _defaultRowKeyColumnType;

    public HBaseTable(HBaseDataContext dataContext, SimpleTableDef tableDef, MutableSchema schema, ColumnType defaultRowKeyColumnType) {
        super(tableDef.getName(), TableType.TABLE, (Schema)schema);
        this._dataContext = dataContext;
        this._defaultRowKeyColumnType = defaultRowKeyColumnType;
        String[] columnNames = tableDef.getColumnNames();
        if (columnNames == null || columnNames.length == 0) {
            logger.info("No user-defined columns specified for table {}. Columns will be auto-detected.");
        } else {
            ColumnType type;
            String columnName;
            int i;
            ColumnType[] types = tableDef.getColumnTypes();
            int columnNumber = 1;
            for (i = 0; i < columnNames.length; ++i) {
                columnName = columnNames[i];
                if (!"_id".equals(columnName)) continue;
                type = types[i];
                MutableColumn idColumn = new MutableColumn("_id", type).setPrimaryKey(true).setColumnNumber(columnNumber).setTable((Table)this);
                this.addColumn((Column)idColumn);
                ++columnNumber;
            }
            if (columnNumber == 1) {
                MutableColumn idColumn = new MutableColumn("_id", defaultRowKeyColumnType).setPrimaryKey(true).setColumnNumber(columnNumber).setTable((Table)this);
                this.addColumn((Column)idColumn);
                ++columnNumber;
            }
            for (i = 0; i < columnNames.length; ++i) {
                columnName = columnNames[i];
                if ("_id".equals(columnName)) continue;
                type = types[i];
                MutableColumn column = new MutableColumn(columnName, type);
                column.setTable((Table)this);
                column.setColumnNumber(columnNumber);
                ++columnNumber;
                this.addColumn((Column)column);
            }
        }
    }

    protected List<Column> getColumnsInternal() {
        List columnsInternal = super.getColumnsInternal();
        if (columnsInternal.isEmpty() && this._dataContext != null) {
            try {
                org.apache.hadoop.hbase.client.Table table = this._dataContext.getHTable(this.getName());
                int columnNumber = 1;
                MutableColumn idColumn = new MutableColumn("_id", this._defaultRowKeyColumnType).setPrimaryKey(true).setColumnNumber(columnNumber).setTable((Table)this);
                this.addColumn((Column)idColumn);
                ++columnNumber;
                HColumnDescriptor[] columnFamilies = table.getTableDescriptor().getColumnFamilies();
                for (int i = 0; i < columnFamilies.length; ++i) {
                    HColumnDescriptor columnDescriptor = columnFamilies[i];
                    String columnFamilyName = columnDescriptor.getNameAsString();
                    ColumnType type = ColumnType.MAP;
                    MutableColumn column = new MutableColumn(columnFamilyName, type);
                    column.setTable((Table)this);
                    column.setColumnNumber(columnNumber);
                    ++columnNumber;
                    this.addColumn((Column)column);
                }
            }
            catch (Exception e) {
                throw new MetaModelException("Could not resolve table ", e);
            }
        }
        return columnsInternal;
    }
}

