/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.rest;

import java.util.HashMap;
import java.util.List;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.elasticsearch.common.ElasticSearchUtils;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestDataContext;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestUpdateCallback;
import org.apache.metamodel.insert.AbstractRowInsertionBuilder;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ElasticSearchRestInsertBuilder
extends AbstractRowInsertionBuilder<ElasticSearchRestUpdateCallback> {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchRestInsertBuilder.class);

    public ElasticSearchRestInsertBuilder(ElasticSearchRestUpdateCallback updateCallback, Table table) {
        super((UpdateCallback)updateCallback, table);
    }

    public void execute() throws MetaModelException {
        ElasticSearchRestUpdateCallback updateCallback = (ElasticSearchRestUpdateCallback)this.getUpdateCallback();
        ElasticSearchRestDataContext dataContext = updateCallback.getDataContext();
        String indexName = dataContext.getIndexName();
        List tables = dataContext.getDefaultSchema().getTables();
        if (!tables.isEmpty() && !((Table)tables.get(0)).getName().equals(this.getTable().getName())) {
            throw new MetaModelException("Can't add more than one table to Elasticsearch index.");
        }
        HashMap<String, Object> source = new HashMap<String, Object>();
        Column[] columns = this.getColumns();
        Object[] values = this.getValues();
        String id = null;
        for (int i = 0; i < columns.length; ++i) {
            if (!this.isSet(columns[i])) continue;
            String columnName = columns[i].getName();
            Object value = values[i];
            if ("_id".equals(columnName)) {
                if (value == null) continue;
                id = value.toString();
                continue;
            }
            String fieldName = ElasticSearchUtils.getValidatedFieldName((String)columnName);
            source.put(fieldName, value);
        }
        if (!source.isEmpty()) {
            IndexRequest indexRequest = new IndexRequest(indexName).id(id);
            indexRequest.source(source);
            ((ElasticSearchRestUpdateCallback)this.getUpdateCallback()).execute((ActionRequest)indexRequest);
        } else {
            logger.info("Source is empty, no index request is executed.");
        }
    }
}

