/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.facet.DrillSidewaysScorer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

class DrillSidewaysQuery
extends Query {
    final Query baseQuery;
    final Collector drillDownCollector;
    final Collector[] drillSidewaysCollectors;
    final Query[] drillDownQueries;
    final boolean scoreSubDocsAtOnce;

    DrillSidewaysQuery(Query baseQuery, Collector drillDownCollector, Collector[] drillSidewaysCollectors, Query[] drillDownQueries, boolean scoreSubDocsAtOnce) {
        this.baseQuery = Objects.requireNonNull(baseQuery);
        this.drillDownCollector = drillDownCollector;
        this.drillSidewaysCollectors = drillSidewaysCollectors;
        this.drillDownQueries = drillDownQueries;
        this.scoreSubDocsAtOnce = scoreSubDocsAtOnce;
    }

    public String toString(String field) {
        return "DrillSidewaysQuery";
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewrittenQuery;
        Query newQuery = this.baseQuery;
        while ((rewrittenQuery = newQuery.rewrite(reader)) != newQuery) {
            newQuery = rewrittenQuery;
        }
        if (newQuery == this.baseQuery) {
            return super.rewrite(reader);
        }
        return new DrillSidewaysQuery(newQuery, this.drillDownCollector, this.drillSidewaysCollectors, this.drillDownQueries, this.scoreSubDocsAtOnce);
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        final Weight baseWeight = this.baseQuery.createWeight(searcher, needsScores, boost);
        final Weight[] drillDowns = new Weight[this.drillDownQueries.length];
        for (int dim = 0; dim < this.drillDownQueries.length; ++dim) {
            drillDowns[dim] = searcher.createNormalizedWeight(this.drillDownQueries[dim], false);
        }
        return new Weight(this){

            public void extractTerms(Set<Term> terms) {
            }

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                return baseWeight.explain(context, doc);
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                throw new UnsupportedOperationException();
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                if (!baseWeight.isCacheable(ctx)) {
                    return false;
                }
                for (Weight w : drillDowns) {
                    if (w.isCacheable(ctx)) continue;
                    return false;
                }
                return true;
            }

            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                Scorer baseScorer = baseWeight.scorer(context);
                DrillSidewaysScorer.DocsAndCost[] dims = new DrillSidewaysScorer.DocsAndCost[drillDowns.length];
                int nullCount = 0;
                for (int dim = 0; dim < dims.length; ++dim) {
                    Scorer scorer = drillDowns[dim].scorer(context);
                    if (scorer == null) {
                        ++nullCount;
                        scorer = new ConstantScoreScorer(drillDowns[dim], 0.0f, DocIdSetIterator.empty());
                    }
                    dims[dim] = new DrillSidewaysScorer.DocsAndCost(scorer, DrillSidewaysQuery.this.drillSidewaysCollectors[dim]);
                }
                if (nullCount > 1) {
                    return null;
                }
                Arrays.sort(dims, new Comparator<DrillSidewaysScorer.DocsAndCost>(){

                    @Override
                    public int compare(DrillSidewaysScorer.DocsAndCost o1, DrillSidewaysScorer.DocsAndCost o2) {
                        return Long.compare(o1.approximation.cost(), o2.approximation.cost());
                    }
                });
                if (baseScorer == null) {
                    return null;
                }
                return new DrillSidewaysScorer(context, baseScorer, DrillSidewaysQuery.this.drillDownCollector, dims, DrillSidewaysQuery.this.scoreSubDocsAtOnce);
            }
        };
    }

    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + Objects.hashCode(this.baseQuery);
        result = 31 * result + Objects.hashCode(this.drillDownCollector);
        result = 31 * result + Arrays.hashCode(this.drillDownQueries);
        result = 31 * result + Arrays.hashCode(this.drillSidewaysCollectors);
        return result;
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((DrillSidewaysQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(DrillSidewaysQuery other) {
        return Objects.equals(this.baseQuery, other.baseQuery) && Objects.equals(this.drillDownCollector, other.drillDownCollector) && Arrays.equals(this.drillDownQueries, other.drillDownQueries) && Arrays.equals(this.drillSidewaysCollectors, other.drillSidewaysCollectors);
    }
}

