/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.log.AbstractIndex;
import kafka.log.CorruptIndexException;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001\u0002\u0011\"\u0001\u0019B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\n\u0001\u0002\u0011\t\u0011)A\u0005W\u0005C\u0011B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011$\t\u0013\u001d\u0003!\u0011!Q\u0001\n![\u0005\"\u0002'\u0001\t\u0003i\u0005bB*\u0001\u0001\u0004%I\u0001\u0016\u0005\b1\u0002\u0001\r\u0011\"\u0003Z\u0011\u0019y\u0006\u0001)Q\u0005+\")A\r\u0001C!K\")a\r\u0001C!O\")\u0001\u000e\u0001C\u0005S\")A\u000f\u0001C\u0005k\")\u0001\u0010\u0001C\u0001)\")\u0011\u0010\u0001C\u0005)\")!\u0010\u0001C\u0001w\")Q\u0010\u0001C!}\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0001\"CA\f\u0001E\u0005I\u0011AA\r\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAq!a\u000e\u0001\t\u0003\nI\u0004C\u0004\u0002<\u0001!\t%!\u0010\t\u000f\u0005\u0005\u0003\u0001\"\u0011\u0002D!9\u0011\u0011\n\u0001\u0005\n\u0005-\u0003bBA)\u0001\u0011\u0005\u0013\u0011\b\u0005\u000e\u0003'\u0002\u0001\u0013aA\u0001\u0002\u0013%\u0011QK!\t\u001d\u0005]\u0003\u0001%A\u0002\u0002\u0003%I!!\u0017\u0002^\u001dI\u0011qL\u0011\u0002\u0002#\u0005\u0011\u0011\r\u0004\tA\u0005\n\t\u0011#\u0001\u0002d!1A\n\bC\u0001\u0003WB\u0011\"!\u001c\u001d#\u0003%\t!a\u001c\t\u0013\u0005MD$%A\u0005\u0002\u0005e!!\u0003+j[\u0016Le\u000eZ3y\u0015\t\u00113%A\u0002m_\u001eT\u0011\u0001J\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001q%\r\t\u0005Q%Z3&D\u0001\"\u0013\tQ\u0013EA\u0007BEN$(/Y2u\u0013:$W\r\u001f\t\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'\f\u0002\u0005\u0019>tw\r\u0005\u00023k5\t1G\u0003\u00025G\u0005)Q\u000f^5mg&\u0011ag\r\u0002\b\u0019><w-\u001b8h\u0003\u0015yf-\u001b7f!\tId(D\u0001;\u0015\tYD(\u0001\u0002j_*\tQ(\u0001\u0003kCZ\f\u0017BA ;\u0005\u00111\u0015\u000e\\3\u0002\u0015\t\f7/Z(gMN,G/\u0003\u0002AS\u0005aQ.\u0019=J]\u0012,\u0007pU5{KB\u0011A\u0006R\u0005\u0003\u000b6\u00121!\u00138u\u0013\t\u0011\u0015&\u0001\u0005xe&$\u0018M\u00197f!\ta\u0013*\u0003\u0002K[\t9!i\\8mK\u0006t\u0017BA$*\u0003\u0019a\u0014N\\5u}Q)aj\u0014)R%B\u0011\u0001\u0006\u0001\u0005\u0006o\u0015\u0001\r\u0001\u000f\u0005\u0006\u0001\u0016\u0001\ra\u000b\u0005\b\u0005\u0016\u0001\n\u00111\u0001D\u0011\u001d9U\u0001%AA\u0002!\u000b!b\u00187bgR,e\u000e\u001e:z+\u0005)\u0006C\u0001\u0015W\u0013\t9\u0016EA\bUS6,7\u000f^1na>3gm]3u\u00039yF.Y:u\u000b:$(/_0%KF$\"AW/\u0011\u00051Z\u0016B\u0001/.\u0005\u0011)f.\u001b;\t\u000fy;\u0011\u0011!a\u0001+\u0006\u0019\u0001\u0010J\u0019\u0002\u0017}c\u0017m\u001d;F]R\u0014\u0018\u0010\t\u0015\u0003\u0011\u0005\u0004\"\u0001\f2\n\u0005\rl#\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0013\u0015tGO]=TSj,W#A\"\u0002\r%\u001ch)\u001e7m+\u0005A\u0015!\u0003;j[\u0016\u001cH/Y7q)\rY#N\u001d\u0005\u0006W.\u0001\r\u0001\\\u0001\u0007EV4g-\u001a:\u0011\u00055\u0004X\"\u00018\u000b\u0005=d\u0014a\u00018j_&\u0011\u0011O\u001c\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\"B:\f\u0001\u0004\u0019\u0015!\u00018\u0002\u001dI,G.\u0019;jm\u0016|eMZ:fiR\u00191I^<\t\u000b-d\u0001\u0019\u00017\t\u000bMd\u0001\u0019A\"\u0002\u00131\f7\u000f^#oiJL\u0018A\u00067bgR,e\u000e\u001e:z\rJ|W.\u00138eKb4\u0015\u000e\\3\u0002\u000b\u0015tGO]=\u0015\u0005Uc\b\"B:\u0010\u0001\u0004\u0019\u0015A\u00039beN,WI\u001c;ssR)q0!\u0002\u0002\bA\u0019\u0001&!\u0001\n\u0007\u0005\r\u0011E\u0001\u0006J]\u0012,\u00070\u00128uefDQa\u001b\tA\u00021DQa\u001d\tA\u0002\r\u000b1\"\\1zE\u0016\f\u0005\u000f]3oIR9!,!\u0004\u0002\u0010\u0005M\u0001\"\u00025\u0012\u0001\u0004Y\u0003BBA\t#\u0001\u00071&\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\t\u0003+\t\u0002\u0013!a\u0001\u0011\u0006i1o[5q\rVdGn\u00115fG.\fQ#\\1zE\u0016\f\u0005\u000f]3oI\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u001c)\u001a\u0001*!\b,\u0005\u0005}\u0001\u0003BA\u0011\u0003Wi!!a\t\u000b\t\u0005\u0015\u0012qE\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u000b.\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003[\t\u0019CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fa\u0001\\8pWV\u0004HcA+\u00024!1\u0011QG\nA\u0002-\nq\u0002^1sO\u0016$H+[7fgR\fW\u000e]\u0001\tiJ,hnY1uKR\t!,\u0001\u0006ueVt7-\u0019;f)>$2AWA \u0011\u0019\t\t\"\u0006a\u0001W\u00051!/Z:ju\u0016$2\u0001SA#\u0011\u0019\t9E\u0006a\u0001\u0007\u00069a.Z<TSj,\u0017!\u0005;sk:\u001c\u0017\r^3U_\u0016sGO]5fgR\u0019!,!\u0014\t\r\u0005=s\u00031\u0001D\u0003\u001d)g\u000e\u001e:jKN\f1b]1oSRL8\t[3dW\u0006\u00012/\u001e9fe\u0012\u0012\u0017m]3PM\u001a\u001cX\r^\u000b\u0002W\u0005a1/\u001e9fe\u0012\u0012Xm]5{KR\u0019\u0001*a\u0017\t\r\u0005\u001d#\u00041\u0001D\u0013\r\t\t%K\u0001\n)&lW-\u00138eKb\u0004\"\u0001\u000b\u000f\u0014\u0007q\t)\u0007E\u0002-\u0003OJ1!!\u001b.\u0005\u0019\te.\u001f*fMR\u0011\u0011\u0011M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005E$fA\"\u0002\u001e\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ\u0002")
public class TimeIndex
extends AbstractIndex<Object, Object> {
    private volatile TimestampOffset _lastEntry = this.lastEntryFromIndexFile();

    public static boolean $lessinit$greater$default$4() {
        return TimeIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return TimeIndex$.MODULE$.$lessinit$greater$default$3();
    }

    private /* synthetic */ long super$baseOffset() {
        return super.baseOffset();
    }

    private /* synthetic */ boolean super$resize(int newSize) {
        return super.resize(newSize);
    }

    private TimestampOffset _lastEntry() {
        return this._lastEntry;
    }

    private void _lastEntry_$eq(TimestampOffset x$1) {
        this._lastEntry = x$1;
    }

    @Override
    public int entrySize() {
        return 12;
    }

    @Override
    public boolean isFull() {
        return this.entries() >= this.maxEntries() - 1;
    }

    private long timestamp(ByteBuffer buffer, int n) {
        return buffer.getLong(n * this.entrySize());
    }

    private int relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize() + 8);
    }

    public TimestampOffset lastEntry() {
        return this._lastEntry();
    }

    private TimestampOffset lastEntryFromIndexFile() {
        return (TimestampOffset)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            TimestampOffset timestampOffset;
            int n = this._entries();
            switch (n) {
                case 0: {
                    timestampOffset = new TimestampOffset(-1L, this.super$baseOffset());
                    break;
                }
                default: {
                    timestampOffset = (TimestampOffset)this.parseEntry(this.mmap(), n - 1);
                    break;
                }
            }
            return timestampOffset;
        });
    }

    public TimestampOffset entry(int n) {
        return (TimestampOffset)this.maybeLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            if (n >= this._entries()) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Attempt to fetch the %dth entry from a time index of size %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)this._entries())})));
            }
            ByteBuffer idx = this.mmap().duplicate();
            return new TimestampOffset(this.timestamp(idx, n), this.relativeOffset(idx, n));
        });
    }

    @Override
    public IndexEntry parseEntry(ByteBuffer buffer, int n) {
        return new TimestampOffset(this.timestamp(buffer, n), super.baseOffset() + (long)this.relativeOffset(buffer, n));
    }

    public void maybeAppend(long timestamp, long offset, boolean skipFullCheck) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block3: {
                if (!skipFullCheck) {
                    Predef$.MODULE$.require(!this.isFull(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Attempt to append to a full time index (size = ").append(this._entries()).append(").").toString());
                }
                if (this._entries() != 0 && offset < this.lastEntry().offset()) {
                    throw new InvalidOffsetException(new StringOps(Predef$.MODULE$.augmentString("Attempt to append an offset (%d) to slot %d no larger than the last offset appended (%d) to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset), BoxesRunTime.boxToInteger((int)this._entries()), BoxesRunTime.boxToLong((long)this.lastEntry().offset()), this.file().getAbsolutePath()})));
                }
                if (this._entries() != 0 && timestamp < this.lastEntry().timestamp()) {
                    throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Attempt to append a timestamp (%d) to slot %d no larger than the last timestamp appended (%d) to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)timestamp), BoxesRunTime.boxToInteger((int)this._entries()), BoxesRunTime.boxToLong((long)this.lastEntry().timestamp()), this.file().getAbsolutePath()})));
                }
                if (timestamp <= this.lastEntry().timestamp()) break block3;
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Adding index entry %d => %d to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)timestamp), BoxesRunTime.boxToLong((long)offset), this.file().getName()})));
                this.mmap().putLong(timestamp);
                this.mmap().putInt(this.relativeOffset(offset));
                this._entries_$eq(this._entries() + 1);
                this._lastEntry_$eq(new TimestampOffset(timestamp, offset));
                Predef$.MODULE$.require(this._entries() * this.entrySize() == this.mmap().position(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append(this._entries()).append(" entries but file position in index is ").append(this.mmap().position()).append(".").toString());
            }
        });
    }

    public boolean maybeAppend$default$3() {
        return false;
    }

    public TimestampOffset lookup(long targetTimestamp) {
        return (TimestampOffset)this.maybeLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            TimestampOffset timestampOffset;
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, targetTimestamp, IndexSearchType$.MODULE$.KEY());
            if (slot == -1) {
                timestampOffset = new TimestampOffset(-1L, this.super$baseOffset());
            } else {
                TimestampOffset entry = (TimestampOffset)this.parseEntry(idx, slot);
                timestampOffset = new TimestampOffset(entry.timestamp(), entry.offset());
            }
            return timestampOffset;
        });
    }

    @Override
    public void truncate() {
        this.truncateToEntries(0);
    }

    @Override
    public void truncateTo(long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, offset, IndexSearchType$.MODULE$.VALUE());
            int newEntries = slot < 0 ? 0 : ((long)this.relativeOffset(idx, slot) == offset - this.super$baseOffset() ? slot : slot + 1);
            this.truncateToEntries(newEntries);
        });
    }

    @Override
    public boolean resize(int newSize) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            if (this.super$resize(newSize)) {
                this._lastEntry_$eq(this.lastEntryFromIndexFile());
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }));
    }

    private void truncateToEntries(int entries) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this._entries_$eq(entries);
            this.mmap().position(this._entries() * this.entrySize());
            this._lastEntry_$eq(this.lastEntryFromIndexFile());
        });
    }

    @Override
    public void sanityCheck() {
        long lastTimestamp = this.lastEntry().timestamp();
        long lastOffset = this.lastEntry().offset();
        if (this._entries() != 0 && lastTimestamp < this.timestamp(this.mmap(), 0)) {
            throw new CorruptIndexException(new StringBuilder(49).append("Corrupt time index found, time index file (").append(this.file().getAbsolutePath()).append(") has ").append(new StringBuilder(80).append("non-zero size but the last timestamp is ").append(lastTimestamp).append(" which is less than the first timestamp ").toString()).append(String.valueOf(BoxesRunTime.boxToLong((long)this.timestamp(this.mmap(), 0)))).toString());
        }
        if (this._entries() != 0 && lastOffset < super.baseOffset()) {
            throw new CorruptIndexException(new StringBuilder(49).append("Corrupt time index found, time index file (").append(this.file().getAbsolutePath()).append(") has ").append(new StringBuilder(74).append("non-zero size but the last offset is ").append(lastOffset).append(" which is less than the first offset ").append(super.baseOffset()).toString()).toString());
        }
        if (this.length() % (long)this.entrySize() != 0L) {
            throw new CorruptIndexException(new StringBuilder(42).append("Time index file ").append(this.file().getAbsolutePath()).append(" is corrupt, found ").append(this.length()).append(" bytes ").append(new StringBuilder(45).append("which is neither positive nor a multiple of ").append(this.entrySize()).append(".").toString()).toString());
        }
    }

    public TimeIndex(File _file, long baseOffset, int maxIndexSize, boolean writable) {
        super(_file, baseOffset, maxIndexSize, writable);
    }
}

