/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.common.StateChangeFailedException;
import kafka.controller.ControlledShutdownPartitionLeaderElectionStrategy$;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderElectionStrategy$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderElectionAlgorithms$;
import kafka.controller.PartitionLeaderElectionStrategy;
import kafka.controller.PartitionState;
import kafka.controller.PreferredReplicaPartitionLeaderElectionStrategy$;
import kafka.controller.ReassignPartitionLeaderElectionStrategy$;
import kafka.controller.ReassignedPartitionsContext;
import kafka.controller.StateChangeLogger;
import kafka.controller.TopicDeletionManager;
import kafka.log.LogConfig;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.GetDataResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t%e\u0001\u0002\u0015*\u00019B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"Aq\t\u0001B\u0001B\u0003%\u0001\n\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011!\u0011\u0006A!A!\u0002\u0013\u0019\u0006\u0002C5\u0001\u0005\u0003\u0005\u000b\u0011\u00026\t\u000b5\u0004A\u0011\u00018\t\u000fY\u0004!\u0019!C\u0005o\"11\u0010\u0001Q\u0001\naD\u0011\u0002 \u0001A\u0002\u0003\u0007I\u0011B?\t\u0017\u0005\r\u0001\u00011AA\u0002\u0013%\u0011Q\u0001\u0005\u000b\u0003#\u0001\u0001\u0019!A!B\u0013q\b\u0002CA\n\u0001\u0001\u0007I\u0011A<\t\u0013\u0005U\u0001\u00011A\u0005\u0002\u0005]\u0001bBA\u000e\u0001\u0001\u0006K\u0001\u001f\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\t\t\u0003\u0001C\u0001\u0003?Aq!a\t\u0001\t\u0003\t)\u0003C\u0004\u0002*\u0001!I!a\b\t\u000f\u0005-\u0002\u0001\"\u0001\u0002 !9\u00111\u0006\u0001\u0005\u0002\u00055\u0002bBA\u0016\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003#\u0002A\u0011AA*\u0011%\t9\tAI\u0001\n\u0003\tI\tC\u0004\u0002 \u0002!\t!!)\t\u000f\u00055\u0006\u0001\"\u0003\u00020\"9\u00111\u0018\u0001\u0005\n\u0005u\u0006bBAc\u0001\u0011%\u0011q\u0019\u0005\b\u0003\u001f\u0004A\u0011BAi\u0011\u001d\t)\u000e\u0001C\u0005\u0003/Dq!!:\u0001\t\u0013\t9\u000fC\u0004\u0002|\u0002!I!!@\t\u000f\t\u0005\u0002\u0001\"\u0003\u0003$!9!q\u0005\u0001\u0005\n\t%\u0002b\u0002B\u0017\u0001\u0011%!q\u0006\u0005\b\u0005s\u0001A\u0011\u0002B\u001e\u0011\u001d\u00119\u0005\u0001C\u0005\u0005\u0013BqAa\u0014\u0001\t\u0013\u0011\t\u0006C\u0004\u0003P\u0001!IA! \u0003+A\u000b'\u000f^5uS>t7\u000b^1uK6\u000b7\r[5oK*\u0011!fK\u0001\u000bG>tGO]8mY\u0016\u0014(\"\u0001\u0017\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001aL\u001b\u0011\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\r\u0005s\u0017PU3g!\t1\u0014(D\u00018\u0015\tA4&A\u0003vi&d7/\u0003\u0002;o\t9Aj\\4hS:<\u0017AB2p]\u001aLw\r\u0005\u0002>\u00016\taH\u0003\u0002@W\u000511/\u001a:wKJL!!\u0011 \u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0012gR\fG/Z\"iC:<W\rT8hO\u0016\u0014\bC\u0001#F\u001b\u0005I\u0013B\u0001$*\u0005E\u0019F/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$\bC\u0001#J\u0013\tQ\u0015FA\tD_:$(o\u001c7mKJ\u001cuN\u001c;fqR\f\u0001B_6DY&,g\u000e\u001e\t\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001f.\n!A_6\n\u0005Es%!D&bM.\f'l[\"mS\u0016tG/\u0001\bqCJ$\u0018\u000e^5p]N#\u0018\r^3\u0011\tQK6LZ\u0007\u0002+*\u0011akV\u0001\b[V$\u0018M\u00197f\u0015\tA\u0016'\u0001\u0006d_2dWm\u0019;j_:L!AW+\u0003\u00075\u000b\u0007\u000f\u0005\u0002]I6\tQL\u0003\u0002_?\u000611m\\7n_:T!\u0001\f1\u000b\u0005\u0005\u0014\u0017AB1qC\u000eDWMC\u0001d\u0003\ry'oZ\u0005\u0003Kv\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002EO&\u0011\u0001.\u000b\u0002\u000f!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0003q\u0019wN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\"\u0004\"\u0001R6\n\u00051L#\u0001H\"p]R\u0014x\u000e\u001c7fe\n\u0013xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r[\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f=\u0004\u0018O]:ukB\u0011A\t\u0001\u0005\u0006w\u001d\u0001\r\u0001\u0010\u0005\u0006\u0005\u001e\u0001\ra\u0011\u0005\u0006\u000f\u001e\u0001\r\u0001\u0013\u0005\u0006\u0017\u001e\u0001\r\u0001\u0014\u0005\u0006%\u001e\u0001\ra\u0015\u0005\u0006S\u001e\u0001\rA[\u0001\rG>tGO]8mY\u0016\u0014\u0018\nZ\u000b\u0002qB\u0011\u0001'_\u0005\u0003uF\u00121!\u00138u\u00035\u0019wN\u001c;s_2dWM]%eA\u0005!Bo\u001c9jG\u0012+G.\u001a;j_:l\u0015M\\1hKJ,\u0012A \t\u0003\t~L1!!\u0001*\u0005Q!v\u000e]5d\t\u0016dW\r^5p]6\u000bg.Y4fe\u0006ABo\u001c9jG\u0012+G.\u001a;j_:l\u0015M\\1hKJ|F%Z9\u0015\t\u0005\u001d\u0011Q\u0002\t\u0004a\u0005%\u0011bAA\u0006c\t!QK\\5u\u0011!\tyaCA\u0001\u0002\u0004q\u0018a\u0001=%c\u0005)Bo\u001c9jG\u0012+G.\u001a;j_:l\u0015M\\1hKJ\u0004\u0013!F8gM2Lg.\u001a)beRLG/[8o\u0007>,h\u000e^\u0001\u001a_\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0003\u0002\b\u0005e\u0001\u0002CA\b\u001d\u0005\u0005\t\u0019\u0001=\u0002-=4g\r\\5oKB\u000b'\u000f^5uS>t7i\\;oi\u0002\nqa\u001d;beR,\b\u000f\u0006\u0002\u0002\b\u0005A1\u000f[;uI><h.A\ftKR$v\u000e]5d\t\u0016dW\r^5p]6\u000bg.Y4feR!\u0011qAA\u0014\u0011\u0015a(\u00031\u0001\u007f\u0003aIg.\u001b;jC2L'0\u001a)beRLG/[8o'R\fG/Z\u0001\"iJLwmZ3s\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]N#\u0018\r^3DQ\u0006tw-\u001a\u000b\u0005\u0003\u000f\ty\u0003C\u0004\u00022U\u0001\r!a\r\u0002\u000bQ|\u0007/[2\u0011\t\u0005U\u00121\t\b\u0005\u0003o\ty\u0004E\u0002\u0002:Ej!!a\u000f\u000b\u0007\u0005uR&\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0003\n\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002F\u0005\u001d#AB*ue&twMC\u0002\u0002BE\"B!a\u0002\u0002L!1!K\u0006a\u0001\u0003\u001b\u0002b!!\u000e\u0002Pm3\u0017b\u0001.\u0002H\u0005\u0011\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3t)!\t)&!\u001b\u0002t\u0005]\u0004cBA\u001b\u0003\u001fZ\u0016q\u000b\t\u0005\u00033\n\u0019G\u0004\u0003\u0002\\\u0005}c\u0002BA\u001d\u0003;J\u0011AM\u0005\u0004\u0003C\n\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003K\n9GA\u0005UQJ|w/\u00192mK*\u0019\u0011\u0011M\u0019\t\u000f\u0005-t\u00031\u0001\u0002n\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\u000b\u0005e\u0013qN.\n\t\u0005E\u0014q\r\u0002\u0004'\u0016\f\bBBA;/\u0001\u0007a-A\u0006uCJ<W\r^*uCR,\u0007\"CA=/A\u0005\t\u0019AA>\u0003\t\u0002\u0018M\u001d;ji&|g\u000eT3bI\u0016\u0014X\t\\3di&|gn\u0015;sCR,w-_(qiB)\u0001'! \u0002\u0002&\u0019\u0011qP\u0019\u0003\r=\u0003H/[8o!\r!\u00151Q\u0005\u0004\u0003\u000bK#a\b)beRLG/[8o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o'R\u0014\u0018\r^3hs\u0006a\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3tI\u0011,g-Y;mi\u0012\u001aTCAAFU\u0011\tY(!$,\u0005\u0005=\u0005\u0003BAI\u00037k!!a%\u000b\t\u0005U\u0015qS\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!'2\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003;\u000b\u0019JA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0011\u0003]1si&$\u0018n\u001c8t\u0013:\u001cF/\u0019;f)\u0011\t\u0019+!+\u0011\u000b\u0005U\u0012QU.\n\t\u0005\u001d\u0016q\t\u0002\u0004'\u0016$\bBBAV3\u0001\u0007a-A\u0003ti\u0006$X-A\u0007dQ\u0006tw-Z*uCR,Gk\u001c\u000b\t\u0003\u000f\t\t,!.\u0002:\"1\u00111\u0017\u000eA\u0002m\u000b\u0011\u0002]1si&$\u0018n\u001c8\t\r\u0005]&\u00041\u0001g\u00031\u0019WO\u001d:f]R\u001cF/\u0019;f\u0011\u0019\t)H\u0007a\u0001M\u00069R\u000f\u001d3bi\u0016\u001cuN\u001c;s_2dWM]'fiJL7m\u001d\u000b\t\u0003\u000f\ty,!1\u0002D\"1\u00111W\u000eA\u0002mCa!a.\u001c\u0001\u00041\u0007BBA;7\u0001\u0007a-\u0001\u000be_\"\u000bg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u000b\t\u0003+\nI-a3\u0002N\"9\u00111\u000e\u000fA\u0002\u00055\u0004BBA;9\u0001\u0007a\rC\u0004\u0002zq\u0001\r!a\u001f\u0002G%t\u0017\u000e^5bY&TX\rT3bI\u0016\u0014\u0018I\u001c3JgJ4uN\u001d)beRLG/[8ogR!\u0011QNAj\u0011\u001d\tY'\ba\u0001\u0003[\n\u0001$\u001a7fGRdU-\u00193fe\u001a{'\u000fU1si&$\u0018n\u001c8t)\u0019\tI.a8\u0002bB9\u0001'a7\u0002n\u0005U\u0013bAAoc\t1A+\u001e9mKJBq!a\u001b\u001f\u0001\u0004\ti\u0007C\u0004\u0002dz\u0001\r!!!\u0002?A\f'\u000f^5uS>tG*Z1eKJ,E.Z2uS>t7\u000b\u001e:bi\u0016<\u00170\u0001\u000ee_\u0016cWm\u0019;MK\u0006$WM\u001d$peB\u000b'\u000f^5uS>t7\u000f\u0006\u0004\u0002j\u0006]\u0018\u0011 \t\na\u0005-\u0018QNA7\u0003_L1!!<2\u0005\u0019!V\u000f\u001d7fgA9\u0011QGA(7\u0006E\b\u0003BA-\u0003gLA!!>\u0002h\tIQ\t_2faRLwN\u001c\u0005\b\u0003Wz\u0002\u0019AA7\u0011\u001d\t\u0019o\ba\u0001\u0003\u0003\u000b\u0001\u0003\\3bI\u0016\u0014hi\u001c:PM\u001ad\u0017N\\3\u0015\t\u0005}(1\u0003\t\u0007\u00033\nyG!\u0001\u0011\u0011A\nYo\u0017B\u0002\u0005#\u0001R\u0001MA?\u0005\u000b\u0001BAa\u0002\u0003\u000e5\u0011!\u0011\u0002\u0006\u0004\u0005\u0017Y\u0013aA1qS&!!q\u0002B\u0005\u00051aU-\u00193fe\u0006sG-S:s!\u0015\tI&a\u001cy\u0011\u001d\u0011)\u0002\ta\u0001\u0005/\tA\u0004\\3bI\u0016\u0014\u0018j\u001d:B]\u0012\u001cuN\u001c;s_2dWM]#q_\u000eD7\u000f\u0005\u0004\u0002Z\u0005=$\u0011\u0004\t\u0007a\u0005m7La\u0007\u0011\u0007\u0011\u0013i\"C\u0002\u0003 %\u00121\u0004T3bI\u0016\u0014\u0018j\u001d:B]\u0012\u001cuN\u001c;s_2dWM]#q_\u000eD\u0017!\u00057fC\u0012,'OR8s%\u0016\f7o]5h]R!\u0011q B\u0013\u0011\u001d\u0011)\"\ta\u0001\u0005/\t\u0011\u0004\\3bI\u0016\u0014hi\u001c:Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dCR!\u0011q B\u0016\u0011\u001d\u0011)B\ta\u0001\u0005/\t1\u0004\\3bI\u0016\u0014hi\u001c:D_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^tGCBA\u0000\u0005c\u0011\u0019\u0004C\u0004\u0003\u0016\r\u0002\rAa\u0006\t\u000f\tU2\u00051\u0001\u00038\u0005\u00192\u000f[;ui&tw\rR8x]\n\u0013xn[3sgB)\u0011QGASq\u0006\t\u0012n\u001d,bY&$GK]1og&$\u0018n\u001c8\u0015\r\tu\"1\tB#!\r\u0001$qH\u0005\u0004\u0005\u0003\n$a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003g#\u0003\u0019A.\t\r\u0005UD\u00051\u0001g\u0003QawnZ%om\u0006d\u0017\u000e\u001a+sC:\u001c\u0018\u000e^5p]R1\u0011q\u0001B&\u0005\u001bBa!a-&\u0001\u0004Y\u0006BBA;K\u0001\u0007a-\u0001\u000bm_\u001e4\u0015-\u001b7fIN#\u0018\r^3DQ\u0006tw-\u001a\u000b\u000b\u0003\u000f\u0011\u0019F!\u0016\u0003Z\tm\u0003BBAZM\u0001\u00071\f\u0003\u0004\u0003X\u0019\u0002\rAZ\u0001\nGV\u0014(o\u0015;bi\u0016Da!!\u001e'\u0001\u00041\u0007b\u0002B/M\u0001\u0007!qL\u0001\u0005G>$W\r\u0005\u0003\u0003b\t]d\u0002\u0002B2\u0005crAA!\u001a\u0003n9!!q\rB6\u001d\u0011\tID!\u001b\n\u0003\rL!!\u00192\n\u0007\t=\u0004-A\u0005{_>\\W-\u001a9fe&!!1\u000fB;\u0003=YU-\u001a9fe\u0016C8-\u001a9uS>t'b\u0001B8A&!!\u0011\u0010B>\u0005\u0011\u0019u\u000eZ3\u000b\t\tM$Q\u000f\u000b\u000b\u0003\u000f\u0011yH!!\u0003\u0004\n\u0015\u0005BBAZO\u0001\u00071\f\u0003\u0004\u0003X\u001d\u0002\rA\u001a\u0005\u0007\u0003k:\u0003\u0019\u00014\t\u000f\t\u001du\u00051\u0001\u0002X\u0005\tA\u000f")
public class PartitionStateMachine
implements Logging {
    private final KafkaConfig config;
    private final StateChangeLogger stateChangeLogger;
    private final ControllerContext controllerContext;
    private final KafkaZkClient zkClient;
    private final Map<TopicPartition, PartitionState> partitionState;
    private final ControllerBrokerRequestBatch controllerBrokerRequestBatch;
    private final int controllerId;
    private TopicDeletionManager topicDeletionManager;
    private int offlinePartitionCount;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        PartitionStateMachine partitionStateMachine = this;
        synchronized (partitionStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int controllerId() {
        return this.controllerId;
    }

    private TopicDeletionManager topicDeletionManager() {
        return this.topicDeletionManager;
    }

    private void topicDeletionManager_$eq(TopicDeletionManager x$1) {
        this.topicDeletionManager = x$1;
    }

    public int offlinePartitionCount() {
        return this.offlinePartitionCount;
    }

    public void offlinePartitionCount_$eq(int x$1) {
        this.offlinePartitionCount = x$1;
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Initializing partition state");
        this.initializePartitionState();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Triggering online partition state changes");
        this.triggerOnlinePartitionStateChange();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Started partition state machine with initial state -> ").append($this.partitionState).toString());
    }

    public void shutdown() {
        this.partitionState.clear();
        this.offlinePartitionCount_$eq(0);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped partition state machine");
    }

    public void setTopicDeletionManager(TopicDeletionManager topicDeletionManager) {
        this.topicDeletionManager_$eq(topicDeletionManager);
    }

    private void initializePartitionState() {
        this.controllerContext.allPartitions().foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
            PartitionStateMachine.$anonfun$initializePartitionState$1(this, topicPartition);
            return BoxedUnit.UNIT;
        });
    }

    public void triggerOnlinePartitionStateChange() {
        this.triggerOnlinePartitionStateChange((scala.collection.immutable.Map<TopicPartition, PartitionState>)this.partitionState.toMap(Predef$.MODULE$.$conforms()));
    }

    public void triggerOnlinePartitionStateChange(String topic) {
        this.triggerOnlinePartitionStateChange((scala.collection.immutable.Map<TopicPartition, PartitionState>)this.partitionState.filterKeys((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$triggerOnlinePartitionStateChange$1(topic, p))).toMap(Predef$.MODULE$.$conforms()));
    }

    public void triggerOnlinePartitionStateChange(scala.collection.immutable.Map<TopicPartition, PartitionState> partitionState) {
        Seq partitionsToTrigger = ((MapLike)partitionState.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$triggerOnlinePartitionStateChange$2(this, x0$1)))).keys().toSeq();
        this.handleStateChanges((Seq<TopicPartition>)partitionsToTrigger, OnlinePartition$.MODULE$, (Option<PartitionLeaderElectionStrategy>)Option$.MODULE$.apply((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
    }

    public scala.collection.immutable.Map<TopicPartition, Throwable> handleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState, Option<PartitionLeaderElectionStrategy> partitionLeaderElectionStrategyOpt) {
        scala.collection.immutable.Map map;
        if (partitions.nonEmpty()) {
            try {
                this.controllerBrokerRequestBatch.newBatch();
                scala.collection.immutable.Map errors = this.doHandleStateChanges(partitions, targetState, partitionLeaderElectionStrategyOpt);
                this.controllerBrokerRequestBatch.sendRequestsToBrokers(this.controllerContext.epoch());
                map = errors;
            }
            catch (ControllerMovedException e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Controller moved to another broker when moving some partitions to ").append(targetState).append(" state").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                throw e;
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Error while moving some partitions to ").append(targetState).append(" state").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                map = ((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$1), (Object)e), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    public Option<PartitionLeaderElectionStrategy> handleStateChanges$default$3() {
        return None$.MODULE$;
    }

    public Set<TopicPartition> partitionsInState(PartitionState state) {
        return ((MapLike)this.partitionState.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$partitionsInState$1(state, x0$1)))).keySet().toSet();
    }

    private void changeStateTo(TopicPartition partition, PartitionState currentState, PartitionState targetState) {
        this.partitionState.put((Object)partition, (Object)targetState);
        this.updateControllerMetrics(partition, currentState, targetState);
    }

    private void updateControllerMetrics(TopicPartition partition, PartitionState currentState, PartitionState targetState) {
        block1: {
            block2: {
                if (this.topicDeletionManager().isTopicWithDeletionStarted(partition.topic())) break block1;
                PartitionState partitionState = currentState;
                OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                if (!(partitionState == null ? offlinePartition$ != null : !partitionState.equals(offlinePartition$))) break block2;
                PartitionState partitionState2 = targetState;
                OfflinePartition$ offlinePartition$2 = OfflinePartition$.MODULE$;
                if (partitionState2 != null ? !partitionState2.equals(offlinePartition$2) : offlinePartition$2 != null) break block2;
                this.offlinePartitionCount_$eq(this.offlinePartitionCount() + 1);
                break block1;
            }
            PartitionState partitionState = currentState;
            OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
            if (partitionState != null ? !partitionState.equals(offlinePartition$) : offlinePartition$ != null) break block1;
            PartitionState partitionState3 = targetState;
            OfflinePartition$ offlinePartition$3 = OfflinePartition$.MODULE$;
            if (partitionState3 == null ? offlinePartition$3 != null : !partitionState3.equals(offlinePartition$3)) {
                this.offlinePartitionCount_$eq(this.offlinePartitionCount() - 1);
            }
        }
    }

    private scala.collection.immutable.Map<TopicPartition, Throwable> doHandleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState, Option<PartitionLeaderElectionStrategy> partitionLeaderElectionStrategyOpt) {
        scala.collection.immutable.Map map;
        StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch());
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> (PartitionState)$this.partitionState.getOrElseUpdate(partition, (Function0 & Serializable & scala.Serializable)() -> NonExistentPartition$.MODULE$));
        Tuple2 tuple2 = partitions.partition((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)this.isValidTransition(partition, targetState)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq validPartitions = (Seq)tuple2._1();
        Seq invalidPartitions = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)validPartitions, (Object)invalidPartitions);
        Tuple2 tuple23 = tuple22;
        Seq validPartitions2 = (Seq)tuple23._1();
        Seq invalidPartitions2 = (Seq)tuple23._2();
        invalidPartitions2.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            this.logInvalidTransition(partition, targetState);
            return BoxedUnit.UNIT;
        });
        PartitionState partitionState = targetState;
        if (NewPartition$.MODULE$.equals(partitionState)) {
            validPartitions2.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                PartitionStateMachine.$anonfun$doHandleStateChanges$5(this, stateChangeLog, targetState, partition);
                return BoxedUnit.UNIT;
            });
            map = Predef$.MODULE$.Map().empty();
        } else if (OnlinePartition$.MODULE$.equals(partitionState)) {
            scala.collection.immutable.Map map2;
            Seq uninitializedPartitions = (Seq)validPartitions2.filter((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$doHandleStateChanges$7(this, partition)));
            Seq partitionsToElectLeader = (Seq)validPartitions2.filter((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$doHandleStateChanges$8(this, partition)));
            if (uninitializedPartitions.nonEmpty()) {
                Seq<TopicPartition> successfulInitializations = this.initializeLeaderAndIsrForPartitions((Seq<TopicPartition>)uninitializedPartitions);
                successfulInitializations.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                    PartitionStateMachine.$anonfun$doHandleStateChanges$9(this, stateChangeLog, targetState, partition);
                    return BoxedUnit.UNIT;
                });
            }
            if (partitionsToElectLeader.nonEmpty()) {
                Tuple2<Seq<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Throwable>> tuple24 = this.electLeaderForPartitions((Seq<TopicPartition>)partitionsToElectLeader, (PartitionLeaderElectionStrategy)partitionLeaderElectionStrategyOpt.get());
                if (tuple24 == null) {
                    throw new MatchError(tuple24);
                }
                Seq successfulElections = (Seq)tuple24._1();
                scala.collection.immutable.Map failedElections = (scala.collection.immutable.Map)tuple24._2();
                Tuple2 tuple25 = new Tuple2((Object)successfulElections, (Object)failedElections);
                Tuple2 tuple26 = tuple25;
                Seq successfulElections2 = (Seq)tuple26._1();
                scala.collection.immutable.Map failedElections2 = (scala.collection.immutable.Map)tuple26._2();
                successfulElections2.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                    PartitionStateMachine.$anonfun$doHandleStateChanges$11(this, stateChangeLog, targetState, partition);
                    return BoxedUnit.UNIT;
                });
                map2 = failedElections2;
            } else {
                map2 = Predef$.MODULE$.Map().empty();
            }
            map = map2;
        } else if (OfflinePartition$.MODULE$.equals(partitionState)) {
            validPartitions2.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                PartitionStateMachine.$anonfun$doHandleStateChanges$13(this, stateChangeLog, targetState, partition);
                return BoxedUnit.UNIT;
            });
            map = Predef$.MODULE$.Map().empty();
        } else if (NonExistentPartition$.MODULE$.equals(partitionState)) {
            validPartitions2.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                PartitionStateMachine.$anonfun$doHandleStateChanges$15(this, stateChangeLog, targetState, partition);
                return BoxedUnit.UNIT;
            });
            map = Predef$.MODULE$.Map().empty();
        } else {
            throw new MatchError((Object)partitionState);
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<TopicPartition> initializeLeaderAndIsrForPartitions(Seq<TopicPartition> partitions) {
        void var3_2;
        Seq seq;
        Buffer successfulInitializations = (Buffer)Buffer$.MODULE$.empty();
        Seq replicasPerPartition = (Seq)partitions.map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), $this.controllerContext.partitionReplicaAssignment((TopicPartition)partition)), Seq$.MODULE$.canBuildFrom());
        Seq liveReplicasPerPartition = (Seq)replicasPerPartition.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            Seq replicas = (Seq)tuple2._2();
            Seq liveReplicasForPartition = (Seq)replicas.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition, $this.controllerContext.isReplicaOnline$default$3()));
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)liveReplicasForPartition);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = liveReplicasPerPartition.partition((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$initializeLeaderAndIsrForPartitions$4(x0$2)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq partitionsWithoutLiveReplicas = (Seq)tuple2._1();
        Seq partitionsWithLiveReplicas = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionsWithoutLiveReplicas, (Object)partitionsWithLiveReplicas);
        Tuple2 tuple23 = tuple22;
        Seq partitionsWithoutLiveReplicas2 = (Seq)tuple23._1();
        Seq partitionsWithLiveReplicas2 = (Seq)tuple23._2();
        partitionsWithoutLiveReplicas2.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            PartitionStateMachine.$anonfun$initializeLeaderAndIsrForPartitions$5(this, x0$3);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map leaderIsrAndControllerEpochs = ((TraversableOnce)partitionsWithLiveReplicas2.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            Seq liveReplicas = (Seq)tuple2._2();
            LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)liveReplicas.head()), (List<Object>)liveReplicas.toList());
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, $this.controllerContext.epoch());
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)leaderIsrAndControllerEpoch);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        try {
            seq = this.zkClient.createTopicPartitionStatesRaw((scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch>)leaderIsrAndControllerEpochs, this.controllerContext.epochZkVersion());
        }
        catch (ControllerMovedException e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Controller moved to another broker when trying to create the topic partition state znode", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            throw e;
        }
        catch (Exception e) {
            partitionsWithLiveReplicas2.foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
                PartitionStateMachine.$anonfun$initializeLeaderAndIsrForPartitions$9(this, e, x0$5);
                return BoxedUnit.UNIT;
            });
            seq = (Seq)Seq$.MODULE$.empty();
        }
        Seq createResponses = seq;
        createResponses.foreach((Function1 & Serializable & scala.Serializable)createResponse -> {
            BoxedUnit boxedUnit;
            KeeperException.Code code = createResponse.resultCode();
            TopicPartition partition = (TopicPartition)createResponse.ctx().get();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochs.apply((Object)partition);
            KeeperException.Code code2 = code;
            KeeperException.Code code3 = KeeperException.Code.OK;
            if (!(code2 != null ? !code2.equals(code3) : code3 != null)) {
                $this.controllerContext.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
                $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)leaderIsrAndControllerEpoch.leaderAndIsr().isr(), partition, leaderIsrAndControllerEpoch, $this.controllerContext.partitionReplicaAssignment(partition), true);
                boxedUnit = successfulInitializations.$plus$eq((Object)partition);
            } else {
                this.logFailedStateChange(partition, (PartitionState)NewPartition$.MODULE$, (PartitionState)OnlinePartition$.MODULE$, code);
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        return var3_2;
    }

    private Tuple2<Seq<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Throwable>> electLeaderForPartitions(Seq<TopicPartition> partitions, PartitionLeaderElectionStrategy partitionLeaderElectionStrategy) {
        Buffer successfulElections = (Buffer)Buffer$.MODULE$.empty();
        Seq remaining = partitions;
        scala.collection.immutable.Map failures = Predef$.MODULE$.Map().empty();
        while (remaining.nonEmpty()) {
            Tuple3<Seq<TopicPartition>, Seq<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Exception>> tuple3 = this.doElectLeaderForPartitions(partitions, partitionLeaderElectionStrategy);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            Seq success = (Seq)tuple3._1();
            Seq updatesToRetry = (Seq)tuple3._2();
            scala.collection.immutable.Map failedElections = (scala.collection.immutable.Map)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)success, (Object)updatesToRetry, (Object)failedElections);
            Tuple3 tuple33 = tuple32;
            Seq success2 = (Seq)tuple33._1();
            Seq updatesToRetry2 = (Seq)tuple33._2();
            scala.collection.immutable.Map failedElections2 = (scala.collection.immutable.Map)tuple33._3();
            remaining = updatesToRetry2;
            successfulElections.$plus$plus$eq((TraversableOnce)success2);
            failedElections2.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                PartitionStateMachine.$anonfun$electLeaderForPartitions$1(this, x0$1);
                return BoxedUnit.UNIT;
            });
            failures = failures.$plus$plus((GenTraversableOnce)failedElections2);
        }
        return new Tuple2((Object)successfulElections, (Object)failures);
    }

    private Tuple3<Seq<TopicPartition>, Seq<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Exception>> doElectLeaderForPartitions(Seq<TopicPartition> partitions, PartitionLeaderElectionStrategy partitionLeaderElectionStrategy) {
        Tuple2 tuple2;
        Seq<GetDataResponse> seq;
        try {
            seq = this.zkClient.getTopicPartitionStatesRaw(partitions);
        }
        catch (Exception e) {
            return new Tuple3((Object)Seq$.MODULE$.empty(), (Object)Seq$.MODULE$.empty(), (Object)((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x$6 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$6), (Object)e), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        }
        Seq<GetDataResponse> getDataResponses = seq;
        Map failedElections = Map$.MODULE$.empty();
        Buffer leaderIsrAndControllerEpochPerPartition = (Buffer)Buffer$.MODULE$.empty();
        getDataResponses.foreach((Function1 & Serializable & scala.Serializable)getDataResponse -> {
            Option option;
            TopicPartition partition = (TopicPartition)getDataResponse.ctx().get();
            PartitionState currState = (PartitionState)$this.partitionState.apply((Object)partition);
            KeeperException.Code code = getDataResponse.resultCode();
            KeeperException.Code code2 = KeeperException.Code.OK;
            if (!(code != null ? !code.equals(code2) : code2 != null)) {
                BoxedUnit boxedUnit;
                Option<LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochOpt = TopicPartitionStateZNode$.MODULE$.decode(getDataResponse.data(), getDataResponse.stat());
                if (leaderIsrAndControllerEpochOpt.isEmpty()) {
                    StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(63).append("LeaderAndIsr information doesn't exist for partition ").append(partition).append(" in ").append(currState).append(" state").toString());
                    boxedUnit = failedElections.put((Object)partition, (Object)exception);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option = leaderIsrAndControllerEpochPerPartition.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), leaderIsrAndControllerEpochOpt.get()));
            } else {
                KeeperException.Code code3 = getDataResponse.resultCode();
                KeeperException.Code code4 = KeeperException.Code.NONODE;
                if (!(code3 != null ? !code3.equals(code4) : code4 != null)) {
                    StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(63).append("LeaderAndIsr information doesn't exist for partition ").append(partition).append(" in ").append(currState).append(" state").toString());
                    option = failedElections.put((Object)partition, (Object)exception);
                } else {
                    option = failedElections.put((Object)partition, getDataResponse.resultException().get());
                }
            }
            return option;
        });
        Tuple2 tuple22 = leaderIsrAndControllerEpochPerPartition.partition((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$doElectLeaderForPartitions$3(this, x0$1)));
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Buffer invalidPartitionsForElection = (Buffer)tuple22._1();
        Buffer validPartitionsForElection = (Buffer)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)invalidPartitionsForElection, (Object)validPartitionsForElection);
        Tuple2 tuple24 = tuple23;
        Buffer invalidPartitionsForElection2 = (Buffer)tuple24._1();
        Buffer validPartitionsForElection2 = (Buffer)tuple24._2();
        invalidPartitionsForElection2.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
            String failMsg = new StringBuilder(71).append("aborted leader election for partition ").append(partition).append(" since the LeaderAndIsr path was ").append(new StringBuilder(101).append("already written by another controller. This probably means that the current controller ").append(this.controllerId()).append(" went through ").toString()).append(new StringBuilder(62).append("a soft failure and another controller was elected with epoch ").append(leaderIsrAndControllerEpoch.controllerEpoch()).append(".").toString()).toString();
            Option option = failedElections.put((Object)partition, (Object)new StateChangeFailedException(failMsg));
            return option;
        });
        if (validPartitionsForElection2.isEmpty()) {
            return new Tuple3((Object)Seq$.MODULE$.empty(), (Object)Seq$.MODULE$.empty(), (Object)failedElections.toMap(Predef$.MODULE$.$conforms()));
        }
        Set shuttingDownBrokers = this.controllerContext.shuttingDownBrokerIds().toSet();
        PartitionLeaderElectionStrategy partitionLeaderElectionStrategy2 = partitionLeaderElectionStrategy;
        if (OfflinePartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) {
            tuple2 = this.leaderForOffline((Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>>)validPartitionsForElection2).partition((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$doElectLeaderForPartitions$5(x0$3)));
        } else if (ReassignPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) {
            tuple2 = this.leaderForReassign((Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>>)validPartitionsForElection2).partition((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$doElectLeaderForPartitions$6(x0$4)));
        } else if (PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) {
            tuple2 = this.leaderForPreferredReplica((Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>>)validPartitionsForElection2).partition((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$doElectLeaderForPartitions$7(x0$5)));
        } else if (ControlledShutdownPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) {
            tuple2 = this.leaderForControlledShutdown((Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>>)validPartitionsForElection2, (Set<Object>)shuttingDownBrokers).partition((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$doElectLeaderForPartitions$8(x0$6)));
        } else {
            throw new MatchError((Object)partitionLeaderElectionStrategy2);
        }
        Tuple2 tuple25 = tuple2;
        if (tuple25 == null) {
            throw new MatchError((Object)tuple25);
        }
        Seq partitionsWithoutLeaders = (Seq)tuple25._1();
        Seq partitionsWithLeaders = (Seq)tuple25._2();
        Tuple2 tuple26 = new Tuple2((Object)partitionsWithoutLeaders, (Object)partitionsWithLeaders);
        Tuple2 tuple27 = tuple26;
        Seq partitionsWithoutLeaders2 = (Seq)tuple27._1();
        Seq partitionsWithLeaders2 = (Seq)tuple27._2();
        partitionsWithoutLeaders2.foreach((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Tuple3 tuple3 = x0$7;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            TopicPartition partition = (TopicPartition)tuple3._1();
            String failMsg = new StringBuilder(53).append("Failed to elect leader for partition ").append(partition).append(" under strategy ").append(partitionLeaderElectionStrategy).toString();
            Option option = failedElections.put((Object)partition, (Object)new StateChangeFailedException(failMsg));
            return option;
        });
        scala.collection.immutable.Map recipientsPerPartition = ((TraversableOnce)partitionsWithLeaders2.map((Function1 & Serializable & scala.Serializable)x0$8 -> {
            Tuple3 tuple3 = x0$8;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            TopicPartition partition = (TopicPartition)tuple3._1();
            Seq recipients = (Seq)tuple3._3();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)recipients);
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map adjustedLeaderAndIsrs = ((TraversableOnce)partitionsWithLeaders2.map((Function1 & Serializable & scala.Serializable)x0$9 -> {
            Tuple3 tuple3 = x0$9;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            TopicPartition partition = (TopicPartition)tuple3._1();
            Option leaderAndIsrOpt = (Option)tuple3._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), leaderAndIsrOpt.get());
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        KafkaZkClient.UpdateLeaderAndIsrResult updateLeaderAndIsrResult = this.zkClient.updateLeaderAndIsr((scala.collection.immutable.Map<TopicPartition, LeaderAndIsr>)adjustedLeaderAndIsrs, this.controllerContext.epoch(), this.controllerContext.epochZkVersion());
        if (updateLeaderAndIsrResult == null) {
            throw new MatchError((Object)updateLeaderAndIsrResult);
        }
        scala.collection.immutable.Map<TopicPartition, LeaderAndIsr> successfulUpdates = updateLeaderAndIsrResult.successfulPartitions();
        Seq<TopicPartition> updatesToRetry = updateLeaderAndIsrResult.partitionsToRetry();
        scala.collection.immutable.Map<TopicPartition, Exception> failedUpdates = updateLeaderAndIsrResult.failedPartitions();
        Tuple3 tuple3 = new Tuple3(successfulUpdates, updatesToRetry, failedUpdates);
        Tuple3 tuple32 = tuple3;
        scala.collection.immutable.Map successfulUpdates2 = (scala.collection.immutable.Map)tuple32._1();
        Seq updatesToRetry2 = (Seq)tuple32._2();
        scala.collection.immutable.Map failedUpdates2 = (scala.collection.immutable.Map)tuple32._3();
        successfulUpdates2.foreach((Function1 & Serializable & scala.Serializable)x0$10 -> {
            PartitionStateMachine.$anonfun$doElectLeaderForPartitions$12(this, recipientsPerPartition, x0$10);
            return BoxedUnit.UNIT;
        });
        return new Tuple3((Object)successfulUpdates2.keys().toSeq(), (Object)updatesToRetry2, (Object)failedElections.toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)failedUpdates2));
    }

    private Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>>> leaderForOffline(Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>> leaderIsrAndControllerEpochs) {
        Tuple2 tuple2 = leaderIsrAndControllerEpochs.partition((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$leaderForOffline$1(this, x0$1)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq partitionsWithNoLiveInSyncReplicas = (Seq)tuple2._1();
        Seq partitionsWithLiveInSyncReplicas = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionsWithNoLiveInSyncReplicas, (Object)partitionsWithLiveInSyncReplicas);
        Tuple2 tuple23 = tuple22;
        Seq partitionsWithNoLiveInSyncReplicas2 = (Seq)tuple23._1();
        Seq partitionsWithLiveInSyncReplicas2 = (Seq)tuple23._2();
        Tuple2<scala.collection.immutable.Map<String, LogConfig>, scala.collection.immutable.Map<String, Exception>> tuple24 = this.zkClient.getLogConfigs((Seq<String>)((Seq)partitionsWithNoLiveInSyncReplicas2.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            String string = partition.topic();
            return string;
        }, Seq$.MODULE$.canBuildFrom())), this.config.originals());
        if (tuple24 == null) {
            throw new MatchError(tuple24);
        }
        scala.collection.immutable.Map logConfigs = (scala.collection.immutable.Map)tuple24._1();
        scala.collection.immutable.Map failed = (scala.collection.immutable.Map)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)logConfigs, (Object)failed);
        Tuple2 tuple26 = tuple25;
        scala.collection.immutable.Map logConfigs2 = (scala.collection.immutable.Map)tuple26._1();
        scala.collection.immutable.Map failed2 = (scala.collection.immutable.Map)tuple26._2();
        Seq partitionsWithUncleanLeaderElectionState = (Seq)((TraversableLike)partitionsWithNoLiveInSyncReplicas2.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple3 tuple3;
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                TopicPartition partition = (TopicPartition)tuple2._1();
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
                if (failed2.contains((Object)partition.topic())) {
                    this.logFailedStateChange(partition, (PartitionState)$this.partitionState.apply((Object)partition), (PartitionState)OnlinePartition$.MODULE$, (Throwable)failed2.apply((Object)partition.topic()));
                    tuple3 = new Tuple3((Object)partition, (Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                } else {
                    tuple3 = new Tuple3((Object)partition, (Object)Option$.MODULE$.apply((Object)leaderIsrAndControllerEpoch), (Object)BoxesRunTime.boxToBoolean((boolean)((LogConfig)((Object)((Object)logConfigs2.apply((Object)partition.topic())))).uncleanLeaderElectionEnable()));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Tuple3 tuple32 = tuple3;
            return tuple32;
        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLiveInSyncReplicas2.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)partition, (Object)Option$.MODULE$.apply((Object)leaderIsrAndControllerEpoch), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            return tuple3;
        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        return (Seq)partitionsWithUncleanLeaderElectionState.map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple3 tuple3;
            Tuple3 tuple32 = x0$5;
            if (tuple32 != null) {
                TopicPartition partition = (TopicPartition)tuple32._1();
                Option leaderIsrAndControllerEpochOpt = (Option)tuple32._2();
                boolean uncleanLeaderElectionEnabled = BoxesRunTime.unboxToBoolean((Object)tuple32._3());
                Seq<Object> assignment = $this.controllerContext.partitionReplicaAssignment(partition);
                Seq liveReplicas = (Seq)assignment.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition, $this.controllerContext.isReplicaOnline$default$3()));
                if (leaderIsrAndControllerEpochOpt.nonEmpty()) {
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochOpt.get();
                    List<Object> isr = leaderIsrAndControllerEpoch.leaderAndIsr().isr();
                    Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection(assignment, (Seq<Object>)isr, (Set<Object>)liveReplicas.toSet(), uncleanLeaderElectionEnabled, $this.controllerContext);
                    Option newLeaderAndIsrOpt = leaderOpt.map((Function1 & Serializable & scala.Serializable)leader -> PartitionStateMachine.$anonfun$leaderForOffline$8(this, isr, partition, leaderIsrAndControllerEpoch, BoxesRunTime.unboxToInt((Object)leader)));
                    tuple3 = new Tuple3((Object)partition, (Object)newLeaderAndIsrOpt, (Object)liveReplicas);
                } else {
                    tuple3 = new Tuple3((Object)partition, (Object)None$.MODULE$, (Object)liveReplicas);
                }
            } else {
                throw new MatchError((Object)tuple32);
            }
            Tuple3 tuple33 = tuple3;
            return tuple33;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>>> leaderForReassign(Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>> leaderIsrAndControllerEpochs) {
        return (Seq)leaderIsrAndControllerEpochs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
            Seq<Object> reassignment = ((ReassignedPartitionsContext)$this.controllerContext.partitionsBeingReassigned().apply((Object)partition)).newReplicas();
            Seq liveReplicas = (Seq)reassignment.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition, $this.controllerContext.isReplicaOnline$default$3()));
            List<Object> isr = leaderIsrAndControllerEpoch.leaderAndIsr().isr();
            Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection(reassignment, (Seq<Object>)isr, (Set<Object>)liveReplicas.toSet());
            Option newLeaderAndIsrOpt = leaderOpt.map((Function1 & Serializable & scala.Serializable)leader -> PartitionStateMachine.$anonfun$leaderForReassign$3(leaderIsrAndControllerEpoch, BoxesRunTime.unboxToInt((Object)leader)));
            Tuple3 tuple3 = new Tuple3((Object)partition, (Object)newLeaderAndIsrOpt, reassignment);
            return tuple3;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>>> leaderForPreferredReplica(Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>> leaderIsrAndControllerEpochs) {
        return (Seq)leaderIsrAndControllerEpochs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
            Seq<Object> assignment = $this.controllerContext.partitionReplicaAssignment(partition);
            Seq liveReplicas = (Seq)assignment.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition, $this.controllerContext.isReplicaOnline$default$3()));
            List<Object> isr = leaderIsrAndControllerEpoch.leaderAndIsr().isr();
            Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment, (Seq<Object>)isr, (Set<Object>)liveReplicas.toSet());
            Option newLeaderAndIsrOpt = leaderOpt.map((Function1 & Serializable & scala.Serializable)leader -> PartitionStateMachine.$anonfun$leaderForPreferredReplica$3(leaderIsrAndControllerEpoch, BoxesRunTime.unboxToInt((Object)leader)));
            Tuple3 tuple3 = new Tuple3((Object)partition, (Object)newLeaderAndIsrOpt, assignment);
            return tuple3;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>>> leaderForControlledShutdown(Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>> leaderIsrAndControllerEpochs, Set<Object> shuttingDownBrokers) {
        return (Seq)leaderIsrAndControllerEpochs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
            Seq<Object> assignment = $this.controllerContext.partitionReplicaAssignment(partition);
            Seq liveOrShuttingDownReplicas = (Seq)assignment.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition, true));
            List<Object> isr = leaderIsrAndControllerEpoch.leaderAndIsr().isr();
            Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection(assignment, (Seq<Object>)isr, (Set<Object>)liveOrShuttingDownReplicas.toSet(), shuttingDownBrokers);
            List newIsr = (List)isr.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> !$this.controllerContext.shuttingDownBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)replica)));
            Option newLeaderAndIsrOpt = leaderOpt.map((Function1 & Serializable & scala.Serializable)leader -> PartitionStateMachine.$anonfun$leaderForControlledShutdown$4(leaderIsrAndControllerEpoch, newIsr, BoxesRunTime.unboxToInt((Object)leader)));
            Tuple3 tuple3 = new Tuple3((Object)partition, (Object)newLeaderAndIsrOpt, (Object)liveOrShuttingDownReplicas);
            return tuple3;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private boolean isValidTransition(TopicPartition partition, PartitionState targetState) {
        return targetState.validPreviousStates().contains(this.partitionState.apply((Object)partition));
    }

    private void logInvalidTransition(TopicPartition partition, PartitionState targetState) {
        PartitionState currState = (PartitionState)this.partitionState.apply((Object)partition);
        IllegalStateException e = new IllegalStateException(new StringBuilder(31).append("Partition ").append(partition).append(" should be in one of ").append(new StringBuilder(50).append(targetState.validPreviousStates().mkString(",")).append(" states before moving to ").append(targetState).append(" state. Instead it is in ").toString()).append(new StringBuilder(6).append(currState).append(" state").toString()).toString());
        this.logFailedStateChange(partition, currState, targetState, e);
    }

    private void logFailedStateChange(TopicPartition partition, PartitionState currState, PartitionState targetState, KeeperException.Code code) {
        this.logFailedStateChange(partition, currState, targetState, (Throwable)KeeperException.create((KeeperException.Code)code));
    }

    private void logFailedStateChange(TopicPartition partition, PartitionState currState, PartitionState targetState, Throwable t) {
        this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch()).error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Controller ").append(this.controllerId()).append(" epoch ").append($this.controllerContext.epoch()).append(" failed to change state for partition ").append(partition).append(" ").append(new StringBuilder(9).append("from ").append(currState).append(" to ").append(targetState).toString()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
    }

    public static final /* synthetic */ void $anonfun$initializePartitionState$1(PartitionStateMachine $this, TopicPartition topicPartition) {
        Option option = $this.controllerContext.partitionLeadershipInfo().get((Object)topicPartition);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)some.value();
            if ($this.controllerContext.isReplicaOnline(currentLeaderIsrAndEpoch.leaderAndIsr().leader(), topicPartition, $this.controllerContext.isReplicaOnline$default$3())) {
                $this.changeStateTo(topicPartition, NonExistentPartition$.MODULE$, OnlinePartition$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                $this.changeStateTo(topicPartition, NonExistentPartition$.MODULE$, OfflinePartition$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            $this.changeStateTo(topicPartition, NonExistentPartition$.MODULE$, NewPartition$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ boolean $anonfun$triggerOnlinePartitionStateChange$1(String topic$1, TopicPartition p) {
        return p.topic().equals(topic$1);
    }

    public static final /* synthetic */ boolean $anonfun$triggerOnlinePartitionStateChange$2(PartitionStateMachine $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        PartitionState partitionState = (PartitionState)tuple2._2();
        boolean bl = !$this.topicDeletionManager().isTopicQueuedUpForDeletion(partition.topic()) && (partitionState.equals(OfflinePartition$.MODULE$) || partitionState.equals(NewPartition$.MODULE$));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$partitionsInState$1(PartitionState state$1, Tuple2 x0$1) {
        PartitionState s;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        PartitionState partitionState = s = (PartitionState)tuple2._2();
        PartitionState partitionState2 = state$1;
        boolean bl = !(partitionState != null ? !partitionState.equals(partitionState2) : partitionState2 != null);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$5(PartitionStateMachine $this, StateChangeLogger stateChangeLog$1, PartitionState targetState$2, TopicPartition partition) {
        stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Changed partition ").append(partition).append(" state from ").append($this.partitionState.apply((Object)partition)).append(" to ").append(targetState$2).append(" with ").append(new StringBuilder(18).append("assigned replicas ").append($this.controllerContext.partitionReplicaAssignment(partition).mkString(",")).toString()).toString());
        $this.changeStateTo(partition, (PartitionState)$this.partitionState.apply((Object)partition), NewPartition$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$doHandleStateChanges$7(PartitionStateMachine $this, TopicPartition partition) {
        Object object = $this.partitionState.apply((Object)partition);
        NewPartition$ newPartition$ = NewPartition$.MODULE$;
        return !(object != null ? !object.equals(newPartition$) : newPartition$ != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$doHandleStateChanges$8(PartitionStateMachine $this, TopicPartition partition) {
        Object object = $this.partitionState.apply((Object)partition);
        OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
        if (object == null) {
            if (offlinePartition$ == null) return true;
        } else if (object.equals(offlinePartition$)) return true;
        Object object2 = $this.partitionState.apply((Object)partition);
        OnlinePartition$ onlinePartition$ = OnlinePartition$.MODULE$;
        if (object2 != null) {
            if (!object2.equals(onlinePartition$)) return false;
            return true;
        }
        if (onlinePartition$ == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$9(PartitionStateMachine $this, StateChangeLogger stateChangeLog$1, PartitionState targetState$2, TopicPartition partition) {
        stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Changed partition ").append(partition).append(" from ").append($this.partitionState.apply((Object)partition)).append(" to ").append(targetState$2).append(" with state ").append(String.valueOf(((LeaderIsrAndControllerEpoch)$this.controllerContext.partitionLeadershipInfo().apply((Object)partition)).leaderAndIsr())).toString());
        $this.changeStateTo(partition, (PartitionState)$this.partitionState.apply((Object)partition), OnlinePartition$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$11(PartitionStateMachine $this, StateChangeLogger stateChangeLog$1, PartitionState targetState$2, TopicPartition partition) {
        stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Changed partition ").append(partition).append(" from ").append($this.partitionState.apply((Object)partition)).append(" to ").append(targetState$2).append(" with state ").append(String.valueOf(((LeaderIsrAndControllerEpoch)$this.controllerContext.partitionLeadershipInfo().apply((Object)partition)).leaderAndIsr())).toString());
        $this.changeStateTo(partition, (PartitionState)$this.partitionState.apply((Object)partition), OnlinePartition$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$13(PartitionStateMachine $this, StateChangeLogger stateChangeLog$1, PartitionState targetState$2, TopicPartition partition) {
        stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Changed partition ").append(partition).append(" state from ").append($this.partitionState.apply((Object)partition)).append(" to ").append(targetState$2).toString());
        $this.changeStateTo(partition, (PartitionState)$this.partitionState.apply((Object)partition), OfflinePartition$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$15(PartitionStateMachine $this, StateChangeLogger stateChangeLog$1, PartitionState targetState$2, TopicPartition partition) {
        stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Changed partition ").append(partition).append(" state from ").append($this.partitionState.apply((Object)partition)).append(" to ").append(targetState$2).toString());
        $this.changeStateTo(partition, (PartitionState)$this.partitionState.apply((Object)partition), NonExistentPartition$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$initializeLeaderAndIsrForPartitions$4(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq liveReplicas = (Seq)tuple2._2();
        boolean bl = liveReplicas.isEmpty();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$initializeLeaderAndIsrForPartitions$5(PartitionStateMachine $this, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        Seq replicas = (Seq)tuple2._2();
        String failMsg = new StringBuilder(77).append("Controller ").append($this.controllerId()).append(" epoch ").append($this.controllerContext.epoch()).append(" encountered error during state change of ").append(new StringBuilder(53).append("partition ").append(partition).append(" from New to Online, assigned replicas are ").toString()).append(new StringBuilder(37).append("[").append(replicas.mkString(",")).append("], live brokers are [").append($this.controllerContext.liveBrokerIds()).append("]. No assigned ").toString()).append("replica is alive.").toString();
        $this.logFailedStateChange(partition, (PartitionState)NewPartition$.MODULE$, (PartitionState)OnlinePartition$.MODULE$, new StateChangeFailedException(failMsg));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$initializeLeaderAndIsrForPartitions$9(PartitionStateMachine $this, Exception e$4, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        $this.logFailedStateChange(partition, (PartitionState)$this.partitionState.apply((Object)partition), (PartitionState)NewPartition$.MODULE$, e$4);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$electLeaderForPartitions$1(PartitionStateMachine $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        Exception e = (Exception)tuple2._2();
        $this.logFailedStateChange(partition, (PartitionState)$this.partitionState.apply((Object)partition), (PartitionState)OnlinePartition$.MODULE$, e);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$3(PartitionStateMachine $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
        boolean bl = leaderIsrAndControllerEpoch.controllerEpoch() > $this.controllerContext.epoch();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$5(Tuple3 x0$3) {
        Tuple3 tuple3 = x0$3;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Option newLeaderAndIsrOpt = (Option)tuple3._2();
        boolean bl = newLeaderAndIsrOpt.isEmpty();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$6(Tuple3 x0$4) {
        Tuple3 tuple3 = x0$4;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Option newLeaderAndIsrOpt = (Option)tuple3._2();
        boolean bl = newLeaderAndIsrOpt.isEmpty();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$7(Tuple3 x0$5) {
        Tuple3 tuple3 = x0$5;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Option newLeaderAndIsrOpt = (Option)tuple3._2();
        boolean bl = newLeaderAndIsrOpt.isEmpty();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$8(Tuple3 x0$6) {
        Tuple3 tuple3 = x0$6;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Option newLeaderAndIsrOpt = (Option)tuple3._2();
        boolean bl = newLeaderAndIsrOpt.isEmpty();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$doElectLeaderForPartitions$12(PartitionStateMachine $this, scala.collection.immutable.Map recipientsPerPartition$1, Tuple2 x0$10) {
        Tuple2 tuple2 = x0$10;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
        Seq<Object> replicas = $this.controllerContext.partitionReplicaAssignment(partition);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, $this.controllerContext.epoch());
        $this.controllerContext.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
        $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)recipientsPerPartition$1.apply((Object)partition)), partition, leaderIsrAndControllerEpoch, replicas, false);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$leaderForOffline$1(PartitionStateMachine $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
        List liveInSyncReplicas = (List)leaderIsrAndControllerEpoch.leaderAndIsr().isr().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition, $this.controllerContext.isReplicaOnline$default$3()));
        boolean bl = liveInSyncReplicas.isEmpty();
        return bl;
    }

    public static final /* synthetic */ LeaderAndIsr $anonfun$leaderForOffline$8(PartitionStateMachine $this, List isr$1, TopicPartition partition$8, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1, int leader) {
        List newIsr = isr$1.contains((Object)BoxesRunTime.boxToInteger((int)leader)) ? (List)isr$1.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition$8, $this.controllerContext.isReplicaOnline$default$3())) : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader}));
        return leaderIsrAndControllerEpoch$1.leaderAndIsr().newLeaderAndIsr(leader, (List<Object>)newIsr);
    }

    public static final /* synthetic */ LeaderAndIsr $anonfun$leaderForReassign$3(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$2, int leader) {
        return leaderIsrAndControllerEpoch$2.leaderAndIsr().newLeader(leader);
    }

    public static final /* synthetic */ LeaderAndIsr $anonfun$leaderForPreferredReplica$3(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$3, int leader) {
        return leaderIsrAndControllerEpoch$3.leaderAndIsr().newLeader(leader);
    }

    public static final /* synthetic */ LeaderAndIsr $anonfun$leaderForControlledShutdown$4(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$4, List newIsr$1, int leader) {
        return leaderIsrAndControllerEpoch$4.leaderAndIsr().newLeaderAndIsr(leader, (List<Object>)newIsr$1);
    }

    public PartitionStateMachine(KafkaConfig config, StateChangeLogger stateChangeLogger, ControllerContext controllerContext, KafkaZkClient zkClient, Map<TopicPartition, PartitionState> partitionState, ControllerBrokerRequestBatch controllerBrokerRequestBatch) {
        this.config = config;
        this.stateChangeLogger = stateChangeLogger;
        this.controllerContext = controllerContext;
        this.zkClient = zkClient;
        this.partitionState = partitionState;
        this.controllerBrokerRequestBatch = controllerBrokerRequestBatch;
        Logging.$init$(this);
        this.controllerId = config.brokerId();
        this.logIdent_$eq(new StringBuilder(38).append("[PartitionStateMachine controllerId=").append(this.controllerId()).append("] ").toString());
        this.offlinePartitionCount = 0;
    }
}

