/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.jmeter.protocol.http.sampler.HTTPAbstractImpl;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.util.ConversionUtils;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.protocol.http.util.HTTPFileArg;
import org.apache.jmeter.testelement.property.JMeterProperty;

public class PostWriter {
    private static final String DASH_DASH = "--";
    private static final byte[] DASH_DASH_BYTES = new byte[]{45, 45};
    protected static final String BOUNDARY = "---------------------------7d159c1302d0y0";
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final String CRLF_STRING = "\r\n";
    public static final String ENCODING = StandardCharsets.UTF_8.name();
    protected byte[] formDataUrlEncoded;
    protected byte[] formDataPostBody;
    private final String boundary;
    private final String multipartDivider;
    private final byte[] multipartDividerBytes;

    public PostWriter() {
        this(BOUNDARY);
    }

    public PostWriter(String boundary) {
        this.boundary = boundary;
        this.multipartDivider = DASH_DASH + boundary;
        this.multipartDividerBytes = this.multipartDivider.getBytes(StandardCharsets.UTF_8);
    }

    public String sendPostData(URLConnection connection, HTTPSamplerBase sampler) throws IOException {
        StringBuilder postedBody = new StringBuilder(1000);
        HTTPFileArg[] files = sampler.getHTTPFiles();
        String contentEncoding = sampler.getContentEncoding();
        if (sampler.getUseMultipart()) {
            OutputStream out = connection.getOutputStream();
            out.write(this.formDataPostBody);
            postedBody.append(new String(this.formDataPostBody, contentEncoding));
            for (HTTPFileArg file : files) {
                out.write(this.multipartDividerBytes);
                out.write(CRLF);
                postedBody.append(this.multipartDivider);
                postedBody.append(CRLF_STRING);
                String headerValue = file.getHeader();
                byte[] header = headerValue.getBytes(contentEncoding);
                out.write(header);
                postedBody.append(headerValue);
                PostWriter.writeFileToStream(file.getPath(), out);
                postedBody.append("<actual file content, not shown here>");
                out.write(CRLF);
                postedBody.append(CRLF_STRING);
            }
            out.write(this.multipartDividerBytes);
            out.write(DASH_DASH_BYTES);
            out.write(CRLF);
            postedBody.append(this.multipartDivider);
            postedBody.append("--\r\n");
            out.close();
        } else if (sampler.getArguments() != null && !sampler.hasArguments() && sampler.getSendFileAsPostBody()) {
            OutputStream out = connection.getOutputStream();
            HTTPFileArg file = files[0];
            PostWriter.writeFileToStream(file.getPath(), out);
            out.flush();
            out.close();
            postedBody.append("<actual file content, not shown here>");
        } else if (this.formDataUrlEncoded != null) {
            OutputStream out = connection.getOutputStream();
            out.write(this.formDataUrlEncoded);
            out.flush();
            out.close();
            postedBody.append(new String(this.formDataUrlEncoded, contentEncoding));
        }
        return postedBody.toString();
    }

    public void setHeaders(URLConnection connection, HTTPSamplerBase sampler) throws IOException {
        String contentEncoding = sampler.getContentEncoding();
        long contentLength = 0L;
        HTTPFileArg[] files = sampler.getHTTPFiles();
        if (sampler.getUseMultipart()) {
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.getBoundary());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bos, contentEncoding);
            for (JMeterProperty jMeterProperty : sampler.getArguments()) {
                String parameterName;
                HTTPArgument arg = (HTTPArgument)jMeterProperty.getObjectValue();
                if (arg.isSkippable(parameterName = arg.getName())) continue;
                this.writeFormMultipart(osw, contentEncoding, parameterName, arg.getValue(), sampler.getDoBrowserCompatibleMultipart());
            }
            osw.flush();
            this.formDataPostBody = bos.toByteArray();
            contentLength = this.formDataPostBody.length;
            for (int i = 0; i < files.length; ++i) {
                bos.reset();
                contentLength += (long)(this.multipartDividerBytes.length + CRLF.length);
                HTTPFileArg file = files[i];
                PostWriter.writeStartFileMultipart(osw, contentEncoding, file.getPath(), file.getParamName(), file.getMimeType());
                osw.flush();
                String header = bos.toString(contentEncoding);
                file.setHeader(header);
                contentLength += (long)bos.size();
                File uploadFile = new File(file.getPath());
                contentLength += uploadFile.length();
                contentLength += (long)CRLF.length;
            }
            connection.setRequestProperty("Content-Length", Long.toString(contentLength += (long)(this.multipartDividerBytes.length + DASH_DASH_BYTES.length + CRLF.length)));
            connection.setDoOutput(true);
            connection.setDoInput(true);
        } else {
            boolean hasContentTypeHeader;
            String contentTypeHeader = connection.getRequestProperty("Content-Type");
            boolean bl = hasContentTypeHeader = contentTypeHeader != null && contentTypeHeader.length() > 0;
            if (sampler.getArguments() != null && sampler.getArguments().getArgumentCount() == 0 && sampler.getSendFileAsPostBody()) {
                HTTPFileArg file = files[0];
                if (!hasContentTypeHeader) {
                    if (file.getMimeType() != null && file.getMimeType().length() > 0) {
                        connection.setRequestProperty("Content-Type", file.getMimeType());
                    } else if (HTTPAbstractImpl.ADD_CONTENT_TYPE_TO_POST_IF_MISSING) {
                        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    }
                }
                File inputFile = new File(file.getPath());
                contentLength = inputFile.length();
            } else {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                String postBody = null;
                if (!sampler.getSendParameterValuesAsPostBody()) {
                    if (!hasContentTypeHeader && HTTPAbstractImpl.ADD_CONTENT_TYPE_TO_POST_IF_MISSING) {
                        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    }
                    postBody = sampler.getQueryString(contentEncoding);
                } else {
                    if (!hasContentTypeHeader) {
                        HTTPFileArg file;
                        HTTPFileArg hTTPFileArg = file = files.length > 0 ? files[0] : null;
                        if (file != null && file.getMimeType() != null && file.getMimeType().length() > 0) {
                            connection.setRequestProperty("Content-Type", file.getMimeType());
                        } else if (HTTPAbstractImpl.ADD_CONTENT_TYPE_TO_POST_IF_MISSING) {
                            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                        }
                    }
                    StringBuilder postBodyBuffer = new StringBuilder();
                    for (JMeterProperty jMeterProperty : sampler.getArguments()) {
                        HTTPArgument arg = (HTTPArgument)jMeterProperty.getObjectValue();
                        postBodyBuffer.append(arg.getEncodedValue(contentEncoding));
                    }
                    postBody = postBodyBuffer.toString();
                }
                bos.write(postBody.getBytes(contentEncoding));
                bos.flush();
                bos.close();
                this.formDataUrlEncoded = bos.toByteArray();
                contentLength = bos.toByteArray().length;
            }
            connection.setRequestProperty("Content-Length", Long.toString(contentLength));
            connection.setDoOutput(true);
        }
    }

    protected String getBoundary() {
        return this.boundary;
    }

    private static void writeStartFileMultipart(Writer out, String contentEncoding, String filePath, String nameField, String mimetype) throws IOException {
        PostWriter.write(out, "Content-Disposition: form-data; name=\"");
        PostWriter.write(out, ConversionUtils.percentEncode(nameField));
        PostWriter.write(out, "\"; filename=\"");
        String filename = new File(filePath).getName();
        Charset charset = Charset.forName(contentEncoding);
        PostWriter.write(out, ConversionUtils.percentEncode(ConversionUtils.encodeWithEntities(filename, charset)));
        PostWriter.writeln(out, "\"");
        PostWriter.write(out, "Content-Type: ");
        PostWriter.writeln(out, mimetype);
        PostWriter.writeln(out, "Content-Transfer-Encoding: binary");
        out.write(CRLF_STRING);
    }

    private static void writeFileToStream(String filename, OutputStream out) throws IOException {
        byte[] buf = new byte[1024];
        try (InputStream in = Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]);){
            int read;
            while ((read = in.read(buf)) > 0) {
                out.write(buf, 0, read);
            }
        }
    }

    private void writeFormMultipart(Writer out, String contentEncoding, String name, String value, boolean browserCompatibleMultipart) throws IOException {
        PostWriter.writeln(out, this.multipartDivider);
        PostWriter.write(out, "Content-Disposition: form-data; name=\"");
        PostWriter.write(out, ConversionUtils.percentEncode(name));
        PostWriter.writeln(out, "\"");
        if (!browserCompatibleMultipart) {
            PostWriter.write(out, "Content-Type: text/plain; charset=");
            PostWriter.writeln(out, contentEncoding);
            PostWriter.writeln(out, "Content-Transfer-Encoding: 8bit");
        }
        out.write(CRLF_STRING);
        out.write(value);
        out.write(CRLF_STRING);
    }

    private static void write(Writer out, String value) throws IOException {
        out.write(value);
    }

    private static void writeln(Writer out, String value) throws IOException {
        out.write(value);
        out.write(CRLF_STRING);
    }
}

