/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.progmodels.dflt;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.isis.core.commons.config.InstallerAbstract;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.metamodel.facetdecorator.FacetDecorator;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.layout.MemberLayoutArranger;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.specloader.FacetDecoratorInstaller;
import org.apache.isis.core.metamodel.specloader.ObjectReflector;
import org.apache.isis.core.metamodel.specloader.ObjectReflectorDefault;
import org.apache.isis.core.metamodel.specloader.ObjectReflectorInstaller;
import org.apache.isis.core.metamodel.specloader.ReflectorConstants;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ClassSubstitutorComposite;
import org.apache.isis.core.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistry;
import org.apache.isis.core.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistryDefault;
import org.apache.isis.core.metamodel.specloader.traverser.SpecificationTraverser;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidator;
import org.apache.isis.runtimes.dflt.runtime.installerregistry.InstallerLookup;
import org.apache.isis.runtimes.dflt.runtime.installerregistry.InstallerLookupAware;
import org.apache.log4j.Logger;

public class JavaReflectorInstaller
extends InstallerAbstract
implements ObjectReflectorInstaller,
InstallerLookupAware {
    private static final Logger LOG = Logger.getLogger(JavaReflectorInstaller.class);
    public static final String PROPERTY_BASE = "isis.";
    private final LinkedHashSet<FacetDecoratorInstaller> decoratorInstallers = new LinkedHashSet();
    private InstallerLookup installerLookup;

    public JavaReflectorInstaller() {
        this("java");
    }

    public JavaReflectorInstaller(String name) {
        super("reflector", name);
    }

    public ObjectReflectorDefault createReflector() {
        ClassSubstitutor classSubstitutor = this.createClassSubstitutor(this.getConfiguration());
        CollectionTypeRegistry collectionTypeRegistry = this.createCollectionTypeRegistry(this.getConfiguration());
        SpecificationTraverser specificationTraverser = this.createSpecificationTraverser(this.getConfiguration());
        MemberLayoutArranger memberLayoutArranger = this.createMemberLayoutArranger(this.getConfiguration());
        ProgrammingModel programmingModel = this.createProgrammingModelFacets(this.getConfiguration());
        Set<FacetDecorator> facetDecorators = this.createFacetDecorators(this.getConfiguration());
        MetaModelValidator metaModelValidator = this.createMetaModelValidator(this.getConfiguration());
        ObjectReflectorDefault reflector = this.doCreateReflector(this.getConfiguration(), classSubstitutor, collectionTypeRegistry, specificationTraverser, memberLayoutArranger, programmingModel, facetDecorators, metaModelValidator);
        return reflector;
    }

    protected ClassSubstitutor createClassSubstitutor(IsisConfiguration configuration) {
        String[] configuredClassNames = configuration.getList("isis.reflector.class-substitutor");
        if (configuredClassNames == null || configuredClassNames.length == 0) {
            return (ClassSubstitutor)InstanceUtil.createInstance((String)"org.apache.isis.runtimes.dflt.bytecode.dflt.classsubstitutor.CglibClassSubstitutor", ClassSubstitutor.class);
        }
        ArrayList substitutors = Lists.newArrayList();
        for (String className : configuredClassNames) {
            ClassSubstitutor substitutor = (ClassSubstitutor)InstanceUtil.createInstance((String)className, ClassSubstitutor.class);
            substitutors.add(substitutor);
        }
        return substitutors.size() == 1 ? (ClassSubstitutor)substitutors.get(0) : new ClassSubstitutorComposite((List)substitutors);
    }

    protected SpecificationTraverser createSpecificationTraverser(IsisConfiguration configuration) {
        String specificationTraverserClassName = configuration.getString("isis.reflector.traverser", ReflectorConstants.SPECIFICATION_TRAVERSER_CLASS_NAME_DEFAULT);
        SpecificationTraverser specificationTraverser = (SpecificationTraverser)InstanceUtil.createInstance((String)specificationTraverserClassName, SpecificationTraverser.class);
        return specificationTraverser;
    }

    protected MemberLayoutArranger createMemberLayoutArranger(IsisConfiguration configuration) {
        String memberLayoutArrangerClassName = configuration.getString("isis.reflector.memberlayoutarranger", "org.apache.isis.core.progmodel.layout.dflt.MemberLayoutArrangerDefault");
        MemberLayoutArranger memberLayoutArranger = (MemberLayoutArranger)InstanceUtil.createInstance((String)memberLayoutArrangerClassName, MemberLayoutArranger.class);
        return memberLayoutArranger;
    }

    protected ProgrammingModel createProgrammingModelFacets(IsisConfiguration configuration) {
        ProgrammingModel programmingModel = this.lookupAndCreateProgrammingModelFacets(configuration);
        this.includeFacetFactories(configuration, programmingModel);
        this.excludeFacetFactories(configuration, programmingModel);
        return programmingModel;
    }

    private ProgrammingModel lookupAndCreateProgrammingModelFacets(IsisConfiguration configuration) {
        String progModelFacetsClassName = configuration.getString("isis.reflector.facets", "org.apache.isis.progmodels.dflt.ProgrammingModelFacetsJava5");
        ProgrammingModel programmingModel = (ProgrammingModel)InstanceUtil.createInstance((String)progModelFacetsClassName, ProgrammingModel.class);
        return programmingModel;
    }

    protected void includeFacetFactories(IsisConfiguration configuration, ProgrammingModel programmingModel) {
        String[] facetFactoriesIncludeClassNames = configuration.getList("isis.reflector.facets.include");
        if (facetFactoriesIncludeClassNames != null) {
            for (String facetFactoryClassName : facetFactoriesIncludeClassNames) {
                Class facetFactory = InstanceUtil.loadClass((String)facetFactoryClassName, FacetFactory.class);
                programmingModel.addFactory(facetFactory);
            }
        }
    }

    protected void excludeFacetFactories(IsisConfiguration configuration, ProgrammingModel programmingModel) {
        String[] facetFactoriesExcludeClassNames;
        for (String facetFactoryClassName : facetFactoriesExcludeClassNames = configuration.getList("isis.reflector.facets.exclude")) {
            Class facetFactory = InstanceUtil.loadClass((String)facetFactoryClassName, FacetFactory.class);
            programmingModel.removeFactory(facetFactory);
        }
    }

    protected Set<FacetDecorator> createFacetDecorators(IsisConfiguration configuration) {
        this.addFacetDecoratorInstallers(configuration);
        return this.createFacetDecorators(this.decoratorInstallers);
    }

    private void addFacetDecoratorInstallers(IsisConfiguration configuration) {
        String[] decoratorNames;
        for (String decoratorName : decoratorNames = configuration.getList("isis.reflector.facet-decorators")) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("adding reflector facet decorator from configuration " + decoratorName));
            }
            this.addFacetDecoratorInstaller(this.lookupFacetDecorator(decoratorName));
        }
    }

    private FacetDecoratorInstaller lookupFacetDecorator(String decoratorClassName) {
        return (FacetDecoratorInstaller)this.installerLookup.getInstaller(FacetDecoratorInstaller.class, decoratorClassName);
    }

    private Set<FacetDecorator> createFacetDecorators(Set<FacetDecoratorInstaller> decoratorInstallers) {
        LinkedHashSet decorators = new LinkedHashSet();
        if (decoratorInstallers.size() == 0 && LOG.isInfoEnabled()) {
            LOG.info((Object)"No facet decorators installers added");
        }
        for (FacetDecoratorInstaller installer : decoratorInstallers) {
            decorators.addAll(installer.createDecorators());
        }
        return Collections.unmodifiableSet(decorators);
    }

    protected MetaModelValidator createMetaModelValidator(IsisConfiguration configuration) {
        String metaModelValidatorClassName = configuration.getString("isis.reflector.validator", "org.apache.isis.core.progmodel.metamodelvalidator.dflt.MetaModelValidatorDefault");
        MetaModelValidator metaModelValidator = (MetaModelValidator)InstanceUtil.createInstance((String)metaModelValidatorClassName, MetaModelValidator.class);
        return metaModelValidator;
    }

    protected final CollectionTypeRegistry createCollectionTypeRegistry(IsisConfiguration configuration) {
        return new CollectionTypeRegistryDefault();
    }

    protected ObjectReflectorDefault doCreateReflector(IsisConfiguration configuration, ClassSubstitutor classSubstitutor, CollectionTypeRegistry collectionTypeRegistry, SpecificationTraverser specificationTraverser, MemberLayoutArranger memberLayoutArranger, ProgrammingModel programmingModel, Set<FacetDecorator> facetDecorators, MetaModelValidator metaModelValidator) {
        return new ObjectReflectorDefault(configuration, classSubstitutor, collectionTypeRegistry, specificationTraverser, memberLayoutArranger, programmingModel, facetDecorators, metaModelValidator);
    }

    public void setInstallerLookup(InstallerLookup installerLookup) {
        this.installerLookup = installerLookup;
    }

    public void addFacetDecoratorInstaller(FacetDecoratorInstaller decoratorInstaller) {
        if (decoratorInstaller == null) {
            return;
        }
        this.decoratorInstallers.add(decoratorInstaller);
    }

    public List<Class<?>> getTypes() {
        return JavaReflectorInstaller.listOf((Class[])new Class[]{ObjectReflector.class});
    }
}

