/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.deltacommit;

import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieJavaEngineContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.JavaWriteHelper;
import org.apache.hudi.table.action.deltacommit.BaseJavaDeltaCommitActionExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaUpsertDeltaCommitActionExecutor<T>
extends BaseJavaDeltaCommitActionExecutor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(JavaUpsertDeltaCommitActionExecutor.class);
    private final List<HoodieRecord<T>> inputRecords;

    public JavaUpsertDeltaCommitActionExecutor(HoodieJavaEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, List<HoodieRecord<T>> inputRecords) {
        super(context, config, table, instantTime, WriteOperationType.UPSERT);
        this.inputRecords = inputRecords;
    }

    public HoodieWriteMetadata<List<WriteStatus>> execute() {
        return JavaWriteHelper.newInstance().write(this.instantTime, this.inputRecords, this.context, this.table, this.config.shouldCombineBeforeUpsert(), this.config.getUpsertShuffleParallelism(), this, this.operationType);
    }
}

