/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.NumericUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.WorkloadProfile;
import org.apache.hudi.table.WorkloadStat;
import org.apache.hudi.table.action.commit.BucketInfo;
import org.apache.hudi.table.action.commit.BucketType;
import org.apache.hudi.table.action.commit.InsertBucket;
import org.apache.hudi.table.action.commit.InsertBucketCumulativeWeightPair;
import org.apache.hudi.table.action.commit.Partitioner;
import org.apache.hudi.table.action.commit.SmallFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaUpsertPartitioner<T>
implements Partitioner {
    private static final Logger LOG = LoggerFactory.getLogger(JavaUpsertPartitioner.class);
    protected List<SmallFile> smallFiles = new ArrayList<SmallFile>();
    private int totalBuckets = 0;
    private WorkloadProfile workloadProfile;
    private HashMap<String, Integer> updateLocationToBucket = new HashMap();
    private HashMap<String, List<InsertBucketCumulativeWeightPair>> partitionPathToInsertBucketInfos = new HashMap();
    private HashMap<Integer, BucketInfo> bucketInfoMap = new HashMap();
    protected final HoodieTable table;
    protected final HoodieWriteConfig config;

    public JavaUpsertPartitioner(WorkloadProfile workloadProfile, HoodieEngineContext context, HoodieTable table, HoodieWriteConfig config) {
        this.workloadProfile = workloadProfile;
        this.table = table;
        this.config = config;
        this.assignUpdates(workloadProfile);
        this.assignInserts(workloadProfile, context);
        LOG.info("Total Buckets :" + this.totalBuckets + ", buckets info => " + this.bucketInfoMap + ", \nPartition to insert buckets => " + this.partitionPathToInsertBucketInfos + ", \nUpdateLocations mapped to buckets =>" + this.updateLocationToBucket);
    }

    private void assignUpdates(WorkloadProfile profile) {
        Set partitionStatEntries = profile.getInputPartitionPathStatMap().entrySet();
        for (Map.Entry partitionStat : partitionStatEntries) {
            WorkloadStat outputWorkloadStats = profile.getOutputPartitionPathStatMap().getOrDefault(partitionStat.getKey(), new WorkloadStat());
            for (Map.Entry updateLocEntry : ((WorkloadStat)partitionStat.getValue()).getUpdateLocationToCount().entrySet()) {
                this.addUpdateBucket((String)partitionStat.getKey(), (String)updateLocEntry.getKey());
                if (!profile.hasOutputWorkLoadStats()) continue;
                HoodieRecordLocation hoodieRecordLocation = new HoodieRecordLocation((String)((Pair)updateLocEntry.getValue()).getKey(), (String)updateLocEntry.getKey());
                outputWorkloadStats.addUpdates(hoodieRecordLocation, ((Long)((Pair)updateLocEntry.getValue()).getValue()).longValue());
            }
            if (!profile.hasOutputWorkLoadStats()) continue;
            profile.updateOutputPartitionPathStatMap((String)partitionStat.getKey(), outputWorkloadStats);
        }
    }

    private int addUpdateBucket(String partitionPath, String fileIdHint) {
        int bucket = this.totalBuckets;
        this.updateLocationToBucket.put(fileIdHint, bucket);
        BucketInfo bucketInfo = new BucketInfo(BucketType.UPDATE, fileIdHint, partitionPath);
        this.bucketInfoMap.put(this.totalBuckets, bucketInfo);
        ++this.totalBuckets;
        return bucket;
    }

    private void assignInserts(WorkloadProfile profile, HoodieEngineContext context) {
        Set partitionPaths = profile.getPartitionPaths();
        long averageRecordSize = JavaUpsertPartitioner.averageBytesPerRecord(this.table.getMetaClient().getActiveTimeline().getCommitAndReplaceTimeline().filterCompletedInstants(), this.config);
        LOG.info("AvgRecordSize => " + averageRecordSize);
        Map<String, List<SmallFile>> partitionSmallFilesMap = this.getSmallFilesForPartitions(new ArrayList<String>(partitionPaths), context);
        for (String partitionPath : partitionPaths) {
            WorkloadStat pStat = profile.getWorkloadStat(partitionPath);
            WorkloadStat outputWorkloadStats = profile.getOutputPartitionPathStatMap().getOrDefault(partitionPath, new WorkloadStat());
            if (pStat.getNumInserts() > 0L) {
                List smallFiles = partitionSmallFilesMap.getOrDefault(partitionPath, new ArrayList());
                this.smallFiles.addAll(smallFiles);
                LOG.info("For partitionPath : " + partitionPath + " Small Files => " + smallFiles);
                long totalUnassignedInserts = pStat.getNumInserts();
                ArrayList<Integer> bucketNumbers = new ArrayList<Integer>();
                ArrayList<Long> recordsPerBucket = new ArrayList<Long>();
                for (SmallFile smallFile : smallFiles) {
                    int bucket;
                    long recordsToAppend = Math.min((this.config.getParquetMaxFileSize() - smallFile.sizeBytes) / averageRecordSize, totalUnassignedInserts);
                    if (recordsToAppend <= 0L) continue;
                    if (this.updateLocationToBucket.containsKey(smallFile.location.getFileId())) {
                        bucket = this.updateLocationToBucket.get(smallFile.location.getFileId());
                        LOG.info("Assigning " + recordsToAppend + " inserts to existing update bucket " + bucket);
                    } else {
                        bucket = this.addUpdateBucket(partitionPath, smallFile.location.getFileId());
                        LOG.info("Assigning " + recordsToAppend + " inserts to new update bucket " + bucket);
                    }
                    if (profile.hasOutputWorkLoadStats()) {
                        outputWorkloadStats.addInserts(smallFile.location, recordsToAppend);
                    }
                    bucketNumbers.add(bucket);
                    recordsPerBucket.add(recordsToAppend);
                    totalUnassignedInserts -= recordsToAppend;
                }
                if (totalUnassignedInserts > 0L) {
                    long insertRecordsPerBucket = this.config.getCopyOnWriteInsertSplitSize();
                    if (this.config.shouldAutoTuneInsertSplits()) {
                        insertRecordsPerBucket = this.config.getParquetMaxFileSize() / averageRecordSize;
                    }
                    int insertBuckets = (int)Math.ceil(1.0 * (double)totalUnassignedInserts / (double)insertRecordsPerBucket);
                    LOG.info("After small file assignment: unassignedInserts => " + totalUnassignedInserts + ", totalInsertBuckets => " + insertBuckets + ", recordsPerBucket => " + insertRecordsPerBucket);
                    for (int b = 0; b < insertBuckets; ++b) {
                        bucketNumbers.add(this.totalBuckets);
                        if (b < insertBuckets - 1) {
                            recordsPerBucket.add(insertRecordsPerBucket);
                        } else {
                            recordsPerBucket.add(totalUnassignedInserts - (long)(insertBuckets - 1) * insertRecordsPerBucket);
                        }
                        BucketInfo bucketInfo = new BucketInfo(BucketType.INSERT, FSUtils.createNewFileIdPfx(), partitionPath);
                        this.bucketInfoMap.put(this.totalBuckets, bucketInfo);
                        if (profile.hasOutputWorkLoadStats()) {
                            outputWorkloadStats.addInserts(new HoodieRecordLocation("null", bucketInfo.getFileIdPrefix()), ((Long)recordsPerBucket.get(recordsPerBucket.size() - 1)).longValue());
                        }
                        ++this.totalBuckets;
                    }
                }
                ArrayList<InsertBucketCumulativeWeightPair> insertBuckets = new ArrayList<InsertBucketCumulativeWeightPair>();
                double currentCumulativeWeight = 0.0;
                for (int i = 0; i < bucketNumbers.size(); ++i) {
                    InsertBucket bkt = new InsertBucket();
                    bkt.bucketNumber = (Integer)bucketNumbers.get(i);
                    bkt.weight = 1.0 * (double)((Long)recordsPerBucket.get(i)).longValue() / (double)pStat.getNumInserts();
                    insertBuckets.add(new InsertBucketCumulativeWeightPair(bkt, Double.valueOf(currentCumulativeWeight += bkt.weight)));
                }
                LOG.info("Total insert buckets for partition path " + partitionPath + " => " + insertBuckets);
                this.partitionPathToInsertBucketInfos.put(partitionPath, insertBuckets);
            }
            if (!profile.hasOutputWorkLoadStats()) continue;
            profile.updateOutputPartitionPathStatMap(partitionPath, outputWorkloadStats);
        }
    }

    private Map<String, List<SmallFile>> getSmallFilesForPartitions(List<String> partitionPaths, HoodieEngineContext context) {
        Map<String, List<Object>> partitionSmallFilesMap = new HashMap<String, List<SmallFile>>();
        if (this.config.getParquetSmallFileLimit() <= 0) {
            return partitionSmallFilesMap;
        }
        if (partitionPaths != null && partitionPaths.size() > 0) {
            context.setJobStatus(this.getClass().getSimpleName(), "Getting small files from partitions: " + this.config.getTableName());
            partitionSmallFilesMap = context.mapToPair(partitionPaths, (SerializablePairFunction & Serializable)partitionPath -> new ImmutablePair(partitionPath, this.getSmallFiles((String)partitionPath)), Integer.valueOf(0));
        }
        return partitionSmallFilesMap;
    }

    protected List<SmallFile> getSmallFiles(String partitionPath) {
        ArrayList<SmallFile> smallFileLocations = new ArrayList<SmallFile>();
        HoodieTimeline commitTimeline = this.table.getMetaClient().getCommitsTimeline().filterCompletedInstants();
        if (!commitTimeline.empty()) {
            HoodieInstant latestCommitTime = (HoodieInstant)commitTimeline.lastInstant().get();
            List allFiles = this.table.getBaseFileOnlyView().getLatestBaseFilesBeforeOrOn(partitionPath, latestCommitTime.getTimestamp()).collect(Collectors.toList());
            for (HoodieBaseFile file : allFiles) {
                if (file.getFileSize() >= (long)this.config.getParquetSmallFileLimit()) continue;
                SmallFile sf = new SmallFile();
                sf.location = new HoodieRecordLocation(file.getCommitTime(), file.getFileId());
                sf.sizeBytes = file.getFileSize();
                smallFileLocations.add(sf);
            }
        }
        return smallFileLocations;
    }

    public BucketInfo getBucketInfo(int bucketNumber) {
        return this.bucketInfoMap.get(bucketNumber);
    }

    public List<InsertBucketCumulativeWeightPair> getInsertBuckets(String partitionPath) {
        return this.partitionPathToInsertBucketInfos.get(partitionPath);
    }

    public int getNumPartitions() {
        return this.totalBuckets;
    }

    public int getPartition(Object key) {
        Pair keyLocation = (Pair)key;
        if (((Option)keyLocation.getRight()).isPresent()) {
            HoodieRecordLocation location = (HoodieRecordLocation)((Option)keyLocation.getRight()).get();
            return this.updateLocationToBucket.get(location.getFileId());
        }
        String partitionPath = ((HoodieKey)keyLocation.getLeft()).getPartitionPath();
        List<InsertBucketCumulativeWeightPair> targetBuckets = this.partitionPathToInsertBucketInfos.get(partitionPath);
        long totalInserts = Math.max(1L, this.workloadProfile.getWorkloadStat(partitionPath).getNumInserts());
        long hashOfKey = NumericUtils.getMessageDigestHash((String)"MD5", (String)((HoodieKey)keyLocation.getLeft()).getRecordKey());
        double r = 1.0 * (double)Math.floorMod(hashOfKey, totalInserts) / (double)totalInserts;
        int index = Collections.binarySearch(targetBuckets, new InsertBucketCumulativeWeightPair(new InsertBucket(), Double.valueOf(r)));
        if (index >= 0) {
            return ((InsertBucket)targetBuckets.get((int)index).getKey()).bucketNumber;
        }
        if (-1 * index - 1 < targetBuckets.size()) {
            return ((InsertBucket)targetBuckets.get((int)(-1 * index - 1)).getKey()).bucketNumber;
        }
        return ((InsertBucket)targetBuckets.get((int)0).getKey()).bucketNumber;
    }

    protected static long averageBytesPerRecord(HoodieTimeline commitTimeline, HoodieWriteConfig hoodieWriteConfig) {
        long avgSize;
        block3: {
            avgSize = hoodieWriteConfig.getCopyOnWriteRecordSizeEstimate();
            long fileSizeThreshold = (long)(hoodieWriteConfig.getRecordSizeEstimationThreshold() * (double)hoodieWriteConfig.getParquetSmallFileLimit());
            try {
                if (commitTimeline.empty()) break block3;
                Iterator instants = commitTimeline.getReverseOrderedInstants().iterator();
                while (instants.hasNext()) {
                    HoodieInstant instant = (HoodieInstant)instants.next();
                    HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])commitTimeline.getInstantDetails(instant).get()), HoodieCommitMetadata.class);
                    long totalBytesWritten = commitMetadata.fetchTotalBytesWritten();
                    long totalRecordsWritten = commitMetadata.fetchTotalRecordsWritten();
                    if (totalBytesWritten <= fileSizeThreshold || totalRecordsWritten <= 0L) continue;
                    avgSize = (long)Math.ceil(1.0 * (double)totalBytesWritten / (double)totalRecordsWritten);
                    break;
                }
            }
            catch (Throwable t) {
                LOG.error("Error trying to compute average bytes/record ", t);
            }
        }
        return avgSize;
    }

    public List<String> getSmallFileIds() {
        return this.smallFiles.stream().map(smallFile -> smallFile.location.getFileId()).collect(Collectors.toList());
    }
}

