/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.balancer;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hudi.org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hudi.org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hudi.org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MaintenanceLoadBalancer
extends Configured
implements LoadBalancer {
    private volatile boolean stopped = false;

    @Override
    public void stop(String why) {
        this.stopped = true;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public void setClusterMetrics(ClusterMetrics st) {
    }

    @Override
    public void setMasterServices(MasterServices masterServices) {
    }

    @Override
    public List<RegionPlan> balanceCluster(Map<TableName, Map<ServerName, List<RegionInfo>>> loadOfAllTable) throws IOException {
        return Collections.emptyList();
    }

    @Override
    public List<RegionPlan> balanceTable(TableName tableName, Map<ServerName, List<RegionInfo>> loadOfOneTable) {
        return Collections.emptyList();
    }

    private Map<ServerName, List<RegionInfo>> assign(Collection<RegionInfo> regions, List<ServerName> servers) {
        assert (servers.size() == 1);
        List systemRegions = regions.stream().filter(r -> r.getTable().isSystemTable()).collect(Collectors.toList());
        if (!systemRegions.isEmpty()) {
            return Collections.singletonMap(servers.get(0), systemRegions);
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<ServerName, List<RegionInfo>> roundRobinAssignment(List<RegionInfo> regions, List<ServerName> servers) {
        return this.assign(regions, servers);
    }

    @Override
    public Map<ServerName, List<RegionInfo>> retainAssignment(Map<RegionInfo, ServerName> regions, List<ServerName> servers) {
        return this.assign(regions.keySet(), servers);
    }

    @Override
    public ServerName randomAssignment(RegionInfo regionInfo, List<ServerName> servers) {
        assert (servers.size() == 1);
        return regionInfo.getTable().isSystemTable() ? servers.get(0) : null;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void regionOnline(RegionInfo regionInfo, ServerName sn) {
    }

    @Override
    public void regionOffline(RegionInfo regionInfo) {
    }

    @Override
    public void onConfigurationChange(Configuration conf) {
    }

    @Override
    public void postMasterStartupInitialize() {
    }

    @Override
    public void updateBalancerStatus(boolean status) {
    }
}

