/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.hadoop.util.Shell;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.bucket.IOEngine;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class PersistentIOEngine
implements IOEngine {
    private static final Logger LOG = LoggerFactory.getLogger(PersistentIOEngine.class);
    private static final DuFileCommand DU = new DuFileCommand(new String[]{"du", ""});
    protected final String[] filePaths;

    public PersistentIOEngine(String ... filePaths) {
        this.filePaths = filePaths;
    }

    protected void verifyFileIntegrity(byte[] persistentChecksum, String algorithm) throws IOException {
        byte[] calculateChecksum = this.calculateChecksum(algorithm);
        if (!Bytes.equals(persistentChecksum, calculateChecksum)) {
            throw new IOException("Mismatch of checksum! The persistent checksum is " + Bytes.toString(persistentChecksum) + ", but the calculate checksum is " + Bytes.toString(calculateChecksum));
        }
    }

    protected byte[] calculateChecksum(String algorithm) {
        try {
            StringBuilder sb = new StringBuilder();
            for (String filePath : this.filePaths) {
                File file = new File(filePath);
                sb.append(filePath);
                sb.append(PersistentIOEngine.getFileSize(filePath));
                sb.append(file.lastModified());
            }
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            messageDigest.update(Bytes.toBytes(sb.toString()));
            return messageDigest.digest();
        }
        catch (IOException ioex) {
            LOG.error("Calculating checksum failed, because of ", (Throwable)ioex);
            return new byte[0];
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("No such algorithm : " + algorithm + "!");
            return new byte[0];
        }
    }

    private static long getFileSize(String filePath) throws IOException {
        DU.setExecCommand(filePath);
        DU.execute();
        return Long.parseLong(DU.getOutput().split("\t")[0]);
    }

    private static class DuFileCommand
    extends Shell.ShellCommandExecutor {
        private String[] execCommand;

        DuFileCommand(String[] execString) {
            super(execString);
            this.execCommand = execString;
        }

        void setExecCommand(String filePath) {
            this.execCommand[1] = filePath;
        }

        public String[] getExecString() {
            return this.execCommand;
        }
    }
}

