/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.io.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hudi.org.apache.commons.io.IOUtils;
import org.apache.hudi.org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hudi.org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hudi.org.apache.hadoop.hbase.io.crypto.CipherProvider;
import org.apache.hudi.org.apache.hadoop.hbase.io.crypto.Decryptor;
import org.apache.hudi.org.apache.hadoop.hbase.io.crypto.DefaultCipherProvider;
import org.apache.hudi.org.apache.hadoop.hbase.io.crypto.Encryptor;
import org.apache.hudi.org.apache.hadoop.hbase.io.crypto.KeyProvider;
import org.apache.hudi.org.apache.hadoop.hbase.io.crypto.KeyStoreKeyProvider;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public final class Encryption {
    private static final Logger LOG = LoggerFactory.getLogger(Encryption.class);
    public static final String CRYPTO_ENABLED_CONF_KEY = "hbase.crypto.enabled";
    public static final boolean CRYPTO_ENABLED_CONF_DEFAULT = true;
    public static final String CRYPTO_KEY_HASH_ALGORITHM_CONF_KEY = "hbase.crypto.key.hash.algorithm";
    public static final String CRYPTO_KEY_HASH_ALGORITHM_CONF_DEFAULT = "MD5";
    public static final String CRYPTO_KEY_FAIL_ON_ALGORITHM_MISMATCH_CONF_KEY = "hbase.crypto.key.hash.algorithm.failOnMismatch";
    public static final boolean CRYPTO_KEY_FAIL_ON_ALGORITHM_MISMATCH_CONF_DEFAULT = false;
    static final Map<Pair<String, String>, KeyProvider> keyProviderCache = new ConcurrentHashMap<Pair<String, String>, KeyProvider>();

    public static Context newContext() {
        return new Context();
    }

    public static Context newContext(Configuration conf) {
        return new Context(conf);
    }

    private Encryption() {
    }

    public static boolean isEncryptionEnabled(Configuration conf) {
        return conf.getBoolean(CRYPTO_ENABLED_CONF_KEY, true);
    }

    public static Cipher getCipher(Configuration conf, String name) {
        return Encryption.getCipherProvider(conf).getCipher(name);
    }

    public static String[] getSupportedCiphers() {
        return Encryption.getSupportedCiphers(HBaseConfiguration.create());
    }

    public static String[] getSupportedCiphers(Configuration conf) {
        return Encryption.getCipherProvider(conf).getSupportedCiphers();
    }

    public static String getConfiguredHashAlgorithm(Configuration conf) {
        return conf.getTrimmed(CRYPTO_KEY_HASH_ALGORITHM_CONF_KEY, CRYPTO_KEY_HASH_ALGORITHM_CONF_DEFAULT);
    }

    public static boolean failOnHashAlgorithmMismatch(Configuration conf) {
        return conf.getBoolean(CRYPTO_KEY_FAIL_ON_ALGORITHM_MISMATCH_CONF_KEY, false);
    }

    public static byte[] computeCryptoKeyHash(Configuration conf, byte[] arg) {
        String algorithm = Encryption.getConfiguredHashAlgorithm(conf);
        try {
            return Encryption.hashWithAlg(algorithm, new byte[][]{arg});
        }
        catch (RuntimeException e) {
            String message = String.format("Error in computeCryptoKeyHash (please check your configuration parameter %s and the security provider configuration of the JVM)", CRYPTO_KEY_HASH_ALGORITHM_CONF_KEY);
            throw new RuntimeException(message, e);
        }
    }

    public static byte[] hash128(String ... args) {
        return Encryption.hashWithAlg(CRYPTO_KEY_HASH_ALGORITHM_CONF_DEFAULT, Bytes.toByteArrays(args));
    }

    public static byte[] hash128(byte[] ... args) {
        return Encryption.hashWithAlg(CRYPTO_KEY_HASH_ALGORITHM_CONF_DEFAULT, args);
    }

    public static byte[] hash256(String ... args) {
        return Encryption.hashWithAlg("SHA-256", Bytes.toByteArrays(args));
    }

    public static byte[] hash256(byte[] ... args) {
        return Encryption.hashWithAlg("SHA-256", args);
    }

    public static byte[] pbkdf128(String ... args) {
        StringBuilder sb = new StringBuilder();
        for (String s : args) {
            sb.append(s);
        }
        return Encryption.generateSecretKey("PBKDF2WithHmacSHA1", 16, sb.toString().toCharArray());
    }

    public static byte[] pbkdf128(byte[] ... args) {
        StringBuilder sb = new StringBuilder();
        for (byte[] b : args) {
            sb.append(Arrays.toString(b));
        }
        return Encryption.generateSecretKey("PBKDF2WithHmacSHA1", 16, sb.toString().toCharArray());
    }

    public static byte[] generateSecretKey(Configuration conf, String cypherAlg, String ... args) {
        StringBuilder sb = new StringBuilder();
        for (String s : args) {
            sb.append(s);
        }
        int keyLengthBytes = Encryption.getCipher(conf, cypherAlg).getKeyLength();
        return Encryption.generateSecretKey("PBKDF2WithHmacSHA384", keyLengthBytes, sb.toString().toCharArray());
    }

    public static byte[] generateSecretKey(Configuration conf, String cypherAlg, byte[] ... args) {
        StringBuilder sb = new StringBuilder();
        for (byte[] b : args) {
            sb.append(Arrays.toString(b));
        }
        int keyLength = Encryption.getCipher(conf, cypherAlg).getKeyLength();
        return Encryption.generateSecretKey("PBKDF2WithHmacSHA384", keyLength, sb.toString().toCharArray());
    }

    private static byte[] generateSecretKey(String algorithm, int keyLengthBytes, char[] password) {
        byte[] salt = new byte[keyLengthBytes];
        Bytes.random(salt);
        PBEKeySpec spec = new PBEKeySpec(password, salt, 10000, keyLengthBytes * 8);
        try {
            return SecretKeyFactory.getInstance(algorithm).generateSecret(spec).getEncoded();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encrypt(OutputStream out, byte[] src, int offset, int length, Encryptor e) throws IOException {
        try (OutputStream cout = e.createEncryptionStream(out);){
            cout.write(src, offset, length);
        }
    }

    public static void encrypt(OutputStream out, byte[] src, int offset, int length, Context context, byte[] iv) throws IOException {
        Encryptor e = context.getCipher().getEncryptor();
        e.setKey(context.getKey());
        e.setIv(iv);
        e.reset();
        Encryption.encrypt(out, src, offset, length, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encrypt(OutputStream out, InputStream in, Encryptor e) throws IOException {
        try (OutputStream cout = e.createEncryptionStream(out);){
            IOUtils.copy(in, cout);
        }
    }

    public static void encrypt(OutputStream out, InputStream in, Context context, byte[] iv) throws IOException {
        Encryptor e = context.getCipher().getEncryptor();
        e.setKey(context.getKey());
        e.setIv(iv);
        e.reset();
        Encryption.encrypt(out, in, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decrypt(byte[] dest, int destOffset, InputStream in, int destSize, Decryptor d) throws IOException {
        try (InputStream cin = d.createDecryptionStream(in);){
            IOUtils.readFully(cin, dest, destOffset, destSize);
        }
    }

    public static void decrypt(byte[] dest, int destOffset, InputStream in, int destSize, Context context, byte[] iv) throws IOException {
        Decryptor d = context.getCipher().getDecryptor();
        d.setKey(context.getKey());
        d.setIv(iv);
        Encryption.decrypt(dest, destOffset, in, destSize, d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decrypt(OutputStream out, InputStream in, int outLen, Decryptor d) throws IOException {
        byte[] buf = new byte[8192];
        try (InputStream cin = d.createDecryptionStream(in);){
            int read;
            for (long remaining = (long)outLen; remaining > 0L; remaining -= (long)read) {
                int toRead = (int)(remaining < (long)buf.length ? remaining : (long)buf.length);
                read = cin.read(buf, 0, toRead);
                if (read < 0) {
                    break;
                }
                out.write(buf, 0, read);
            }
        }
    }

    public static void decrypt(OutputStream out, InputStream in, int outLen, Context context, byte[] iv) throws IOException {
        Decryptor d = context.getCipher().getDecryptor();
        d.setKey(context.getKey());
        d.setIv(iv);
        Encryption.decrypt(out, in, outLen, d);
    }

    public static Key getSecretKeyForSubject(String subject, Configuration conf) throws IOException {
        KeyProvider provider = Encryption.getKeyProvider(conf);
        if (provider != null) {
            try {
                Key[] keys = provider.getKeys(new String[]{subject});
                if (keys != null && keys.length > 0) {
                    return keys[0];
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        throw new IOException("No key found for subject '" + subject + "'");
    }

    public static void encryptWithSubjectKey(OutputStream out, InputStream in, String subject, Configuration conf, Cipher cipher, byte[] iv) throws IOException {
        Key key = Encryption.getSecretKeyForSubject(subject, conf);
        if (key == null) {
            throw new IOException("No key found for subject '" + subject + "'");
        }
        Encryptor e = cipher.getEncryptor();
        e.setKey(key);
        e.setIv(iv);
        Encryption.encrypt(out, in, e);
    }

    public static void decryptWithSubjectKey(OutputStream out, InputStream in, int outLen, String subject, Configuration conf, Cipher cipher, byte[] iv) throws IOException {
        Key key = Encryption.getSecretKeyForSubject(subject, conf);
        if (key == null) {
            throw new IOException("No key found for subject '" + subject + "'");
        }
        Decryptor d = cipher.getDecryptor();
        d.setKey(key);
        d.setIv(iv);
        try {
            Encryption.decrypt(out, in, outLen, d);
        }
        catch (IOException e) {
            String alternateAlgorithm = conf.get("hbase.crypto.alternate.key.algorithm");
            if (alternateAlgorithm != null) {
                Cipher alterCipher;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Unable to decrypt data with current cipher algorithm '" + conf.get("hbase.crypto.key.algorithm", "AES") + "'. Trying with the alternate cipher algorithm '" + alternateAlgorithm + "' configured.");
                }
                if ((alterCipher = Encryption.getCipher(conf, alternateAlgorithm)) == null) {
                    throw new RuntimeException("Cipher '" + alternateAlgorithm + "' not available");
                }
                d = alterCipher.getDecryptor();
                d.setKey(key);
                d.setIv(iv);
                Encryption.decrypt(out, in, outLen, d);
            }
            throw new IOException(e);
        }
    }

    private static ClassLoader getClassLoaderForClass(Class<?> c) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = c.getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if (cl == null) {
            throw new RuntimeException("A ClassLoader to load the Cipher could not be determined");
        }
        return cl;
    }

    public static CipherProvider getCipherProvider(Configuration conf) {
        String providerClassName = conf.get("hbase.crypto.cipherprovider", DefaultCipherProvider.class.getName());
        try {
            CipherProvider provider = (CipherProvider)ReflectionUtils.newInstance(Encryption.getClassLoaderForClass(CipherProvider.class).loadClass(providerClassName), (Configuration)conf);
            return provider;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyProvider getKeyProvider(Configuration conf) {
        String providerClassName = conf.get("hbase.crypto.keyprovider", KeyStoreKeyProvider.class.getName());
        String providerParameters = conf.get("hbase.crypto.keyprovider.parameters", "");
        try {
            Pair<String, String> providerCacheKey = new Pair<String, String>(providerClassName, providerParameters);
            KeyProvider provider = keyProviderCache.get(providerCacheKey);
            if (provider != null) {
                return provider;
            }
            provider = (KeyProvider)ReflectionUtils.newInstance(Encryption.getClassLoaderForClass(KeyProvider.class).loadClass(providerClassName), (Configuration)conf);
            provider.init(providerParameters);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Installed " + providerClassName + " into key provider cache");
            }
            keyProviderCache.put(providerCacheKey, provider);
            return provider;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void incrementIv(byte[] iv) {
        Encryption.incrementIv(iv, 1);
    }

    public static void incrementIv(byte[] iv, int v) {
        int length = iv.length;
        boolean carry = true;
        do {
            for (int i = 0; i < length && carry; ++i) {
                iv[i] = (byte)(iv[i] + 1 & 0xFF);
                carry = 0 == iv[i];
            }
        } while (--v > 0);
    }

    public static byte[] hashWithAlg(String algorithm, byte[] ... args) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            for (byte[] arg : args) {
                md.update(arg);
            }
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("unable to use hash algorithm: " + algorithm, e);
        }
    }

    @InterfaceAudience.Public
    public static class Context
    extends org.apache.hudi.org.apache.hadoop.hbase.io.crypto.Context {
        public static final Context NONE = new Context();

        private Context() {
        }

        private Context(Configuration conf) {
            super(conf);
        }

        @Override
        public Context setCipher(Cipher cipher) {
            super.setCipher(cipher);
            return this;
        }

        @Override
        public Context setKey(Key key) {
            super.setKey(key);
            return this;
        }

        public Context setKey(byte[] key) {
            super.setKey(new SecretKeySpec(key, this.getCipher().getName()));
            return this;
        }
    }
}

