/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.Abortable;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.client.Admin;
import org.apache.hudi.org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hudi.org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hudi.org.apache.hadoop.hbase.client.Hbck;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hudi.org.apache.hadoop.hbase.client.Table;
import org.apache.hudi.org.apache.hadoop.hbase.client.TableBuilder;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface Connection
extends Abortable,
Closeable {
    public Configuration getConfiguration();

    default public Table getTable(TableName tableName) throws IOException {
        return this.getTable(tableName, null);
    }

    default public Table getTable(TableName tableName, ExecutorService pool) throws IOException {
        return this.getTableBuilder(tableName, pool).build();
    }

    public BufferedMutator getBufferedMutator(TableName var1) throws IOException;

    public BufferedMutator getBufferedMutator(BufferedMutatorParams var1) throws IOException;

    public RegionLocator getRegionLocator(TableName var1) throws IOException;

    public void clearRegionLocationCache();

    public Admin getAdmin() throws IOException;

    @Override
    public void close() throws IOException;

    public boolean isClosed();

    public TableBuilder getTableBuilder(TableName var1, ExecutorService var2);

    @InterfaceAudience.LimitedPrivate(value={"HBCK"})
    default public Hbck getHbck() throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @InterfaceAudience.LimitedPrivate(value={"HBCK"})
    default public Hbck getHbck(ServerName masterServer) throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }
}

