/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.avro.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.hudi.org.apache.avro.io.BinaryData;

public class Utf8
implements Comparable<Utf8>,
CharSequence {
    private static final byte[] EMPTY = new byte[0];
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private byte[] bytes = EMPTY;
    private int length;
    private String string;
    private static final Utf8Converter UTF8_CONVERTER = System.getProperty("java.version").startsWith("1.6.") ? new Utf8Converter(){

        @Override
        public String fromUtf8(byte[] bytes, int length) {
            try {
                return new String(bytes, 0, length, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public byte[] toUtf8(String str) {
            try {
                return str.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    } : new Utf8Converter(){

        @Override
        public String fromUtf8(byte[] bytes, int length) {
            return new String(bytes, 0, length, UTF8);
        }

        @Override
        public byte[] toUtf8(String str) {
            return str.getBytes(UTF8);
        }
    };

    public Utf8() {
    }

    public Utf8(String string) {
        this.bytes = Utf8.getBytesFor(string);
        this.length = this.bytes.length;
        this.string = string;
    }

    public Utf8(Utf8 other) {
        this.length = other.length;
        this.bytes = new byte[other.length];
        System.arraycopy(other.bytes, 0, this.bytes, 0, this.length);
        this.string = other.string;
    }

    public Utf8(byte[] bytes) {
        this.bytes = bytes;
        this.length = bytes.length;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getLength() {
        return this.length;
    }

    public int getByteLength() {
        return this.length;
    }

    public Utf8 setLength(int newLength) {
        return this.setByteLength(newLength);
    }

    public Utf8 setByteLength(int newLength) {
        if (this.bytes.length < newLength) {
            byte[] newBytes = new byte[newLength];
            System.arraycopy(this.bytes, 0, newBytes, 0, this.length);
            this.bytes = newBytes;
        }
        this.length = newLength;
        this.string = null;
        return this;
    }

    public Utf8 set(String string) {
        this.bytes = Utf8.getBytesFor(string);
        this.length = this.bytes.length;
        this.string = string;
        return this;
    }

    @Override
    public String toString() {
        if (this.length == 0) {
            return "";
        }
        if (this.string == null) {
            this.string = UTF8_CONVERTER.fromUtf8(this.bytes, this.length);
        }
        return this.string;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Utf8)) {
            return false;
        }
        Utf8 that = (Utf8)o;
        if (this.length != that.length) {
            return false;
        }
        byte[] thatBytes = that.bytes;
        for (int i = 0; i < this.length; ++i) {
            if (this.bytes[i] == thatBytes[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.length; ++i) {
            hash = hash * 31 + this.bytes[i];
        }
        return hash;
    }

    @Override
    public int compareTo(Utf8 that) {
        return BinaryData.compareBytes(this.bytes, 0, this.length, that.bytes, 0, that.length);
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    public static final byte[] getBytesFor(String str) {
        return UTF8_CONVERTER.toUtf8(str);
    }

    private static abstract class Utf8Converter {
        private Utf8Converter() {
        }

        public abstract String fromUtf8(byte[] var1, int var2);

        public abstract byte[] toUtf8(String var1);
    }
}

