/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hudi.common.fs.SizeAwareDataInputStream;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SerializationUtils;
import org.apache.hudi.exception.HoodieIOException;

public class HoodieDeleteBlock
extends HoodieLogBlock {
    private DeleteRecord[] recordsToDelete;

    public HoodieDeleteBlock(DeleteRecord[] recordsToDelete, Map<HoodieLogBlock.HeaderMetadataType, String> header) {
        this(Option.empty(), null, false, Option.empty(), header, new HashMap<HoodieLogBlock.HeaderMetadataType, String>());
        this.recordsToDelete = recordsToDelete;
    }

    public HoodieDeleteBlock(Option<byte[]> content, FSDataInputStream inputStream, boolean readBlockLazily, Option<HoodieLogBlock.HoodieLogBlockContentLocation> blockContentLocation, Map<HoodieLogBlock.HeaderMetadataType, String> header, Map<HoodieLogBlock.HeaderMetadataType, String> footer) {
        super(header, footer, blockContentLocation, content, inputStream, readBlockLazily);
    }

    @Override
    public byte[] getContentBytes() throws IOException {
        Option<byte[]> content = this.getContent();
        if (content.isPresent()) {
            return content.get();
        }
        if (this.readBlockLazily && this.recordsToDelete == null) {
            this.getRecordsToDelete();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(baos);
        byte[] bytesToWrite = SerializationUtils.serialize(this.getRecordsToDelete());
        output.writeInt(version);
        output.writeInt(bytesToWrite.length);
        output.write(bytesToWrite);
        return baos.toByteArray();
    }

    public DeleteRecord[] getRecordsToDelete() {
        try {
            if (this.recordsToDelete == null) {
                if (!this.getContent().isPresent() && this.readBlockLazily) {
                    this.inflate();
                }
                SizeAwareDataInputStream dis = new SizeAwareDataInputStream(new DataInputStream(new ByteArrayInputStream(this.getContent().get())));
                int version = dis.readInt();
                int dataLength = dis.readInt();
                byte[] data = new byte[dataLength];
                dis.readFully(data);
                this.recordsToDelete = HoodieDeleteBlock.deserialize(version, data);
                this.deflate();
            }
            return this.recordsToDelete;
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to generate keys to delete from block content", io);
        }
    }

    private static DeleteRecord[] deserialize(int version, byte[] data) {
        if (version == 1) {
            HoodieKey[] keys = (HoodieKey[])SerializationUtils.deserialize(data);
            return (DeleteRecord[])Arrays.stream(keys).map(DeleteRecord::create).toArray(DeleteRecord[]::new);
        }
        return (DeleteRecord[])SerializationUtils.deserialize(data);
    }

    @Override
    public HoodieLogBlock.HoodieLogBlockType getBlockType() {
        return HoodieLogBlock.HoodieLogBlockType.DELETE_BLOCK;
    }
}

