/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.fs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.hadoop.fs.CachingPath;

public class SerializablePath
implements Serializable {
    private Path path;

    public SerializablePath(Path path) {
        this.path = path;
    }

    public Path get() {
        return this.path;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.path.toUri());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        URI uri = (URI)in.readObject();
        this.path = new CachingPath(uri);
    }

    public String toString() {
        return this.path.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializablePath that = (SerializablePath)o;
        return Objects.equals(this.path, that.path);
    }
}

