/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.util.regex.Pattern;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class VisibilityLabelsValidator {
    private static final boolean[] validAuthChars;
    public static final String regex = "[A-Za-z_\\-\\:\\/\\.0-9]+";
    public static final Pattern pattern;

    static final boolean isValidAuthChar(byte b) {
        return validAuthChars[0xFF & b];
    }

    public static final boolean isValidLabel(byte[] label) {
        for (int i = 0; i < label.length; ++i) {
            if (VisibilityLabelsValidator.isValidAuthChar(label[i])) continue;
            return false;
        }
        return true;
    }

    static {
        int i;
        validAuthChars = new boolean[256];
        pattern = Pattern.compile(regex);
        for (i = 0; i < 256; ++i) {
            VisibilityLabelsValidator.validAuthChars[i] = false;
        }
        for (i = 97; i <= 122; ++i) {
            VisibilityLabelsValidator.validAuthChars[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            VisibilityLabelsValidator.validAuthChars[i] = true;
        }
        for (i = 48; i <= 57; ++i) {
            VisibilityLabelsValidator.validAuthChars[i] = true;
        }
        VisibilityLabelsValidator.validAuthChars[95] = true;
        VisibilityLabelsValidator.validAuthChars[45] = true;
        VisibilityLabelsValidator.validAuthChars[58] = true;
        VisibilityLabelsValidator.validAuthChars[46] = true;
        VisibilityLabelsValidator.validAuthChars[47] = true;
    }
}

