/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.client.cli.YarnCLI;
import org.apache.hadoop.yarn.exceptions.YarnException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NodeCLI
extends YarnCLI {
    private static final String NODES_PATTERN = "%16s\t%15s\t%17s\t%28s" + System.getProperty("line.separator");
    private static final String NODE_STATE_CMD = "states";
    private static final String NODE_ALL = "all";
    private static final String NODE_SHOW_DETAILS = "showDetails";

    public static void main(String[] args) throws Exception {
        NodeCLI cli = new NodeCLI();
        cli.setSysOutPrintStream(System.out);
        cli.setSysErrPrintStream(System.err);
        int res = ToolRunner.run((Tool)cli, (String[])args);
        cli.stop();
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        Options opts = new Options();
        opts.addOption("help", false, "Displays help for all commands.");
        opts.addOption("status", true, "Prints the status report of the node.");
        opts.addOption("list", false, "List all running nodes. Supports optional use of -states to filter nodes based on node state, all -all to list all nodes, -showDetails to display more details about each node.");
        Option nodeStateOpt = new Option(NODE_STATE_CMD, true, "Works with -list to filter nodes based on input comma-separated list of node states. " + this.getAllValidNodeStates());
        nodeStateOpt.setValueSeparator(',');
        nodeStateOpt.setArgs(-2);
        nodeStateOpt.setArgName("States");
        opts.addOption(nodeStateOpt);
        Option allOpt = new Option(NODE_ALL, false, "Works with -list to list all nodes.");
        opts.addOption(allOpt);
        Option showDetailsOpt = new Option(NODE_SHOW_DETAILS, false, "Works with -list to show more details about each node.");
        opts.addOption(showDetailsOpt);
        opts.getOption("status").setArgName("NodeId");
        if (args != null && args.length > 0) {
            for (int i = args.length - 1; i >= 0; --i) {
                if (!args[i].equalsIgnoreCase("-all")) continue;
                args[i] = "-all";
            }
        }
        int exitCode = -1;
        CommandLine cliParser = null;
        try {
            cliParser = new GnuParser().parse(opts, args);
        }
        catch (MissingArgumentException ex) {
            this.sysout.println("Missing argument for options");
            this.printUsage(opts);
            return exitCode;
        }
        this.createAndStartYarnClient();
        if (cliParser.hasOption("status")) {
            if (args.length != 2) {
                this.printUsage(opts);
                return exitCode;
            }
            this.printNodeStatus(cliParser.getOptionValue("status"));
        } else if (cliParser.hasOption("list")) {
            HashSet<NodeState> nodeStates = new HashSet<NodeState>();
            if (cliParser.hasOption(NODE_ALL)) {
                for (NodeState state : NodeState.values()) {
                    nodeStates.add(state);
                }
            } else if (cliParser.hasOption(NODE_STATE_CMD)) {
                String[] types = cliParser.getOptionValues(NODE_STATE_CMD);
                if (types != null) {
                    for (String type : types) {
                        if (type.trim().isEmpty()) continue;
                        try {
                            nodeStates.add(NodeState.valueOf((String)org.apache.hadoop.util.StringUtils.toUpperCase((String)type.trim())));
                        }
                        catch (IllegalArgumentException ex) {
                            this.sysout.println("The node state " + type + " is invalid.");
                            this.sysout.println(this.getAllValidNodeStates());
                            return exitCode;
                        }
                    }
                }
            } else {
                nodeStates.add(NodeState.RUNNING);
            }
            if (cliParser.hasOption(NODE_SHOW_DETAILS)) {
                this.listDetailedClusterNodes(nodeStates);
            } else {
                this.listClusterNodes(nodeStates);
            }
        } else {
            if (cliParser.hasOption("help")) {
                this.printUsage(opts);
                return 0;
            }
            this.syserr.println("Invalid Command Usage : ");
            this.printUsage(opts);
        }
        return 0;
    }

    private void printUsage(Options opts) {
        new HelpFormatter().printHelp("node", opts);
    }

    private void listClusterNodes(Set<NodeState> nodeStates) throws YarnException, IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.sysout, Charset.forName("UTF-8")));
        List<NodeReport> nodesReport = this.client.getNodeReports(nodeStates.toArray(new NodeState[0]));
        writer.println("Total Nodes:" + nodesReport.size());
        writer.printf(NODES_PATTERN, "Node-Id", "Node-State", "Node-Http-Address", "Number-of-Running-Containers");
        for (NodeReport nodeReport : nodesReport) {
            writer.printf(NODES_PATTERN, nodeReport.getNodeId(), nodeReport.getNodeState(), nodeReport.getHttpAddress(), nodeReport.getNumContainers());
        }
        writer.flush();
    }

    private void listDetailedClusterNodes(Set<NodeState> nodeStates) throws YarnException, IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.sysout, Charset.forName("UTF-8")));
        List<NodeReport> nodesReport = this.client.getNodeReports(nodeStates.toArray(new NodeState[0]));
        writer.println("Total Nodes:" + nodesReport.size());
        writer.printf(NODES_PATTERN, "Node-Id", "Node-State", "Node-Http-Address", "Number-of-Running-Containers");
        for (NodeReport nodeReport : nodesReport) {
            writer.printf(NODES_PATTERN, nodeReport.getNodeId(), nodeReport.getNodeState(), nodeReport.getHttpAddress(), nodeReport.getNumContainers());
            writer.println("Detailed Node Information :");
            writer.print("\tConfigured Resources : ");
            writer.println(nodeReport.getCapability());
            writer.print("\tAllocated Resources : ");
            if (nodeReport.getUsed() != null) {
                writer.print(nodeReport.getUsed());
            }
            writer.println();
            writer.print("\tResource Utilization by Node : ");
            if (nodeReport.getNodeUtilization() != null) {
                writer.print("PMem:" + nodeReport.getNodeUtilization().getPhysicalMemory() + " MB, VMem:" + nodeReport.getNodeUtilization().getVirtualMemory() + " MB, VCores:" + nodeReport.getNodeUtilization().getCPU());
            }
            writer.println();
            writer.print("\tResource Utilization by Containers : ");
            if (nodeReport.getAggregatedContainersUtilization() != null) {
                writer.print("PMem:" + nodeReport.getAggregatedContainersUtilization().getPhysicalMemory() + " MB, VMem:" + nodeReport.getAggregatedContainersUtilization().getVirtualMemory() + " MB, VCores:" + nodeReport.getAggregatedContainersUtilization().getCPU());
            }
            writer.println();
            writer.print("\tNode-Labels : ");
            ArrayList nodeLabelsList = new ArrayList(nodeReport.getNodeLabels());
            Collections.sort(nodeLabelsList);
            writer.println(StringUtils.join(nodeLabelsList.iterator(), (char)','));
        }
        writer.flush();
    }

    private void printNodeStatus(String nodeIdStr) throws YarnException, IOException {
        NodeId nodeId = NodeId.fromString((String)nodeIdStr);
        List<NodeReport> nodesReport = this.client.getNodeReports(new NodeState[0]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter nodeReportStr = new PrintWriter(new OutputStreamWriter((OutputStream)baos, Charset.forName("UTF-8")));
        NodeReport nodeReport = null;
        for (NodeReport report : nodesReport) {
            if (!report.getNodeId().equals((Object)nodeId)) continue;
            nodeReport = report;
            nodeReportStr.println("Node Report : ");
            nodeReportStr.print("\tNode-Id : ");
            nodeReportStr.println(nodeReport.getNodeId());
            nodeReportStr.print("\tRack : ");
            nodeReportStr.println(nodeReport.getRackName());
            nodeReportStr.print("\tNode-State : ");
            nodeReportStr.println(nodeReport.getNodeState());
            nodeReportStr.print("\tNode-Http-Address : ");
            nodeReportStr.println(nodeReport.getHttpAddress());
            nodeReportStr.print("\tLast-Health-Update : ");
            nodeReportStr.println(DateFormatUtils.format((Date)new Date(nodeReport.getLastHealthReportTime()), (String)"E dd/MMM/yy hh:mm:ss:SSzz"));
            nodeReportStr.print("\tHealth-Report : ");
            nodeReportStr.println(nodeReport.getHealthReport());
            nodeReportStr.print("\tContainers : ");
            nodeReportStr.println(nodeReport.getNumContainers());
            nodeReportStr.print("\tMemory-Used : ");
            nodeReportStr.println(nodeReport.getUsed() == null ? "0MB" : nodeReport.getUsed().getMemorySize() + "MB");
            nodeReportStr.print("\tMemory-Capacity : ");
            nodeReportStr.println(nodeReport.getCapability().getMemorySize() + "MB");
            nodeReportStr.print("\tCPU-Used : ");
            nodeReportStr.println(nodeReport.getUsed() == null ? "0 vcores" : nodeReport.getUsed().getVirtualCores() + " vcores");
            nodeReportStr.print("\tCPU-Capacity : ");
            nodeReportStr.println(nodeReport.getCapability().getVirtualCores() + " vcores");
            nodeReportStr.print("\tNode-Labels : ");
            ArrayList nodeLabelsList = new ArrayList(report.getNodeLabels());
            Collections.sort(nodeLabelsList);
            nodeReportStr.println(StringUtils.join(nodeLabelsList.iterator(), (char)','));
            if (nodeReport.getNodeAttributes().size() > 0) {
                ArrayList nodeAtrs = new ArrayList(nodeReport.getNodeAttributes());
                nodeReportStr.print("\tNode Attributes : ");
                nodeReportStr.println(nodeAtrs.get(0).toString());
                for (int index = 1; index < nodeAtrs.size(); ++index) {
                    nodeReportStr.println(String.format("\t%18s%s", "", nodeAtrs.get(index).toString()));
                }
            } else {
                nodeReportStr.println("\tNode Attributes : ");
            }
            nodeReportStr.print("\tResource Utilization by Node : ");
            if (nodeReport.getNodeUtilization() != null) {
                nodeReportStr.print("PMem:" + nodeReport.getNodeUtilization().getPhysicalMemory() + " MB, VMem:" + nodeReport.getNodeUtilization().getVirtualMemory() + " MB, VCores:" + nodeReport.getNodeUtilization().getCPU());
            }
            nodeReportStr.println();
            nodeReportStr.print("\tResource Utilization by Containers : ");
            if (nodeReport.getAggregatedContainersUtilization() != null) {
                nodeReportStr.print("PMem:" + nodeReport.getAggregatedContainersUtilization().getPhysicalMemory() + " MB, VMem:" + nodeReport.getAggregatedContainersUtilization().getVirtualMemory() + " MB, VCores:" + nodeReport.getAggregatedContainersUtilization().getCPU());
            }
            nodeReportStr.println();
        }
        if (nodeReport == null) {
            nodeReportStr.print("Could not find the node report for node id : " + nodeIdStr);
        }
        nodeReportStr.close();
        this.sysout.println(baos.toString("UTF-8"));
    }

    private String getAllValidNodeStates() {
        StringBuilder sb = new StringBuilder();
        sb.append("The valid node state can be one of the following: ");
        for (NodeState state : NodeState.values()) {
            sb.append(state).append(",");
        }
        String output = sb.toString();
        return output.substring(0, output.length() - 1) + ".";
    }
}

